# coding: utf-8

"""
    Airflow API

    Airflow API. All endpoints located under ``/api/v2`` can be used safely, are stable and backward compatible. Endpoints located under ``/ui`` are dedicated to the UI and are subject to breaking change depending on the need of the frontend. Users should not rely on those but use the public ones instead.

    The version of the OpenAPI document: 2
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from airflow_client.client.models.base_info_response import BaseInfoResponse
from airflow_client.client.models.dag_processor_info_response import DagProcessorInfoResponse
from airflow_client.client.models.scheduler_info_response import SchedulerInfoResponse
from airflow_client.client.models.triggerer_info_response import TriggererInfoResponse
from typing import Optional, Set
from typing_extensions import Self

class HealthInfoResponse(BaseModel):
    """
    Health serializer for responses.
    """ # noqa: E501
    dag_processor: Optional[DagProcessorInfoResponse] = None
    metadatabase: BaseInfoResponse
    scheduler: SchedulerInfoResponse
    triggerer: TriggererInfoResponse
    __properties: ClassVar[List[str]] = ["dag_processor", "metadatabase", "scheduler", "triggerer"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of HealthInfoResponse from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of dag_processor
        if self.dag_processor:
            _dict['dag_processor'] = self.dag_processor.to_dict()
        # override the default output from pydantic by calling `to_dict()` of metadatabase
        if self.metadatabase:
            _dict['metadatabase'] = self.metadatabase.to_dict()
        # override the default output from pydantic by calling `to_dict()` of scheduler
        if self.scheduler:
            _dict['scheduler'] = self.scheduler.to_dict()
        # override the default output from pydantic by calling `to_dict()` of triggerer
        if self.triggerer:
            _dict['triggerer'] = self.triggerer.to_dict()
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of HealthInfoResponse from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "dag_processor": DagProcessorInfoResponse.from_dict(obj["dag_processor"]) if obj.get("dag_processor") is not None else None,
            "metadatabase": BaseInfoResponse.from_dict(obj["metadatabase"]) if obj.get("metadatabase") is not None else None,
            "scheduler": SchedulerInfoResponse.from_dict(obj["scheduler"]) if obj.get("scheduler") is not None else None,
            "triggerer": TriggererInfoResponse.from_dict(obj["triggerer"]) if obj.get("triggerer") is not None else None
        })
        return _obj


