/*
 * Decompiled with CFR 0.152.
 */
package io.grpc.internal.testing;

import com.google.common.base.Throwables;
import io.grpc.internal.ConscryptLoader;
import io.grpc.testing.TlsTesting;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManagerFactory;
import javax.security.auth.x500.X500Principal;

public class TestUtils {
    public static final String TEST_SERVER_HOST = "foo.test.google.fr";
    private static boolean conscryptInstallAttempted;

    public static InetSocketAddress testServerAddress(String host, int port) {
        try {
            InetAddress inetAddress = InetAddress.getByName(host);
            inetAddress = InetAddress.getByAddress(TEST_SERVER_HOST, inetAddress.getAddress());
            return new InetSocketAddress(inetAddress, port);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static InetSocketAddress testServerAddress(InetSocketAddress originalSockAddr) {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            inetAddress = InetAddress.getByAddress(TEST_SERVER_HOST, inetAddress.getAddress());
            return new InetSocketAddress(inetAddress, originalSockAddr.getPort());
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    public static List<InetSocketAddress> testServerAddresses(InetSocketAddress ... originalSockAddr) {
        try {
            InetAddress inetAddress = InetAddress.getByName("localhost");
            inetAddress = InetAddress.getByAddress(TEST_SERVER_HOST, inetAddress.getAddress());
            ArrayList<InetSocketAddress> addresses = new ArrayList<InetSocketAddress>();
            for (InetSocketAddress orig : originalSockAddr) {
                addresses.add(new InetSocketAddress(inetAddress, orig.getPort()));
            }
            return addresses;
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static File loadCert(String name) throws IOException {
        BufferedInputStream in = new BufferedInputStream(TlsTesting.loadCert(name));
        File tmpFile = File.createTempFile(name, "");
        tmpFile.deleteOnExit();
        BufferedOutputStream os = new BufferedOutputStream(new FileOutputStream(tmpFile));
        try {
            int b;
            while ((b = ((InputStream)in).read()) != -1) {
                ((OutputStream)os).write(b);
            }
            ((OutputStream)os).flush();
        }
        finally {
            ((InputStream)in).close();
            ((OutputStream)os).close();
        }
        return tmpFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static X509Certificate loadX509Cert(String fileName) throws CertificateException, IOException {
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (InputStream in = TlsTesting.loadCert(fileName);){
            X509Certificate x509Certificate = (X509Certificate)cf.generateCertificate(in);
            return x509Certificate;
        }
    }

    public static void installConscryptIfAvailable() {
        Provider provider;
        if (conscryptInstallAttempted) {
            return;
        }
        if (System.mapLibraryName("test").endsWith(".dll")) {
            conscryptInstallAttempted = true;
            return;
        }
        String osArch = System.getProperty("os.arch", "");
        if (osArch.startsWith("aarch") || osArch.startsWith("arm")) {
            conscryptInstallAttempted = true;
            return;
        }
        if (!ConscryptLoader.isPresent()) {
            conscryptInstallAttempted = true;
            return;
        }
        try {
            provider = ConscryptLoader.newProvider();
        }
        catch (Throwable t) {
            Throwable root = Throwables.getRootCause((Throwable)t);
            if (root instanceof UnsatisfiedLinkError && root.getMessage() != null && root.getMessage().contains("GLIBC_2.14")) {
                conscryptInstallAttempted = true;
                return;
            }
            throw new RuntimeException("Could not create Conscrypt provider", t);
        }
        Security.addProvider(provider);
        conscryptInstallAttempted = true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static SSLSocketFactory newSslSocketFactoryForCa(Provider provider, File certChainFile) throws Exception {
        KeyStore ks = KeyStore.getInstance(KeyStore.getDefaultType());
        ks.load(null, null);
        CertificateFactory cf = CertificateFactory.getInstance("X.509");
        try (BufferedInputStream in = new BufferedInputStream(new FileInputStream(certChainFile));){
            X509Certificate cert = (X509Certificate)cf.generateCertificate(in);
            X500Principal principal = cert.getSubjectX500Principal();
            ks.setCertificateEntry(principal.getName("RFC2253"), cert);
        }
        TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(TrustManagerFactory.getDefaultAlgorithm());
        trustManagerFactory.init(ks);
        SSLContext context = SSLContext.getInstance("TLS", provider);
        context.init(null, trustManagerFactory.getTrustManagers(), null);
        return context.getSocketFactory();
    }

    private TestUtils() {
    }
}

