/*
 * Decompiled with CFR 0.152.
 */
package org.apache.zookeeper.test;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import org.apache.zookeeper.ZKTestCase;
import org.apache.zookeeper.common.AtomicFileOutputStream;
import org.apache.zookeeper.test.ClientBase;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class AtomicFileOutputStreamTest
extends ZKTestCase {
    private static final String TEST_STRING = "hello world";
    private static final String TEST_STRING_2 = "goodbye world";
    private File testDir;
    private File dstFile;

    @BeforeEach
    public void setupTestDir() throws IOException {
        this.testDir = ClientBase.createEmptyTestDir();
        this.dstFile = new File(this.testDir, "test.txt");
    }

    @AfterEach
    public void cleanupTestDir() throws IOException {
        ClientBase.recursiveDelete(this.testDir);
    }

    @Test
    public void testWriteNewFile() throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(this.dstFile);
        Assertions.assertFalse((boolean)this.dstFile.exists());
        fos.write(TEST_STRING.getBytes());
        fos.flush();
        Assertions.assertFalse((boolean)this.dstFile.exists());
        fos.close();
        Assertions.assertTrue((boolean)this.dstFile.exists());
        String readBackData = new String(Files.readAllBytes(this.dstFile.toPath()), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)TEST_STRING, (Object)readBackData);
    }

    @Test
    public void testOverwriteFile() throws IOException {
        Assertions.assertTrue((boolean)this.dstFile.createNewFile(), (String)"Creating empty dst file");
        AtomicFileOutputStream fos = new AtomicFileOutputStream(this.dstFile);
        Assertions.assertTrue((boolean)this.dstFile.exists(), (String)"Empty file still exists");
        fos.write(TEST_STRING.getBytes());
        fos.flush();
        Assertions.assertEquals((Object)"", (Object)new String(Files.readAllBytes(this.dstFile.toPath()), StandardCharsets.UTF_8));
        fos.close();
        String readBackData = new String(Files.readAllBytes(this.dstFile.toPath()), StandardCharsets.UTF_8);
        Assertions.assertEquals((Object)TEST_STRING, (Object)readBackData);
    }

    @Test
    public void testFailToFlush() throws IOException {
        FileOutputStream fos = new FileOutputStream(this.dstFile);
        fos.write(TEST_STRING_2.getBytes());
        fos.close();
        OutputStream failingStream = this.createFailingStream();
        failingStream.write(TEST_STRING.getBytes());
        try {
            failingStream.close();
            Assertions.fail((String)"Close didn't throw exception");
        }
        catch (IOException iOException) {
            // empty catch block
        }
        Assertions.assertEquals((Object)TEST_STRING_2, (Object)new String(Files.readAllBytes(this.dstFile.toPath()), StandardCharsets.UTF_8));
        Assertions.assertEquals((Object)this.dstFile.getName(), (Object)String.join((CharSequence)",", this.testDir.list()), (String)"Temporary file should have been cleaned up");
    }

    private OutputStream createFailingStream() throws FileNotFoundException {
        return new AtomicFileOutputStream(this.dstFile){

            public void flush() throws IOException {
                throw new IOException("injected failure");
            }
        };
    }

    @Test
    public void testAbortNewFile() throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(this.dstFile);
        fos.abort();
        Assertions.assertEquals((int)0, (int)this.testDir.list().length);
    }

    @Test
    public void testAbortNewFileAfterFlush() throws IOException {
        AtomicFileOutputStream fos = new AtomicFileOutputStream(this.dstFile);
        fos.write(TEST_STRING.getBytes());
        fos.flush();
        fos.abort();
        Assertions.assertEquals((int)0, (int)this.testDir.list().length);
    }

    @Test
    public void testAbortExistingFile() throws IOException {
        FileOutputStream fos1 = new FileOutputStream(this.dstFile);
        fos1.write(TEST_STRING.getBytes());
        fos1.close();
        AtomicFileOutputStream fos2 = new AtomicFileOutputStream(this.dstFile);
        fos2.abort();
        Assertions.assertEquals((Object)TEST_STRING, (Object)new String(Files.readAllBytes(this.dstFile.toPath()), StandardCharsets.UTF_8));
        Assertions.assertEquals((int)1, (int)this.testDir.list().length);
    }

    @Test
    public void testAbortExistingFileAfterFlush() throws IOException {
        FileOutputStream fos1 = new FileOutputStream(this.dstFile);
        fos1.write(TEST_STRING.getBytes());
        fos1.close();
        AtomicFileOutputStream fos2 = new AtomicFileOutputStream(this.dstFile);
        fos2.write(TEST_STRING_2.getBytes());
        fos2.flush();
        fos2.abort();
        Assertions.assertEquals((Object)TEST_STRING, (Object)new String(Files.readAllBytes(this.dstFile.toPath()), StandardCharsets.UTF_8));
        Assertions.assertEquals((int)1, (int)this.testDir.list().length);
    }
}

