/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cassandra.cql3.functions;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.math.RoundingMode;
import java.nio.ByteBuffer;
import java.util.List;
import org.apache.cassandra.cql3.functions.AggregateFunction;
import org.apache.cassandra.cql3.functions.Arguments;
import org.apache.cassandra.cql3.functions.FunctionArguments;
import org.apache.cassandra.cql3.functions.FunctionFactory;
import org.apache.cassandra.cql3.functions.FunctionParameter;
import org.apache.cassandra.cql3.functions.NativeAggregateFunction;
import org.apache.cassandra.cql3.functions.NativeFunction;
import org.apache.cassandra.cql3.functions.NativeFunctions;
import org.apache.cassandra.db.marshal.AbstractType;
import org.apache.cassandra.db.marshal.ByteType;
import org.apache.cassandra.db.marshal.BytesType;
import org.apache.cassandra.db.marshal.CounterColumnType;
import org.apache.cassandra.db.marshal.DecimalType;
import org.apache.cassandra.db.marshal.DoubleType;
import org.apache.cassandra.db.marshal.FloatType;
import org.apache.cassandra.db.marshal.Int32Type;
import org.apache.cassandra.db.marshal.IntegerType;
import org.apache.cassandra.db.marshal.LongType;
import org.apache.cassandra.db.marshal.ShortType;
import org.apache.cassandra.exceptions.InvalidRequestException;
import org.apache.cassandra.transport.ProtocolVersion;

public abstract class AggregateFcts {
    public static final CountRowsFunction countRowsFunction = new CountRowsFunction(false);
    public static final NativeAggregateFunction sumFunctionForDecimal = new NativeAggregateFunction("sum", (AbstractType)DecimalType.instance, new AbstractType[]{DecimalType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private BigDecimal sum = BigDecimal.ZERO;

                @Override
                public void reset() {
                    this.sum = BigDecimal.ZERO;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return ((DecimalType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(Arguments arguments) {
                    BigDecimal number = (BigDecimal)arguments.get(0);
                    if (number == null) {
                        return;
                    }
                    this.sum = this.sum.add(number);
                }
            };
        }
    };
    public static final NativeAggregateFunction avgFunctionForDecimal = new NativeAggregateFunction("avg", (AbstractType)DecimalType.instance, new AbstractType[]{DecimalType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private BigDecimal avg = BigDecimal.ZERO;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.avg = BigDecimal.ZERO;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return DecimalType.instance.decompose(this.avg);
                }

                @Override
                public void addInput(Arguments arguments) {
                    BigDecimal number = (BigDecimal)arguments.get(0);
                    if (number == null) {
                        return;
                    }
                    ++this.count;
                    this.avg = this.avg.add(number.subtract(this.avg).divide(BigDecimal.valueOf(this.count), RoundingMode.HALF_EVEN));
                }
            };
        }
    };
    public static final NativeAggregateFunction sumFunctionForVarint = new NativeAggregateFunction("sum", (AbstractType)IntegerType.instance, new AbstractType[]{IntegerType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private BigInteger sum = BigInteger.ZERO;

                @Override
                public void reset() {
                    this.sum = BigInteger.ZERO;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return ((IntegerType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(Arguments arguments) {
                    BigInteger number = (BigInteger)arguments.get(0);
                    if (number == null) {
                        return;
                    }
                    this.sum = this.sum.add(number);
                }
            };
        }
    };
    public static final NativeAggregateFunction avgFunctionForVarint = new NativeAggregateFunction("avg", (AbstractType)IntegerType.instance, new AbstractType[]{IntegerType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private BigInteger sum = BigInteger.ZERO;
                private int count;

                @Override
                public void reset() {
                    this.count = 0;
                    this.sum = BigInteger.ZERO;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    if (this.count == 0) {
                        return IntegerType.instance.decompose(BigInteger.ZERO);
                    }
                    return IntegerType.instance.decompose(this.sum.divide(BigInteger.valueOf(this.count)));
                }

                @Override
                public void addInput(Arguments arguments) {
                    BigInteger number = (BigInteger)arguments.get(0);
                    if (number == null) {
                        return;
                    }
                    ++this.count;
                    this.sum = this.sum.add(number);
                }
            };
        }
    };
    public static final NativeAggregateFunction sumFunctionForByte = new NativeAggregateFunction("sum", (AbstractType)ByteType.instance, new AbstractType[]{ByteType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private byte sum;

                @Override
                public void reset() {
                    this.sum = 0;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return ((ByteType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(Arguments arguments) {
                    Number number = (Number)arguments.get(0);
                    if (number == null) {
                        return;
                    }
                    this.sum = (byte)(this.sum + number.byteValue());
                }
            };
        }
    };
    public static final NativeAggregateFunction avgFunctionForByte = new NativeAggregateFunction("avg", (AbstractType)ByteType.instance, new AbstractType[]{ByteType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AvgAggregate(){

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) throws InvalidRequestException {
                    return ByteType.instance.decompose((byte)this.computeInternal());
                }
            };
        }
    };
    public static final NativeAggregateFunction sumFunctionForShort = new NativeAggregateFunction("sum", (AbstractType)ShortType.instance, new AbstractType[]{ShortType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private short sum;

                @Override
                public void reset() {
                    this.sum = 0;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return ((ShortType)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(Arguments arguments) {
                    Number number = (Number)arguments.get(0);
                    if (number == null) {
                        return;
                    }
                    this.sum = (short)(this.sum + number.shortValue());
                }
            };
        }
    };
    public static final NativeAggregateFunction avgFunctionForShort = new NativeAggregateFunction("avg", (AbstractType)ShortType.instance, new AbstractType[]{ShortType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AvgAggregate(){

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return ShortType.instance.decompose((short)this.computeInternal());
                }
            };
        }
    };
    public static final NativeAggregateFunction sumFunctionForInt32 = new NativeAggregateFunction("sum", (AbstractType)Int32Type.instance, new AbstractType[]{Int32Type.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private int sum;

                @Override
                public void reset() {
                    this.sum = 0;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return ((Int32Type)this.returnType()).decompose(this.sum);
                }

                @Override
                public void addInput(Arguments arguments) {
                    Number number = (Number)arguments.get(0);
                    if (number == null) {
                        return;
                    }
                    this.sum += number.intValue();
                }
            };
        }
    };
    public static final NativeAggregateFunction avgFunctionForInt32 = new NativeAggregateFunction("avg", (AbstractType)Int32Type.instance, new AbstractType[]{Int32Type.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AvgAggregate(){

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return Int32Type.instance.decompose((int)this.computeInternal());
                }
            };
        }
    };
    public static final NativeAggregateFunction sumFunctionForLong = new NativeAggregateFunction("sum", (AbstractType)LongType.instance, new AbstractType[]{LongType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new LongSumAggregate();
        }
    };
    public static final NativeAggregateFunction avgFunctionForLong = new NativeAggregateFunction("avg", (AbstractType)LongType.instance, new AbstractType[]{LongType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AvgAggregate(){

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return LongType.instance.decompose(this.computeInternal());
                }
            };
        }
    };
    public static final NativeAggregateFunction sumFunctionForFloat = new NativeAggregateFunction("sum", (AbstractType)FloatType.instance, new AbstractType[]{FloatType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new FloatSumAggregate(){

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) throws InvalidRequestException {
                    return FloatType.instance.decompose(Float.valueOf((float)this.computeInternal()));
                }
            };
        }
    };
    public static final NativeAggregateFunction avgFunctionForFloat = new NativeAggregateFunction("avg", (AbstractType)FloatType.instance, new AbstractType[]{FloatType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new FloatAvgAggregate(){

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) throws InvalidRequestException {
                    return FloatType.instance.decompose(Float.valueOf((float)this.computeInternal()));
                }
            };
        }
    };
    public static final NativeAggregateFunction sumFunctionForDouble = new NativeAggregateFunction("sum", (AbstractType)DoubleType.instance, new AbstractType[]{DoubleType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new FloatSumAggregate(){

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) throws InvalidRequestException {
                    return DoubleType.instance.decompose(this.computeInternal());
                }
            };
        }
    };
    public static final NativeAggregateFunction avgFunctionForDouble = new NativeAggregateFunction("avg", (AbstractType)DoubleType.instance, new AbstractType[]{DoubleType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new FloatAvgAggregate(){

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) throws InvalidRequestException {
                    return DoubleType.instance.decompose(this.computeInternal());
                }
            };
        }
    };
    public static final NativeAggregateFunction sumFunctionForCounter = new NativeAggregateFunction("sum", (AbstractType)CounterColumnType.instance, new AbstractType[]{CounterColumnType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new LongSumAggregate();
        }
    };
    public static final NativeAggregateFunction avgFunctionForCounter = new NativeAggregateFunction("avg", (AbstractType)CounterColumnType.instance, new AbstractType[]{CounterColumnType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AvgAggregate(){

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) throws InvalidRequestException {
                    return CounterColumnType.instance.decompose(this.computeInternal());
                }
            };
        }
    };
    public static final NativeAggregateFunction minFunctionForCounter = new NativeAggregateFunction("min", (AbstractType)CounterColumnType.instance, new AbstractType[]{CounterColumnType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private Long min;

                @Override
                public void reset() {
                    this.min = null;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return this.min != null ? LongType.instance.decompose(this.min) : null;
                }

                @Override
                public void addInput(Arguments arguments) {
                    Number number = (Number)arguments.get(0);
                    if (number == null) {
                        return;
                    }
                    long lval = number.longValue();
                    if (this.min == null || lval < this.min) {
                        this.min = lval;
                    }
                }
            };
        }
    };
    public static final NativeAggregateFunction maxFunctionForCounter = new NativeAggregateFunction("max", (AbstractType)CounterColumnType.instance, new AbstractType[]{CounterColumnType.instance}){

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private Long max;

                @Override
                public void reset() {
                    this.max = null;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return this.max != null ? LongType.instance.decompose(this.max) : null;
                }

                @Override
                public void addInput(Arguments arguments) {
                    Number number = (Number)arguments.get(0);
                    if (number == null) {
                        return;
                    }
                    long lval = number.longValue();
                    if (this.max == null || lval > this.max) {
                        this.max = lval;
                    }
                }
            };
        }
    };

    public static void addFunctionsTo(NativeFunctions functions) {
        functions.add(countRowsFunction);
        functions.add(sumFunctionForByte);
        functions.add(sumFunctionForShort);
        functions.add(sumFunctionForInt32);
        functions.add(sumFunctionForLong);
        functions.add(sumFunctionForFloat);
        functions.add(sumFunctionForDouble);
        functions.add(sumFunctionForDecimal);
        functions.add(sumFunctionForVarint);
        functions.add(sumFunctionForCounter);
        functions.add(avgFunctionForByte);
        functions.add(avgFunctionForShort);
        functions.add(avgFunctionForInt32);
        functions.add(avgFunctionForLong);
        functions.add(avgFunctionForFloat);
        functions.add(avgFunctionForDouble);
        functions.add(avgFunctionForDecimal);
        functions.add(avgFunctionForVarint);
        functions.add(avgFunctionForCounter);
        functions.add(AggregateFcts.makeCountFunction(BytesType.instance));
        functions.add(new FunctionFactory("max", new FunctionParameter[]{FunctionParameter.anyType(true)}){

            @Override
            protected NativeFunction doGetOrCreateFunction(List<AbstractType<?>> argTypes, AbstractType<?> receiverType) {
                AbstractType<?> type = argTypes.get(0);
                return type.isCounter() ? maxFunctionForCounter : AggregateFcts.makeMaxFunction(type);
            }
        });
        functions.add(new FunctionFactory("min", new FunctionParameter[]{FunctionParameter.anyType(true)}){

            @Override
            protected NativeFunction doGetOrCreateFunction(List<AbstractType<?>> argTypes, AbstractType<?> receiverType) {
                AbstractType<?> type = argTypes.get(0);
                return type.isCounter() ? minFunctionForCounter : AggregateFcts.makeMinFunction(type);
            }
        });
    }

    public static NativeAggregateFunction makeMaxFunction(AbstractType<?> inputType) {
        return new NativeAggregateFunction("max", (AbstractType)inputType, new AbstractType[]{inputType}){

            @Override
            public Arguments newArguments(ProtocolVersion version) {
                return FunctionArguments.newNoopInstance(version, 1);
            }

            @Override
            public AggregateFunction.Aggregate newAggregate() {
                return new AggregateFunction.Aggregate(){
                    private ByteBuffer max;

                    @Override
                    public void reset() {
                        this.max = null;
                    }

                    @Override
                    public ByteBuffer compute(ProtocolVersion protocolVersion) {
                        return this.max;
                    }

                    @Override
                    public void addInput(Arguments arguments) {
                        ByteBuffer value = (ByteBuffer)arguments.get(0);
                        if (value == null) {
                            return;
                        }
                        if (this.max == null || this.returnType().compare(this.max, value) < 0) {
                            this.max = value;
                        }
                    }
                };
            }
        };
    }

    public static NativeAggregateFunction makeMinFunction(AbstractType<?> inputType) {
        return new NativeAggregateFunction("min", (AbstractType)inputType, new AbstractType[]{inputType}){

            @Override
            public Arguments newArguments(ProtocolVersion version) {
                return FunctionArguments.newNoopInstance(version, 1);
            }

            @Override
            public AggregateFunction.Aggregate newAggregate() {
                return new AggregateFunction.Aggregate(){
                    private ByteBuffer min;

                    @Override
                    public void reset() {
                        this.min = null;
                    }

                    @Override
                    public ByteBuffer compute(ProtocolVersion protocolVersion) {
                        return this.min;
                    }

                    @Override
                    public void addInput(Arguments arguments) {
                        ByteBuffer value = (ByteBuffer)arguments.get(0);
                        if (value == null) {
                            return;
                        }
                        if (this.min == null || this.returnType().compare(this.min, value) > 0) {
                            this.min = value;
                        }
                    }
                };
            }
        };
    }

    public static NativeAggregateFunction makeCountFunction(AbstractType<?> inputType) {
        return new NativeAggregateFunction("count", (AbstractType)LongType.instance, new AbstractType[]{inputType}){

            @Override
            public Arguments newArguments(ProtocolVersion version) {
                return FunctionArguments.newNoopInstance(version, 1);
            }

            @Override
            public AggregateFunction.Aggregate newAggregate() {
                return new AggregateFunction.Aggregate(){
                    private long count;

                    @Override
                    public void reset() {
                        this.count = 0L;
                    }

                    @Override
                    public ByteBuffer compute(ProtocolVersion protocolVersion) {
                        return ((LongType)this.returnType()).decompose(this.count);
                    }

                    @Override
                    public void addInput(Arguments arguments) {
                        if (arguments.get(0) == null) {
                            return;
                        }
                        ++this.count;
                    }
                };
            }
        };
    }

    private static abstract class AvgAggregate
    implements AggregateFunction.Aggregate {
        private long sum;
        private int count;
        private BigInteger bigSum = null;
        private boolean overflow = false;

        private AvgAggregate() {
        }

        @Override
        public void reset() {
            this.count = 0;
            this.sum = 0L;
            this.overflow = false;
            this.bigSum = null;
        }

        long computeInternal() {
            if (this.overflow) {
                return this.bigSum.divide(BigInteger.valueOf(this.count)).longValue();
            }
            return this.count == 0 ? 0L : this.sum / (long)this.count;
        }

        @Override
        public void addInput(Arguments arguments) {
            Number number = (Number)arguments.get(0);
            if (number == null) {
                return;
            }
            ++this.count;
            long l = number.longValue();
            if (this.overflow) {
                this.bigSum = this.bigSum.add(BigInteger.valueOf(l));
            } else {
                long prev = this.sum;
                this.sum += l;
                if (((prev ^ this.sum) & (l ^ this.sum)) < 0L) {
                    this.overflow = true;
                    this.bigSum = BigInteger.valueOf(prev).add(BigInteger.valueOf(l));
                }
            }
        }
    }

    private static class LongSumAggregate
    implements AggregateFunction.Aggregate {
        private long sum;

        private LongSumAggregate() {
        }

        @Override
        public void reset() {
            this.sum = 0L;
        }

        @Override
        public ByteBuffer compute(ProtocolVersion protocolVersion) {
            return LongType.instance.decompose(this.sum);
        }

        @Override
        public void addInput(Arguments arguments) {
            Number number = (Number)arguments.get(0);
            if (number == null) {
                return;
            }
            this.sum += number.longValue();
        }
    }

    private static abstract class FloatAvgAggregate
    implements AggregateFunction.Aggregate {
        private double sum;
        private double compensation;
        private double simpleSum;
        private int count;
        private BigDecimal bigSum = null;
        private boolean overflow = false;

        private FloatAvgAggregate() {
        }

        @Override
        public void reset() {
            this.sum = 0.0;
            this.compensation = 0.0;
            this.simpleSum = 0.0;
            this.count = 0;
            this.bigSum = null;
            this.overflow = false;
        }

        public double computeInternal() {
            if (this.count == 0) {
                return 0.0;
            }
            if (this.overflow) {
                return this.bigSum.divide(BigDecimal.valueOf(this.count), RoundingMode.HALF_EVEN).doubleValue();
            }
            double tmp = this.sum + this.compensation;
            this.sum = Double.isNaN(tmp) && Double.isInfinite(this.simpleSum) ? this.simpleSum : tmp;
            return this.sum / (double)this.count;
        }

        @Override
        public void addInput(Arguments arguments) {
            Number number = (Number)arguments.get(0);
            if (number == null) {
                return;
            }
            ++this.count;
            double d = number.doubleValue();
            if (this.overflow) {
                this.bigSum = this.bigSum.add(BigDecimal.valueOf(d));
            } else {
                this.simpleSum += d;
                double prev = this.sum;
                double tmp = d - this.compensation;
                double rounded = this.sum + tmp;
                this.compensation = rounded - this.sum - tmp;
                this.sum = rounded;
                if (Double.isInfinite(this.sum) && !Double.isInfinite(d)) {
                    this.overflow = true;
                    this.bigSum = BigDecimal.valueOf(prev).add(BigDecimal.valueOf(d));
                }
            }
        }
    }

    private static abstract class FloatSumAggregate
    implements AggregateFunction.Aggregate {
        private double sum;
        private double compensation;
        private double simpleSum;

        private FloatSumAggregate() {
        }

        @Override
        public void reset() {
            this.sum = 0.0;
            this.compensation = 0.0;
            this.simpleSum = 0.0;
        }

        @Override
        public void addInput(Arguments arguments) {
            Number number = (Number)arguments.get(0);
            if (number == null) {
                return;
            }
            double d = number.doubleValue();
            this.simpleSum += d;
            double tmp = d - this.compensation;
            double rounded = this.sum + tmp;
            this.compensation = rounded - this.sum - tmp;
            this.sum = rounded;
        }

        public double computeInternal() {
            double tmp = this.sum + this.compensation;
            if (Double.isNaN(tmp) && Double.isInfinite(this.simpleSum)) {
                return this.simpleSum;
            }
            return tmp;
        }
    }

    public static class CountRowsFunction
    extends NativeAggregateFunction {
        private CountRowsFunction(boolean useLegacyName) {
            super(useLegacyName ? "countRows" : "count_rows", LongType.instance, new AbstractType[0]);
        }

        @Override
        public AggregateFunction.Aggregate newAggregate() {
            return new AggregateFunction.Aggregate(){
                private long count;

                @Override
                public void reset() {
                    this.count = 0L;
                }

                @Override
                public ByteBuffer compute(ProtocolVersion protocolVersion) {
                    return LongType.instance.decompose(this.count);
                }

                @Override
                public void addInput(Arguments arguments) {
                    ++this.count;
                }
            };
        }

        @Override
        public String columnName(List<String> columnNames) {
            return "count";
        }

        @Override
        public NativeFunction withLegacyName() {
            return new CountRowsFunction(true);
        }
    }
}

