/*
 * Decompiled with CFR 0.152.
 */
package org.hyperic.sigar.cmd;

import java.util.ArrayList;
import org.hyperic.sigar.FileSystem;
import org.hyperic.sigar.FileSystemMap;
import org.hyperic.sigar.FileSystemUsage;
import org.hyperic.sigar.NfsFileSystem;
import org.hyperic.sigar.Sigar;
import org.hyperic.sigar.SigarException;
import org.hyperic.sigar.cmd.Shell;
import org.hyperic.sigar.cmd.SigarCommandBase;
import org.hyperic.sigar.shell.FileCompleter;
import org.hyperic.sigar.util.GetlineCompleter;

public class Df
extends SigarCommandBase {
    private static final String OUTPUT_FORMAT = "%-15s %4s %4s %5s %4s %-15s %s";
    private static final String[] HEADER = new String[]{"Filesystem", "Size", "Used", "Avail", "Use%", "Mounted on", "Type"};
    private static final String[] IHEADER = new String[]{"Filesystem", "Inodes", "IUsed", "IFree", "IUse%", "Mounted on", "Type"};
    private GetlineCompleter completer;
    private boolean opt_i;

    public Df(Shell shell) {
        super(shell);
        this.setOutputFormat(OUTPUT_FORMAT);
        this.completer = new FileCompleter(shell);
    }

    public Df() {
        this.setOutputFormat(OUTPUT_FORMAT);
    }

    public GetlineCompleter getCompleter() {
        return this.completer;
    }

    protected boolean validateArgs(String[] args) {
        return true;
    }

    public String getSyntaxArgs() {
        return "[filesystem]";
    }

    public String getUsageShort() {
        return "Report filesystem disk space usage";
    }

    public void printHeader() {
        this.printf(this.opt_i ? IHEADER : HEADER);
    }

    public void output(String[] args) throws SigarException {
        int i;
        this.opt_i = false;
        ArrayList<FileSystem> sys = new ArrayList<FileSystem>();
        if (args.length > 0) {
            FileSystemMap mounts = this.proxy.getFileSystemMap();
            for (i = 0; i < args.length; ++i) {
                String arg = args[i];
                if (arg.equals("-i")) {
                    this.opt_i = true;
                    continue;
                }
                String name = FileCompleter.expand(arg);
                FileSystem fs = mounts.getMountPoint(name);
                if (fs == null) {
                    throw new SigarException(arg + " No such file or directory");
                }
                sys.add(fs);
            }
        }
        if (sys.size() == 0) {
            FileSystem[] fslist = this.proxy.getFileSystemList();
            for (i = 0; i < fslist.length; ++i) {
                sys.add(fslist[i]);
            }
        }
        this.printHeader();
        for (int i2 = 0; i2 < sys.size(); ++i2) {
            this.output((FileSystem)sys.get(i2));
        }
    }

    public void output(FileSystem fs) throws SigarException {
        long pct;
        long total;
        long avail;
        long used;
        try {
            NfsFileSystem nfs;
            if (fs instanceof NfsFileSystem && !(nfs = (NfsFileSystem)fs).ping()) {
                this.println(nfs.getUnreachableMessage());
                return;
            }
            FileSystemUsage usage = this.sigar.getFileSystemUsage(fs.getDirName());
            if (this.opt_i) {
                used = usage.getFiles() - usage.getFreeFiles();
                avail = usage.getFreeFiles();
                total = usage.getFiles();
                if (total == 0L) {
                    pct = 0L;
                } else {
                    long u100 = used * 100L;
                    pct = u100 / total + (long)(u100 % total != 0L ? 1 : 0);
                }
            } else {
                used = usage.getTotal() - usage.getFree();
                avail = usage.getAvail();
                total = usage.getTotal();
                pct = (long)(usage.getUsePercent() * 100.0);
            }
        }
        catch (SigarException e) {
            pct = 0L;
            total = 0L;
            avail = 0L;
            used = 0L;
        }
        String usePct = pct == 0L ? "-" : pct + "%";
        ArrayList<String> items = new ArrayList<String>();
        items.add(fs.getDevName());
        items.add(this.formatSize(total));
        items.add(this.formatSize(used));
        items.add(this.formatSize(avail));
        items.add(usePct);
        items.add(fs.getDirName());
        items.add(fs.getSysTypeName() + "/" + fs.getTypeName());
        this.printf(items);
    }

    private String formatSize(long size) {
        return this.opt_i ? String.valueOf(size) : Sigar.formatSize(size * 1024L);
    }

    public static void main(String[] args) throws Exception {
        new Df().processCommand(args);
    }
}

