/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ratis.shell.cli;

import java.io.Closeable;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;

public interface Command
extends Comparable<Command>,
Closeable {
    public String getCommandName();

    @Override
    default public int compareTo(Command that) {
        return this.getCommandName().compareTo(that.getCommandName());
    }

    default public Options getOptions() {
        return new Options();
    }

    default public boolean hasSubCommand() {
        return Optional.ofNullable(this.getSubCommands()).filter(subs -> !subs.isEmpty()).isPresent();
    }

    default public Map<String, Command> getSubCommands() {
        return Collections.emptyMap();
    }

    default public CommandLine parseAndValidateArgs(String ... args) throws IllegalArgumentException {
        CommandLine cmdline;
        Options opts = this.getOptions();
        DefaultParser parser = new DefaultParser();
        try {
            cmdline = parser.parse(opts, args);
        }
        catch (ParseException e) {
            throw new IllegalArgumentException(String.format("Failed to parse args for %s: %s", this.getCommandName(), e.getMessage()), e);
        }
        this.validateArgs(cmdline);
        return cmdline;
    }

    default public void validateArgs(CommandLine cl) throws IllegalArgumentException {
    }

    default public int run(CommandLine cl) throws IOException {
        return 0;
    }

    public String getUsage();

    public String getDescription();

    @Override
    default public void close() throws IOException {
    }
}

