/*
 * Decompiled with CFR 0.152.
 */
package one.converter;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Pattern;
import one.converter.Arguments;

public class FlameGraph
implements Comparator<Frame> {
    public static final byte FRAME_INTERPRETED = 0;
    public static final byte FRAME_JIT_COMPILED = 1;
    public static final byte FRAME_INLINED = 2;
    public static final byte FRAME_NATIVE = 3;
    public static final byte FRAME_CPP = 4;
    public static final byte FRAME_KERNEL = 5;
    public static final byte FRAME_C1_COMPILED = 6;
    private final Arguments args;
    private final Map<String, Integer> cpool = new HashMap<String, Integer>();
    private final Frame root = new Frame(this.getFrameKey("", (byte)3));
    private int[] order;
    private int depth;
    private int lastLevel;
    private long lastX;
    private long lastTotal;
    private long mintotal;

    public FlameGraph(Arguments args) {
        this.args = args;
    }

    public FlameGraph(String ... args) {
        this(new Arguments(args));
    }

    public void parse() throws IOException {
        this.parse(new InputStreamReader((InputStream)new FileInputStream(this.args.input), StandardCharsets.UTF_8));
    }

    public void parse(Reader in) throws IOException {
        try (BufferedReader br = new BufferedReader(in);){
            String line;
            while ((line = br.readLine()) != null) {
                int space = line.lastIndexOf(32);
                if (space <= 0) continue;
                String[] trace = line.substring(0, space).split(";");
                long ticks = Long.parseLong(line.substring(space + 1));
                this.addSample(trace, ticks);
            }
        }
    }

    public void addSample(String[] trace, long ticks) {
        if (this.excludeTrace(trace)) {
            return;
        }
        Frame frame = this.root;
        if (this.args.reverse) {
            int i = trace.length;
            while (--i >= this.args.skip) {
                frame = this.addChild(frame, trace[i], ticks);
            }
        } else {
            for (int i = this.args.skip; i < trace.length; ++i) {
                frame = this.addChild(frame, trace[i], ticks);
            }
        }
        frame.total += ticks;
        frame.self += ticks;
        this.depth = Math.max(this.depth, trace.length);
    }

    public void dump() throws IOException {
        if (this.args.output == null) {
            this.dump(System.out);
        } else {
            try (BufferedOutputStream bos = new BufferedOutputStream(new FileOutputStream(this.args.output), 32768);
                 PrintStream out = new PrintStream((OutputStream)bos, false, "UTF-8");){
                this.dump(out);
            }
        }
    }

    public void dump(PrintStream out) {
        this.mintotal = (long)((double)this.root.total * this.args.minwidth / 100.0);
        int depth = this.mintotal > 1L ? this.root.depth(this.mintotal) : this.depth + 1;
        String tail = FlameGraph.getResource("/flame.html");
        tail = this.printTill(out, tail, "/*height:*/300");
        out.print(Math.min(depth * 16, Short.MAX_VALUE));
        tail = this.printTill(out, tail, "/*title:*/");
        out.print(this.args.title);
        tail = this.printTill(out, tail, "/*reverse:*/false");
        out.print(this.args.reverse);
        tail = this.printTill(out, tail, "/*depth:*/0");
        out.print(depth);
        tail = this.printTill(out, tail, "/*cpool:*/");
        this.printCpool(out);
        tail = this.printTill(out, tail, "/*frames:*/");
        this.printFrame(out, this.root, 0, 0L);
        tail = this.printTill(out, tail, "/*highlight:*/");
        out.print(this.args.highlight != null ? "'" + FlameGraph.escape(this.args.highlight) + "'" : "");
        out.print(tail);
    }

    private String printTill(PrintStream out, String data, String till) {
        int index = data.indexOf(till);
        out.print(data.substring(0, index));
        return data.substring(index + till.length());
    }

    private void printCpool(PrintStream out) {
        Object[] strings = this.cpool.keySet().toArray(new String[0]);
        Arrays.sort(strings);
        out.print("'all'");
        this.order = new int[strings.length];
        Object s = "";
        int i = 1;
        while (i < strings.length) {
            String string = s;
            s = strings[i];
            int prefixLen = Math.min(FlameGraph.getCommonPrefix(string, (String)s), 95);
            out.print(",\n'" + FlameGraph.escape((char)(prefixLen + 32) + ((String)s).substring(prefixLen)) + "'");
            this.order[this.cpool.get((Object)s).intValue()] = i++;
        }
        this.cpool.clear();
    }

    private void printFrame(PrintStream out, Frame frame, int level, long x) {
        int nameAndType = this.order[frame.getTitleIndex()] << 3 | frame.getType();
        boolean hasExtraTypes = (frame.inlined | frame.c1 | frame.interpreted) != 0L && frame.inlined < frame.total && frame.interpreted < frame.total;
        int func = 102;
        if (level == this.lastLevel + 1 && x == this.lastX) {
            func = 117;
        } else if (level == this.lastLevel && x == this.lastX + this.lastTotal) {
            func = 110;
        }
        StringBuilder sb = new StringBuilder(24).append((char)func).append('(').append(nameAndType);
        if (func == 102) {
            sb.append(',').append(level).append(',').append(x - this.lastX);
        }
        if (frame.total != this.lastTotal || hasExtraTypes) {
            sb.append(',').append(frame.total);
            if (hasExtraTypes) {
                sb.append(',').append(frame.inlined).append(',').append(frame.c1).append(',').append(frame.interpreted);
            }
        }
        sb.append(')');
        out.println(sb.toString());
        this.lastLevel = level;
        this.lastX = x;
        this.lastTotal = frame.total;
        Frame[] children = frame.values().toArray(Frame.EMPTY_ARRAY);
        Arrays.sort(children, this);
        x += frame.self;
        for (Frame child : children) {
            if (child.total >= this.mintotal) {
                this.printFrame(out, child, level + 1, x);
            }
            x += child.total;
        }
    }

    private boolean excludeTrace(String[] trace) {
        Pattern include = this.args.include;
        Pattern exclude = this.args.exclude;
        if (include == null && exclude == null) {
            return false;
        }
        for (String frame : trace) {
            if (exclude != null && exclude.matcher(frame).matches()) {
                return true;
            }
            if (include == null || !include.matcher(frame).matches()) continue;
            include = null;
            if (exclude == null) break;
        }
        return include != null;
    }

    private int getFrameKey(String title, byte type) {
        Integer key = this.cpool.get(title);
        if (key != null) {
            return key | type << 28;
        }
        int size = this.cpool.size();
        this.cpool.put(title, size);
        return size | type << 28;
    }

    private Frame getChild(Frame frame, String title, byte type) {
        int key = this.getFrameKey(title, type);
        Frame child = (Frame)frame.get(key);
        if (child == null) {
            child = new Frame(key);
            frame.put(key, child);
        }
        return child;
    }

    private Frame addChild(Frame frame, String title, long ticks) {
        Frame child;
        frame.total += ticks;
        if (title.endsWith("_[j]")) {
            child = this.getChild(frame, FlameGraph.stripSuffix(title), (byte)1);
        } else if (title.endsWith("_[i]")) {
            child = this.getChild(frame, FlameGraph.stripSuffix(title), (byte)1);
            child.inlined += ticks;
        } else if (title.endsWith("_[k]")) {
            child = this.getChild(frame, FlameGraph.stripSuffix(title), (byte)5);
        } else if (title.endsWith("_[1]")) {
            child = this.getChild(frame, FlameGraph.stripSuffix(title), (byte)1);
            child.c1 += ticks;
        } else if (title.endsWith("_[0]")) {
            child = this.getChild(frame, FlameGraph.stripSuffix(title), (byte)1);
            child.interpreted += ticks;
        } else {
            child = title.contains("::") || title.startsWith("-[") || title.startsWith("+[") ? this.getChild(frame, title, (byte)4) : (title.indexOf(47) > 0 && title.charAt(0) != '[' || title.indexOf(46) > 0 && Character.isUpperCase(title.charAt(0)) ? this.getChild(frame, title, (byte)1) : this.getChild(frame, title, (byte)3));
        }
        return child;
    }

    static int getCommonPrefix(String a, String b) {
        int length = Math.min(a.length(), b.length());
        for (int i = 0; i < length; ++i) {
            if (a.charAt(i) == b.charAt(i) && a.charAt(i) <= '\u007f') continue;
            return i;
        }
        return length;
    }

    static String stripSuffix(String title) {
        return title.substring(0, title.length() - 4);
    }

    static String escape(String s) {
        if (s.indexOf(92) >= 0) {
            s = s.replace("\\", "\\\\");
        }
        if (s.indexOf(39) >= 0) {
            s = s.replace("'", "\\'");
        }
        return s;
    }

    private static String getResource(String name) {
        String string;
        block10: {
            InputStream stream = FlameGraph.class.getResourceAsStream(name);
            try {
                int length;
                if (stream == null) {
                    throw new IOException("No resource found");
                }
                ByteArrayOutputStream result = new ByteArrayOutputStream();
                byte[] buffer = new byte[65536];
                while ((length = stream.read(buffer)) != -1) {
                    result.write(buffer, 0, length);
                }
                string = result.toString("UTF-8");
                if (stream == null) break block10;
            }
            catch (Throwable throwable) {
                try {
                    if (stream != null) {
                        try {
                            stream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new IllegalStateException("Can't load resource with name " + name);
                }
            }
            stream.close();
        }
        return string;
    }

    @Override
    public int compare(Frame f1, Frame f2) {
        return this.order[f1.getTitleIndex()] - this.order[f2.getTitleIndex()];
    }

    public static void main(String[] cmdline) throws IOException {
        Arguments args = new Arguments(cmdline);
        if (args.input == null) {
            System.out.println("Usage: java -cp ap-loader.jar " + FlameGraph.class.getName() + " [options] input.collapsed [output.html]");
            System.out.println();
            System.out.println("Options:");
            System.out.println("  --title TITLE");
            System.out.println("  --reverse");
            System.out.println("  --minwidth PERCENT");
            System.out.println("  --skip FRAMES");
            System.out.println("  --include PATTERN");
            System.out.println("  --exclude PATTERN");
            System.out.println("  --highlight PATTERN");
            System.exit(1);
        }
        FlameGraph fg = new FlameGraph(args);
        fg.parse();
        fg.dump();
    }

    static class Frame
    extends HashMap<Integer, Frame> {
        static final Frame[] EMPTY_ARRAY = new Frame[0];
        final int key;
        long total;
        long self;
        long inlined;
        long c1;
        long interpreted;

        Frame(int key) {
            this.key = key;
        }

        byte getType() {
            if (this.inlined * 3L >= this.total) {
                return 2;
            }
            if (this.c1 * 2L >= this.total) {
                return 6;
            }
            if (this.interpreted * 2L >= this.total) {
                return 0;
            }
            return (byte)(this.key >>> 28);
        }

        int getTitleIndex() {
            return this.key & 0xFFFFFFF;
        }

        int depth(long cutoff) {
            int depth = 0;
            if (this.size() > 0) {
                for (Frame child : this.values()) {
                    if (child.total < cutoff) continue;
                    depth = Math.max(depth, child.depth(cutoff));
                }
            }
            return depth + 1;
        }
    }
}

