/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.utils;

public class Utils {
    public static <T> T checkNotNull(T object) {
        if (object == null) {
            throw new NullPointerException("Must be not null.");
        }
        return object;
    }

    public static void checkArgument(boolean condition, String message) {
        if (!condition) {
            throw new IllegalArgumentException(message);
        }
    }

    public static void checkState(boolean condition, String message) {
        if (!condition) {
            throw new IllegalStateException(message);
        }
    }

    public static int checkedDownCast(long value) {
        int downCast = (int)value;
        if ((long)downCast != value) {
            throw new IllegalArgumentException("Cannot downcast long value " + value + " to integer.");
        }
        return downCast;
    }

    public static void rethrowAsRuntimeException(Throwable t) {
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }
}

