/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.fallback;

import org.apache.celeborn.client.LifecycleManager;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.plugin.flink.fallback.ShuffleFallbackPolicy;
import org.apache.flink.runtime.shuffle.JobShuffleContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WorkersAvailableFallbackPolicy
implements ShuffleFallbackPolicy {
    private static final Logger LOG = LoggerFactory.getLogger(WorkersAvailableFallbackPolicy.class);
    public static final WorkersAvailableFallbackPolicy INSTANCE = new WorkersAvailableFallbackPolicy();

    @Override
    public boolean needFallback(JobShuffleContext shuffleContext, CelebornConf celebornConf, LifecycleManager lifecycleManager) {
        boolean needFallback;
        if (!celebornConf.checkWorkerEnabled()) {
            return false;
        }
        boolean bl = needFallback = !lifecycleManager.checkWorkersAvailable().getAvailable();
        if (needFallback) {
            LOG.warn("No celeborn workers available for current user {}.", (Object)lifecycleManager.getUserIdentifier());
        }
        return needFallback;
    }
}

