/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.mapreduce.security;

import java.io.IOException;
import java.io.InputStream;
import org.apache.hadoop.classification.InterfaceAudience;
import org.apache.hadoop.classification.InterfaceStability;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.CryptoUtils;
import org.apache.hadoop.mapreduce.security.SpillCallBackInjector;

@InterfaceAudience.Private
@InterfaceStability.Unstable
public final class IntermediateEncryptedStream {
    private static SpillCallBackInjector prevSpillCBInjector = null;

    public static FSDataOutputStream wrapIfNecessary(Configuration conf, FSDataOutputStream out, Path outPath) throws IOException {
        SpillCallBackInjector.get().writeSpillFileCB(outPath, out, conf);
        return CryptoUtils.wrapIfNecessary(conf, out, true);
    }

    public static FSDataOutputStream wrapIfNecessary(Configuration conf, FSDataOutputStream out, boolean closeOutputStream, Path outPath) throws IOException {
        SpillCallBackInjector.get().writeSpillFileCB(outPath, out, conf);
        return CryptoUtils.wrapIfNecessary(conf, out, closeOutputStream);
    }

    public static FSDataInputStream wrapIfNecessary(Configuration conf, FSDataInputStream in, Path inputPath) throws IOException {
        SpillCallBackInjector.get().getSpillFileCB(inputPath, in, conf);
        return CryptoUtils.wrapIfNecessary(conf, in);
    }

    public static InputStream wrapIfNecessary(Configuration conf, InputStream in, long length, Path inputPath) throws IOException {
        SpillCallBackInjector.get().getSpillFileCB(inputPath, in, conf);
        return CryptoUtils.wrapIfNecessary(conf, in, length);
    }

    public static void addSpillIndexFile(Path indexFilename, Configuration conf) {
        SpillCallBackInjector.get().addSpillIndexFileCB(indexFilename, conf);
    }

    public static void validateSpillIndexFile(Path indexFilename, Configuration conf) {
        SpillCallBackInjector.get().validateSpillIndexFileCB(indexFilename, conf);
    }

    public static SpillCallBackInjector resetSpillCBInjector() {
        return IntermediateEncryptedStream.setSpillCBInjector(prevSpillCBInjector);
    }

    public static synchronized SpillCallBackInjector setSpillCBInjector(SpillCallBackInjector spillInjector) {
        prevSpillCBInjector = SpillCallBackInjector.getAndSet(spillInjector);
        return spillInjector;
    }

    private IntermediateEncryptedStream() {
    }
}

