/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.buffer;

import org.apache.celeborn.plugin.flink.buffer.BufferHeader;
import org.apache.celeborn.plugin.flink.buffer.BufferPacker;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;

public class ReceivedNoHeaderBufferPacker
extends BufferPacker {
    private BufferHeader firstBufferHeader;

    public ReceivedNoHeaderBufferPacker(BufferPacker.BiConsumerWithException<ByteBuf, BufferHeader, InterruptedException> ripeBufferHandler) {
        super(ripeBufferHandler);
    }

    @Override
    public void process(Buffer buffer, int subIdx) throws InterruptedException {
        if (buffer == null) {
            return;
        }
        if (buffer.readableBytes() == 0) {
            buffer.recycleBuffer();
            return;
        }
        if (this.cachedBuffer == null) {
            this.cachedBuffer = buffer;
            this.currentSubIdx = subIdx;
            this.firstBufferHeader = new BufferHeader(subIdx, buffer.getDataType(), buffer.isCompressed(), buffer.getSize());
        } else if (this.currentSubIdx != subIdx) {
            Buffer dumpedBuffer = this.cachedBuffer;
            this.cachedBuffer = buffer;
            int targetSubIdx = this.currentSubIdx;
            this.currentSubIdx = subIdx;
            this.logBufferPack(false, dumpedBuffer.getDataType(), dumpedBuffer.readableBytes());
            this.handleRipeBuffer(dumpedBuffer, targetSubIdx, dumpedBuffer.getDataType(), dumpedBuffer.isCompressed());
            this.firstBufferHeader = new BufferHeader(subIdx, buffer.getDataType(), buffer.isCompressed(), buffer.getSize());
        } else {
            int bufferHeaderLength = 6;
            if (this.cachedBuffer.readableBytes() + buffer.readableBytes() + bufferHeaderLength <= this.cachedBuffer.getMaxCapacity() - 22) {
                ByteBuf byteBuf = this.cachedBuffer.asByteBuf();
                byteBuf.writeByte(buffer.getDataType().ordinal());
                byteBuf.writeBoolean(buffer.isCompressed());
                byteBuf.writeInt(buffer.getSize());
                byteBuf.writeBytes(buffer.asByteBuf(), 0, buffer.readableBytes());
                this.logBufferPack(false, buffer.getDataType(), buffer.readableBytes() + bufferHeaderLength);
                buffer.recycleBuffer();
            } else {
                Buffer dumpedBuffer = this.cachedBuffer;
                this.cachedBuffer = buffer;
                this.logBufferPack(false, dumpedBuffer.getDataType(), dumpedBuffer.readableBytes());
                this.handleRipeBuffer(dumpedBuffer, this.currentSubIdx, dumpedBuffer.getDataType(), dumpedBuffer.isCompressed());
                this.firstBufferHeader = new BufferHeader(subIdx, buffer.getDataType(), buffer.isCompressed(), buffer.getSize());
            }
        }
    }

    @Override
    protected void handleRipeBuffer(Buffer buffer, int subIdx, Buffer.DataType dataType, boolean isCompressed) throws InterruptedException {
        if (buffer == null || buffer.readableBytes() == 0) {
            return;
        }
        buffer.setCompressed(false);
        this.ripeBufferHandler.accept(buffer.asByteBuf(), this.firstBufferHeader);
    }
}

