/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network.server;

import org.apache.celeborn.common.network.client.RpcResponseCallback;
import org.apache.celeborn.common.network.client.TransportClient;
import org.apache.celeborn.common.network.protocol.RequestMessage;
import org.apache.celeborn.common.network.server.BaseMessageHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuthRpcHandler
extends BaseMessageHandler {
    private static final Logger LOG = LoggerFactory.getLogger(AbstractAuthRpcHandler.class);
    protected final BaseMessageHandler delegate;
    private boolean isAuthenticated;

    protected AbstractAuthRpcHandler(BaseMessageHandler delegate) {
        this.delegate = delegate;
    }

    protected abstract boolean doAuthChallenge(TransportClient var1, RequestMessage var2, RpcResponseCallback var3);

    @Override
    public final void receive(TransportClient client, RequestMessage message, RpcResponseCallback callback) {
        if (this.isAuthenticated) {
            LOG.trace("Already authenticated. Delegating {}", (Object)client.getClientId());
            this.delegate.receive(client, message, callback);
        } else {
            this.isAuthenticated = this.doAuthChallenge(client, message, callback);
        }
    }

    @Override
    public final void receive(TransportClient client, RequestMessage message) {
        if (!this.isAuthenticated) {
            throw new SecurityException("Unauthenticated call to receive().");
        }
        this.delegate.receive(client, message);
    }

    @Override
    public void channelActive(TransportClient client) {
        this.delegate.channelActive(client);
    }

    @Override
    public void channelInactive(TransportClient client) {
        this.delegate.channelInactive(client);
    }

    @Override
    public void exceptionCaught(Throwable cause, TransportClient client) {
        this.delegate.exceptionCaught(cause, client);
    }

    public boolean isAuthenticated() {
        return this.isAuthenticated;
    }
}

