/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.plugin.flink.tiered;

import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.exception.DriverChangedException;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.plugin.flink.buffer.BufferHeader;
import org.apache.celeborn.plugin.flink.buffer.BufferPacker;
import org.apache.celeborn.plugin.flink.buffer.ReceivedNoHeaderBufferPacker;
import org.apache.celeborn.plugin.flink.client.FlinkShuffleClientImpl;
import org.apache.celeborn.plugin.flink.tiered.CelebornTierFactory;
import org.apache.celeborn.plugin.flink.tiered.TierShuffleDescriptorImpl;
import org.apache.celeborn.plugin.flink.utils.BufferUtils;
import org.apache.celeborn.plugin.flink.utils.Utils;
import org.apache.flink.annotation.VisibleForTesting;
import org.apache.flink.core.memory.MemorySegment;
import org.apache.flink.core.memory.MemorySegmentFactory;
import org.apache.flink.runtime.event.AbstractEvent;
import org.apache.flink.runtime.io.network.api.EndOfSegmentEvent;
import org.apache.flink.runtime.io.network.api.serialization.EventSerializer;
import org.apache.flink.runtime.io.network.buffer.Buffer;
import org.apache.flink.runtime.io.network.buffer.FreeingBufferRecycler;
import org.apache.flink.runtime.io.network.buffer.NetworkBuffer;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageDataIdentifier;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStoragePartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.common.TieredStorageSubpartitionId;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageMemoryManager;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.storage.TieredStorageResourceRegistry;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierProducerAgent;
import org.apache.flink.runtime.io.network.partition.hybrid.tiered.tier.TierShuffleDescriptor;
import org.apache.flink.shaded.netty4.io.netty.buffer.ByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.CompositeByteBuf;
import org.apache.flink.shaded.netty4.io.netty.buffer.Unpooled;
import org.apache.flink.util.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CelebornTierProducerAgent
implements TierProducerAgent {
    private static final Logger LOG = LoggerFactory.getLogger(CelebornTierProducerAgent.class);
    private final int numBuffersPerSegment;
    private final int bufferSizeBytes;
    private final int numPartitions;
    private final int numSubPartitions;
    private final CelebornConf celebornConf;
    private final TieredStorageMemoryManager memoryManager;
    private final String applicationId;
    private final int shuffleId;
    private final int mapId;
    private final int attemptId;
    private final int partitionId;
    private final String lifecycleManagerHost;
    private final int lifecycleManagerPort;
    private final long lifecycleManagerTimestamp;
    private FlinkShuffleClientImpl flinkShuffleClient;
    private BufferPacker bufferPacker;
    private final int[] subPartitionSegmentIds;
    private final int[] subPartitionSegmentBuffers;
    private final int maxReviveTimes;
    private PartitionLocation partitionLocation;
    private boolean hasRegisteredShuffle;
    private int currentRegionIndex = 0;
    private int currentSubpartition = 0;
    private boolean hasSentHandshake = false;
    private boolean hasSentRegionStart = false;
    private volatile boolean isReleased;

    CelebornTierProducerAgent(CelebornConf conf, TieredStoragePartitionId partitionId, int numPartitions, int numSubPartitions, int numBytesPerSegment, int bufferSizeBytes, TieredStorageMemoryManager memoryManager, TieredStorageResourceRegistry resourceRegistry, List<TierShuffleDescriptor> shuffleDescriptors) {
        Utils.checkArgument(numBytesPerSegment >= bufferSizeBytes, "One segment should contain at least one buffer.");
        Utils.checkArgument(shuffleDescriptors.size() == 1, "There should be only one shuffle descriptor.");
        TierShuffleDescriptor descriptor = shuffleDescriptors.get(0);
        Utils.checkArgument(descriptor instanceof TierShuffleDescriptorImpl, "Wrong shuffle descriptor type " + descriptor.getClass());
        TierShuffleDescriptorImpl shuffleDesc = (TierShuffleDescriptorImpl)descriptor;
        this.numBuffersPerSegment = numBytesPerSegment / bufferSizeBytes;
        this.bufferSizeBytes = bufferSizeBytes;
        this.memoryManager = memoryManager;
        this.numPartitions = numPartitions;
        this.numSubPartitions = numSubPartitions;
        this.celebornConf = conf;
        this.subPartitionSegmentIds = new int[numSubPartitions];
        this.subPartitionSegmentBuffers = new int[numSubPartitions];
        this.maxReviveTimes = conf.clientPushMaxReviveTimes();
        this.applicationId = shuffleDesc.getCelebornAppId();
        this.shuffleId = shuffleDesc.getShuffleResource().getMapPartitionShuffleDescriptor().getShuffleId();
        this.mapId = shuffleDesc.getShuffleResource().getMapPartitionShuffleDescriptor().getMapId();
        this.attemptId = shuffleDesc.getShuffleResource().getMapPartitionShuffleDescriptor().getAttemptId();
        this.partitionId = shuffleDesc.getShuffleResource().getMapPartitionShuffleDescriptor().getPartitionId();
        this.lifecycleManagerHost = shuffleDesc.getShuffleResource().getLifecycleManagerHost();
        this.lifecycleManagerPort = shuffleDesc.getShuffleResource().getLifecycleManagerPort();
        this.lifecycleManagerTimestamp = shuffleDesc.getShuffleResource().getLifecycleManagerTimestamp();
        this.flinkShuffleClient = this.getShuffleClient();
        Arrays.fill(this.subPartitionSegmentIds, -1);
        Arrays.fill(this.subPartitionSegmentBuffers, 0);
        this.bufferPacker = new ReceivedNoHeaderBufferPacker(this::write);
        resourceRegistry.registerResource((TieredStorageDataIdentifier)partitionId, this::releaseResources);
        this.registerShuffle();
        try {
            this.handshake();
        }
        catch (IOException e) {
            Utils.rethrowAsRuntimeException(e);
        }
    }

    public boolean tryStartNewSegment(TieredStorageSubpartitionId tieredStorageSubpartitionId, int segmentId, int minNumBuffers) {
        int subPartitionId = tieredStorageSubpartitionId.getSubpartitionId();
        Utils.checkState(segmentId >= this.subPartitionSegmentIds[subPartitionId], "Wrong segment id " + segmentId);
        this.subPartitionSegmentIds[subPartitionId] = segmentId;
        try {
            this.flinkShuffleClient.segmentStart(this.shuffleId, this.mapId, this.attemptId, subPartitionId, segmentId, this.partitionLocation);
        }
        catch (IOException e) {
            Utils.rethrowAsRuntimeException(e);
        }
        return true;
    }

    public boolean tryWrite(TieredStorageSubpartitionId tieredStorageSubpartitionId, Buffer buffer, Object bufferOwner, int numRemainingConsecutiveBuffers) {
        int subPartitionId = tieredStorageSubpartitionId.getSubpartitionId();
        if (this.subPartitionSegmentBuffers[subPartitionId] + 1 + numRemainingConsecutiveBuffers >= this.numBuffersPerSegment) {
            this.subPartitionSegmentBuffers[subPartitionId] = 0;
            try {
                this.bufferPacker.drain();
            }
            catch (InterruptedException e) {
                buffer.recycleBuffer();
                ExceptionUtils.rethrow((Throwable)e, (String)"Failed to process buffer.");
            }
            this.appendEndOfSegmentBuffer(subPartitionId);
            return false;
        }
        if (buffer.isBuffer()) {
            this.memoryManager.transferBufferOwnership(bufferOwner, (Object)CelebornTierFactory.getCelebornTierName(), buffer);
        }
        this.processBuffer(buffer, subPartitionId);
        int n = subPartitionId;
        this.subPartitionSegmentBuffers[n] = this.subPartitionSegmentBuffers[n] + 1;
        return true;
    }

    public void close() {
        if (this.hasSentRegionStart) {
            this.regionFinish();
        }
        try {
            if (this.hasRegisteredShuffle && this.partitionLocation != null) {
                this.flinkShuffleClient.mapPartitionMapperEnd(this.shuffleId, this.mapId, this.attemptId, this.numPartitions, this.numSubPartitions, this.partitionLocation.getId());
            }
        }
        catch (Exception e) {
            Utils.rethrowAsRuntimeException(e);
        }
        this.bufferPacker.close();
        this.bufferPacker = null;
        this.flinkShuffleClient.cleanup(this.shuffleId, this.mapId, this.attemptId);
        this.flinkShuffleClient = null;
    }

    private void regionStartOrFinish(int subPartitionId) {
        this.regionStart();
        if (subPartitionId < this.currentSubpartition) {
            this.regionFinish();
            LOG.debug("Check region finish sub partition id {} and start next region {}", (Object)subPartitionId, (Object)this.currentRegionIndex);
            this.regionStart();
        }
    }

    private void regionStart() {
        if (this.hasSentRegionStart) {
            return;
        }
        this.regionStartWithRevive();
    }

    private void regionStartWithRevive() {
        try {
            int remainingReviveTimes = this.maxReviveTimes;
            while (remainingReviveTimes-- > 0 && !this.hasSentRegionStart) {
                Optional<PartitionLocation> revivePartition = this.flinkShuffleClient.regionStart(this.shuffleId, this.mapId, this.attemptId, this.partitionLocation, this.currentRegionIndex, false);
                if (revivePartition.isPresent()) {
                    LOG.info("Revive at regionStart, currentTimes:{}, totalTimes:{} for shuffleId:{}, mapId:{}, attempId:{}, currentRegionIndex:{}, isBroadcast:{}, newPartition:{}, oldPartition:{}", new Object[]{remainingReviveTimes, this.maxReviveTimes, this.shuffleId, this.mapId, this.attemptId, this.currentRegionIndex, false, revivePartition, this.partitionLocation});
                    this.partitionLocation = revivePartition.get();
                    this.hasSentHandshake = false;
                    this.handshake();
                    if (this.numSubPartitions <= 0) continue;
                    for (int i = 0; i < this.numSubPartitions; ++i) {
                        this.flinkShuffleClient.segmentStart(this.shuffleId, this.mapId, this.attemptId, i, this.subPartitionSegmentIds[i], this.partitionLocation);
                    }
                    continue;
                }
                this.hasSentRegionStart = true;
                this.currentSubpartition = 0;
            }
            if (remainingReviveTimes == 0 && !this.hasSentRegionStart) {
                throw new RuntimeException("After retry " + this.maxReviveTimes + " times, still failed to send regionStart");
            }
        }
        catch (IOException e) {
            Utils.rethrowAsRuntimeException(e);
        }
    }

    void regionFinish() {
        try {
            this.bufferPacker.drain();
            this.flinkShuffleClient.regionFinish(this.shuffleId, this.mapId, this.attemptId, this.partitionLocation);
            this.hasSentRegionStart = false;
            ++this.currentRegionIndex;
        }
        catch (Exception e) {
            Utils.rethrowAsRuntimeException(e);
        }
    }

    private void handshake() throws IOException {
        try {
            int remainingReviveTimes = this.maxReviveTimes;
            while (remainingReviveTimes-- > 0 && !this.hasSentHandshake) {
                Optional<PartitionLocation> revivePartition = this.flinkShuffleClient.pushDataHandShake(this.shuffleId, this.mapId, this.attemptId, this.numSubPartitions, this.bufferSizeBytes + 22, this.partitionLocation);
                if (revivePartition.isPresent() && remainingReviveTimes > 0) {
                    LOG.info("Revive at handshake, currentTimes:{}, totalTimes:{} for shuffleId:{}, mapId:{}, attempId:{}, currentRegionIndex:{}, newPartition:{}, oldPartition:{}", new Object[]{remainingReviveTimes, this.maxReviveTimes, this.shuffleId, this.mapId, this.attemptId, this.currentRegionIndex, revivePartition, this.partitionLocation});
                    this.partitionLocation = revivePartition.get();
                    this.hasSentHandshake = false;
                    continue;
                }
                this.hasSentHandshake = true;
            }
            if (remainingReviveTimes == 0 && !this.hasSentHandshake) {
                throw new RuntimeException("After retry " + this.maxReviveTimes + " times, still failed to send handshake");
            }
        }
        catch (IOException e) {
            Utils.rethrowAsRuntimeException(e);
        }
    }

    private void releaseResources() {
        if (!this.isReleased) {
            this.isReleased = true;
        }
    }

    private void registerShuffle() {
        try {
            if (!this.hasRegisteredShuffle) {
                this.partitionLocation = this.flinkShuffleClient.registerMapPartitionTask(this.shuffleId, this.numPartitions, this.mapId, this.attemptId, this.partitionId, true);
                Utils.checkNotNull(this.partitionLocation);
                this.hasRegisteredShuffle = true;
            }
        }
        catch (IOException e) {
            Utils.rethrowAsRuntimeException(e);
        }
    }

    private void write(ByteBuf byteBuf, BufferHeader bufferHeader) {
        try {
            CompositeByteBuf compositeByteBuf = Unpooled.compositeBuffer();
            ByteBuf headerBuf = Unpooled.buffer((int)22);
            headerBuf.writeInt(bufferHeader.getSubPartitionId());
            headerBuf.writeInt(this.attemptId);
            headerBuf.writeInt(0);
            headerBuf.writeInt(byteBuf.readableBytes() + 6);
            headerBuf.writeByte(bufferHeader.getDataType().ordinal());
            headerBuf.writeBoolean(bufferHeader.isCompressed());
            headerBuf.writeInt(bufferHeader.getSize());
            compositeByteBuf.addComponents(true, new ByteBuf[]{headerBuf, byteBuf});
            org.apache.celeborn.shaded.io.netty.buffer.ByteBuf wrappedBuffer = org.apache.celeborn.shaded.io.netty.buffer.Unpooled.wrappedBuffer(compositeByteBuf.nioBuffer());
            int numWritten = this.flinkShuffleClient.pushDataToLocation(this.shuffleId, this.mapId, this.attemptId, bufferHeader.getSubPartitionId(), wrappedBuffer, this.partitionLocation, () -> ((CompositeByteBuf)compositeByteBuf).release());
            Utils.checkState(numWritten == byteBuf.readableBytes() + 22, "Wrong written size.");
        }
        catch (IOException e) {
            Utils.rethrowAsRuntimeException(e);
        }
    }

    private void appendEndOfSegmentBuffer(int subPartitionId) {
        try {
            Utils.checkState(this.bufferPacker.isEmpty(), "BufferPacker is not empty");
            MemorySegment endSegmentMemorySegment = MemorySegmentFactory.wrap((byte[])EventSerializer.toSerializedEvent((AbstractEvent)EndOfSegmentEvent.INSTANCE).array());
            NetworkBuffer endOfSegmentBuffer = new NetworkBuffer(endSegmentMemorySegment, FreeingBufferRecycler.INSTANCE, Buffer.DataType.END_OF_SEGMENT, endSegmentMemorySegment.size());
            this.processBuffer((Buffer)endOfSegmentBuffer, subPartitionId);
            this.bufferPacker.drain();
        }
        catch (Exception e) {
            ExceptionUtils.rethrow((Throwable)e, (String)"Failed to append end of segment event.");
        }
    }

    private void processBuffer(Buffer originBuffer, int subPartitionId) {
        try {
            this.regionStartOrFinish(subPartitionId);
            this.currentSubpartition = subPartitionId;
            Buffer buffer = originBuffer;
            if (originBuffer.isCompressed()) {
                NetworkBuffer networkBuffer = new NetworkBuffer(originBuffer.getMemorySegment(), originBuffer.getRecycler(), originBuffer.getDataType(), originBuffer.getSize());
                networkBuffer.writerIndex(originBuffer.asByteBuf().writerIndex());
                buffer = networkBuffer;
            }
            BufferUtils.setCompressedDataWithoutHeader(buffer, originBuffer);
            this.bufferPacker.process(buffer, subPartitionId);
        }
        catch (InterruptedException e) {
            originBuffer.recycleBuffer();
            ExceptionUtils.rethrow((Throwable)e, (String)"Failed to process buffer.");
        }
    }

    @VisibleForTesting
    FlinkShuffleClientImpl getShuffleClient() {
        try {
            return FlinkShuffleClientImpl.get(this.applicationId, this.lifecycleManagerHost, this.lifecycleManagerPort, this.lifecycleManagerTimestamp, this.celebornConf, null, this.bufferSizeBytes);
        }
        catch (DriverChangedException e) {
            throw new RuntimeException(e.getMessage());
        }
    }
}

