/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.service.deploy.worker.storage;

import java.io.File;
import org.apache.celeborn.common.identity.UserIdentifier;
import org.apache.celeborn.common.protocol.PartitionLocation;
import org.apache.celeborn.common.protocol.PartitionSplitMode;
import org.apache.celeborn.common.protocol.PartitionType;
import org.apache.celeborn.common.util.Utils;
import org.apache.celeborn.service.deploy.worker.storage.DeviceMonitor;
import org.apache.celeborn.service.deploy.worker.storage.PartitionDataWriter;

public class PartitionDataWriterContext {
    private final long splitThreshold;
    private final PartitionSplitMode partitionSplitMode;
    private final boolean rangeReadFilter;
    private final PartitionLocation partitionLocation;
    private final String appId;
    private final int shuffleId;
    private final UserIdentifier userIdentifier;
    private final boolean partitionSplitEnabled;
    private final String shuffleKey;
    private final PartitionType partitionType;
    private final boolean isSegmentGranularityVisible;
    private File workingDir;
    private PartitionDataWriter partitionDataWriter;
    private DeviceMonitor deviceMonitor;

    public PartitionDataWriterContext(long splitThreshold, PartitionSplitMode partitionSplitMode, boolean rangeReadFilter, PartitionLocation partitionLocation, String appId, int shuffleId, UserIdentifier userIdentifier, PartitionType partitionType, boolean partitionSplitEnabled, boolean isSegmentGranularityVisible) {
        this.splitThreshold = splitThreshold;
        this.partitionSplitMode = partitionSplitMode;
        this.rangeReadFilter = rangeReadFilter;
        this.partitionLocation = partitionLocation;
        this.appId = appId;
        this.shuffleId = shuffleId;
        this.userIdentifier = userIdentifier;
        this.partitionSplitEnabled = partitionSplitEnabled;
        this.partitionType = partitionType;
        this.shuffleKey = Utils.makeShuffleKey((String)appId, (int)shuffleId);
        this.isSegmentGranularityVisible = isSegmentGranularityVisible;
    }

    public long getSplitThreshold() {
        return this.splitThreshold;
    }

    public PartitionSplitMode getPartitionSplitMode() {
        return this.partitionSplitMode;
    }

    public boolean isRangeReadFilter() {
        return this.rangeReadFilter;
    }

    public PartitionLocation getPartitionLocation() {
        return this.partitionLocation;
    }

    public String getAppId() {
        return this.appId;
    }

    public int getShuffleId() {
        return this.shuffleId;
    }

    public UserIdentifier getUserIdentifier() {
        return this.userIdentifier;
    }

    public boolean isPartitionSplitEnabled() {
        return this.partitionSplitEnabled;
    }

    public String getShuffleKey() {
        return this.shuffleKey;
    }

    public PartitionType getPartitionType() {
        return this.partitionType;
    }

    public boolean isSegmentGranularityVisible() {
        return this.isSegmentGranularityVisible;
    }

    public File getWorkingDir() {
        return this.workingDir;
    }

    public void setWorkingDir(File workingDir) {
        this.workingDir = workingDir;
    }

    public PartitionDataWriter getPartitionDataWriter() {
        return this.partitionDataWriter;
    }

    public void setPartitionDataWriter(PartitionDataWriter partitionDataWriter) {
        this.partitionDataWriter = partitionDataWriter;
    }

    public DeviceMonitor getDeviceMonitor() {
        return this.deviceMonitor;
    }

    public void setDeviceMonitor(DeviceMonitor deviceMonitor) {
        this.deviceMonitor = deviceMonitor;
    }

    public String toString() {
        return "PartitionDataWriterContext{splitThreshold=" + this.splitThreshold + ", partitionSplitMode=" + this.partitionSplitMode + ", rangeReadFilter=" + this.rangeReadFilter + ", partitionLocation=" + this.partitionLocation + ", appId='" + this.appId + '\'' + ", shuffleId=" + this.shuffleId + ", userIdentifier=" + this.userIdentifier + ", partitionSplitEnabled=" + this.partitionSplitEnabled + ", shuffleKey='" + this.shuffleKey + '\'' + ", partitionType=" + this.partitionType + ", isSegmentGranularityVisible=" + this.isSegmentGranularityVisible + '}';
    }
}

