/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.network;

import java.io.File;
import java.util.List;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.internal.Logging;
import org.apache.celeborn.common.internal.Logging$class;
import org.apache.celeborn.common.network.CelebornRackResolver$;
import org.apache.celeborn.common.util.CelebornHadoopUtils$;
import org.apache.celeborn.common.util.ThreadUtils$;
import org.apache.celeborn.shaded.com.google.common.base.Strings;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.net.CachedDNSToSwitchMapping;
import org.apache.hadoop.net.DNSToSwitchMapping;
import org.apache.hadoop.net.Node;
import org.apache.hadoop.net.NodeBase;
import org.apache.hadoop.net.ScriptBasedMapping;
import org.apache.hadoop.net.TableMapping;
import org.apache.hadoop.util.ReflectionUtils;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.GenIterable;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.StringBuilder;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ObjectRef;

@ScalaSignature(bytes="\u0006\u0001\u0005-b\u0001B\u0001\u0003\u00015\u0011AcQ3mK\n|'O\u001c*bG.\u0014Vm]8mm\u0016\u0014(BA\u0002\u0005\u0003\u001dqW\r^<pe.T!!\u0002\u0004\u0002\r\r|W.\\8o\u0015\t9\u0001\"\u0001\u0005dK2,'m\u001c:o\u0015\tI!\"\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u0017\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0004\u000b\u0011\u0005=\u0011R\"\u0001\t\u000b\u0003E\tQa]2bY\u0006L!a\u0005\t\u0003\r\u0005s\u0017PU3g!\t)\u0002$D\u0001\u0017\u0015\t9B!\u0001\u0005j]R,'O\\1m\u0013\tIbCA\u0004M_\u001e<\u0017N\\4\t\u0011m\u0001!\u0011!Q\u0001\nq\tAbY3mK\n|'O\\\"p]\u001a\u0004\"!\b\u0010\u000e\u0003\u0011I!a\b\u0003\u0003\u0019\r+G.\u001a2pe:\u001cuN\u001c4\t\u000b\u0005\u0002A\u0011\u0001\u0012\u0002\rqJg.\u001b;?)\t\u0019S\u0005\u0005\u0002%\u00015\t!\u0001C\u0003\u001cA\u0001\u0007A\u0004C\u0005(\u0001\u0001\u0007\t\u0019!C\u0005Q\u0005a\"/Y2l%\u0016\u001cx\u000e\u001c<f%\u00164'/Z:i)\"\u0014X-\u00193Q_>dW#A\u0015\u0011\u0005)\nT\"A\u0016\u000b\u00051j\u0013AC2p]\u000e,(O]3oi*\u0011afL\u0001\u0005kRLGNC\u00011\u0003\u0011Q\u0017M^1\n\u0005IZ#\u0001G*dQ\u0016$W\u000f\\3e\u000bb,7-\u001e;peN+'O^5dK\"IA\u0007\u0001a\u0001\u0002\u0004%I!N\u0001!e\u0006\u001c7NU3t_24XMU3ge\u0016\u001c\b\u000e\u00165sK\u0006$\u0007k\\8m?\u0012*\u0017\u000f\u0006\u00027sA\u0011qbN\u0005\u0003qA\u0011A!\u00168ji\"9!hMA\u0001\u0002\u0004I\u0013a\u0001=%c!1A\b\u0001Q!\n%\nQD]1dWJ+7o\u001c7wKJ+gM]3tQRC'/Z1e!>|G\u000e\t\u0005\b}\u0001\u0001\r\u0011\"\u0003@\u0003m\u0011\u0018mY6SKN|GN^3MCN$Xj\u001c3jM&,G\rV5nKV\t\u0001\t\u0005\u0002\u0010\u0003&\u0011!\t\u0005\u0002\u0005\u0019>tw\rC\u0004E\u0001\u0001\u0007I\u0011B#\u0002?I\f7m\u001b*fg>dg/\u001a'bgRlu\u000eZ5gS\u0016$G+[7f?\u0012*\u0017\u000f\u0006\u00027\r\"9!hQA\u0001\u0002\u0004\u0001\u0005B\u0002%\u0001A\u0003&\u0001)\u0001\u000fsC\u000e\\'+Z:pYZ,G*Y:u\u001b>$\u0017NZ5fIRKW.\u001a\u0011\t\u000f)\u0003!\u0019!C\u0005\u0017\u0006\u0011BM\\:U_N;\u0018\u000e^2i\u001b\u0006\u0004\b/\u001b8h+\u0005a\u0005CA'S\u001b\u0005q%BA(Q\u0003\rqW\r\u001e\u0006\u0003#\"\ta\u0001[1e_>\u0004\u0018BA*O\u0005I!ej\u0015+p'^LGo\u00195NCB\u0004\u0018N\\4\t\rU\u0003\u0001\u0015!\u0003M\u0003M!gn\u001d+p'^LGo\u00195NCB\u0004\u0018N\\4!\u0011\u00159\u0006\u0001\"\u0001Y\u0003\u0011\u0019Ho\u001c9\u0015\u0003YBQA\u0017\u0001\u0005\u0002m\u000bqA]3t_24X\r\u0006\u0002]?B\u0011Q*X\u0005\u0003=:\u0013AAT8eK\")\u0001-\u0017a\u0001C\u0006A\u0001n\\:u\u001d\u0006lW\r\u0005\u0002cK:\u0011qbY\u0005\u0003IB\ta\u0001\u0015:fI\u00164\u0017B\u00014h\u0005\u0019\u0019FO]5oO*\u0011A\r\u0005\u0005\u00065\u0002!\t!\u001b\u000b\u0003UZ\u00042a[:]\u001d\ta\u0017O\u0004\u0002na6\taN\u0003\u0002p\u0019\u00051AH]8pizJ\u0011!E\u0005\u0003eB\tq\u0001]1dW\u0006<W-\u0003\u0002uk\n\u00191+Z9\u000b\u0005I\u0004\u0002\"B<i\u0001\u0004A\u0018!\u00035pgRt\u0015-\\3t!\rY7/\u0019\u0005\u0006u\u0002!\ta_\u0001\re\u0016\u001cx\u000e\u001c<f)>l\u0015\r\u001d\u000b\u0003y~\u0004BAY?b9&\u0011ap\u001a\u0002\u0004\u001b\u0006\u0004\bBB<z\u0001\u0004\t\t\u0001E\u0003\u0002\u0004\u0005\u0015\u0011-D\u0001.\u0013\r\t9!\f\u0002\u0005\u0019&\u001cH\u000f\u0003\u0004{\u0001\u0011\u0005\u00111\u0002\u000b\u0004y\u00065\u0001BB<\u0002\n\u0001\u0007\u0001\u0010C\u0004\u0002\u0012\u0001!I!a\u0005\u0002\u0017\r|'/\u001a*fg>dg/\u001a\u000b\u0004U\u0006U\u0001BB<\u0002\u0010\u0001\u0007\u0001\u0010C\u0004\u0002\u001a\u0001!\t!a\u0007\u0002\u0019%\u001cxJ\\*b[\u0016\u0014\u0016mY6\u0015\r\u0005u\u00111EA\u0014!\ry\u0011qD\u0005\u0004\u0003C\u0001\"a\u0002\"p_2,\u0017M\u001c\u0005\b\u0003K\t9\u00021\u0001b\u0003-\u0001(/[7befDun\u001d;\t\u000f\u0005%\u0012q\u0003a\u0001C\u0006Y!/\u001a9mS\u000e\f\u0007j\\:u\u0001")
public class CelebornRackResolver
implements Logging {
    private ScheduledExecutorService rackResolveRefreshThreadPool;
    private long org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime;
    private final DNSToSwitchMapping dnsToSwitchMapping;
    private final transient Logger log;
    private volatile transient boolean bitmap$trans$0;

    private Logger log$lzycompute() {
        CelebornRackResolver celebornRackResolver = this;
        synchronized (celebornRackResolver) {
            if (!this.bitmap$trans$0) {
                this.log = Logging$class.log(this);
                this.bitmap$trans$0 = true;
            }
            return this.log;
        }
    }

    @Override
    public Logger log() {
        return this.bitmap$trans$0 ? this.log : this.log$lzycompute();
    }

    @Override
    public String logName() {
        return Logging$class.logName(this);
    }

    @Override
    public void logTrace(Function0<String> msg) {
        Logging$class.logTrace(this, msg);
    }

    @Override
    public void logDebug(Function0<String> msg) {
        Logging$class.logDebug(this, msg);
    }

    @Override
    public void logInfo(Function0<String> msg) {
        Logging$class.logInfo(this, msg);
    }

    @Override
    public void logWarning(Function0<String> msg) {
        Logging$class.logWarning(this, msg);
    }

    @Override
    public void logError(Function0<String> msg) {
        Logging$class.logError(this, msg);
    }

    @Override
    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging$class.logTrace(this, msg, throwable);
    }

    @Override
    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging$class.logDebug(this, msg, throwable);
    }

    @Override
    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging$class.logInfo(this, msg, throwable);
    }

    @Override
    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging$class.logWarning(this, msg, throwable);
    }

    @Override
    public void logError(Function0<String> msg, Throwable throwable) {
        Logging$class.logError(this, msg, throwable);
    }

    private ScheduledExecutorService rackResolveRefreshThreadPool() {
        return this.rackResolveRefreshThreadPool;
    }

    private void rackResolveRefreshThreadPool_$eq(ScheduledExecutorService x$1) {
        this.rackResolveRefreshThreadPool = x$1;
    }

    public long org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime() {
        return this.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime;
    }

    public void org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime_$eq(long x$1) {
        this.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime = x$1;
    }

    private DNSToSwitchMapping dnsToSwitchMapping() {
        return this.dnsToSwitchMapping;
    }

    public void stop() {
        if (this.rackResolveRefreshThreadPool() != null) {
            this.rackResolveRefreshThreadPool().shutdownNow();
        }
    }

    public Node resolve(String hostName) {
        return (Node)this.coreResolve((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{hostName})))).head();
    }

    public Seq<Node> resolve(Seq<String> hostNames) {
        return this.coreResolve(hostNames);
    }

    public Map<String, Node> resolveToMap(List<String> hostNames) {
        return this.resolveToMap((Seq<String>)((SeqLike)JavaConverters$.MODULE$.asScalaBufferConverter(hostNames).asScala()).toSeq());
    }

    public Map<String, Node> resolveToMap(Seq<String> hostNames) {
        return ((TraversableOnce)hostNames.zip(this.resolve(hostNames), Seq$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    private Seq<Node> coreResolve(Seq<String> hostNames) {
        if (hostNames.isEmpty()) {
            return (Seq)Seq$.MODULE$.empty();
        }
        ArrayBuffer nodes = new ArrayBuffer();
        Buffer rNameList = (Buffer)JavaConverters$.MODULE$.asScalaBufferConverter(this.dnsToSwitchMapping().resolve((List)JavaConverters$.MODULE$.seqAsJavaListConverter((Seq)hostNames.toList()).asJava())).asScala();
        if (rNameList == null || rNameList.isEmpty()) {
            hostNames.foreach((Function1)new Serializable(this, nodes){
                public static final long serialVersionUID = 0L;
                private final ArrayBuffer nodes$1;

                public final ArrayBuffer<Node> apply(String x$1) {
                    return this.nodes$1.$plus$eq((Object)new NodeBase(x$1, "/default-rack"));
                }
                {
                    this.nodes$1 = nodes$1;
                }
            });
            this.logInfo((Function0<String>)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final String apply() {
                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Got an error when resolving hostNames. "})).s((Seq)Nil$.MODULE$)).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to ", " for all"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"/default-rack"}))).toString();
                }
            });
        } else {
            ((TraversableLike)hostNames.zip((GenIterable)rNameList, Seq$.MODULE$.canBuildFrom())).withFilter((Function1)new Serializable(this){
                public static final long serialVersionUID = 0L;

                public final boolean apply(Tuple2<String, String> check$ifrefutable$1) {
                    Tuple2<String, String> tuple2 = check$ifrefutable$1;
                    boolean bl = tuple2 != null;
                    return bl;
                }
            }).foreach((Function1)new Serializable(this, nodes){
                public static final long serialVersionUID = 0L;
                private final /* synthetic */ CelebornRackResolver $outer;
                private final ArrayBuffer nodes$1;

                public final Object apply(Tuple2<String, String> x$2) {
                    Tuple2<String, String> tuple2 = x$2;
                    if (tuple2 != null) {
                        ArrayBuffer arrayBuffer;
                        String hostName = (String)tuple2._1();
                        String rName = (String)tuple2._2();
                        if (Strings.isNullOrEmpty(rName)) {
                            this.nodes$1.$plus$eq((Object)new NodeBase(hostName, "/default-rack"));
                            this.$outer.logDebug((Function0<String>)new Serializable(this, hostName){
                                public static final long serialVersionUID = 0L;
                                private final String hostName$1;

                                public final String apply() {
                                    return new StringBuilder().append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Could not resolve ", ". "})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.hostName$1}))).append((Object)new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Falling back to ", ""})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{"/default-rack"}))).toString();
                                }
                                {
                                    this.hostName$1 = hostName$1;
                                }
                            });
                            arrayBuffer = BoxedUnit.UNIT;
                        } else {
                            arrayBuffer = this.nodes$1.$plus$eq((Object)new NodeBase(hostName, rName));
                        }
                        ArrayBuffer arrayBuffer2 = arrayBuffer;
                        return arrayBuffer2;
                    }
                    throw new MatchError(tuple2);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.nodes$1 = nodes$1;
                }
            });
        }
        return nodes.toList();
    }

    public boolean isOnSameRack(String primaryHost, String replicaHost) {
        Seq<Node> nodes = this.resolve((Seq<String>)((Seq)Seq$.MODULE$.apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{primaryHost, replicaHost}))));
        Tuple2 tuple2 = new Tuple2(nodes.head(), nodes.last());
        if (tuple2 != null) {
            boolean bl;
            Tuple2 tuple22;
            Node primaryNode = (Node)tuple2._1();
            Node replicaNode = (Node)tuple2._2();
            Tuple2 tuple23 = tuple22 = new Tuple2((Object)primaryNode, (Object)replicaNode);
            Node primaryNode2 = (Node)tuple23._1();
            Node replicaNode2 = (Node)tuple23._2();
            if (primaryNode2 == null || replicaNode2 == null) {
                bl = false;
            } else {
                String string = primaryNode2.getNetworkLocation();
                String string2 = replicaNode2.getNetworkLocation();
                bl = !(string != null ? !string.equals(string2) : string2 != null);
            }
            return bl;
        }
        throw new MatchError((Object)tuple2);
    }

    public CelebornRackResolver(CelebornConf celebornConf) {
        ScheduledFuture<?> scheduledFuture;
        CachedDNSToSwitchMapping cachedDNSToSwitchMapping;
        DNSToSwitchMapping switchMapping;
        Logging$class.$init$(this);
        this.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime = 0L;
        Configuration conf = CelebornHadoopUtils$.MODULE$.newConfiguration(celebornConf);
        Class dnsToSwitchMappingClass = conf.getClass("net.topology.node.switch.mapping.impl", ScriptBasedMapping.class, DNSToSwitchMapping.class);
        DNSToSwitchMapping dNSToSwitchMapping = switchMapping = (DNSToSwitchMapping)ReflectionUtils.newInstance((Class)dnsToSwitchMappingClass, (Configuration)conf);
        CachedDNSToSwitchMapping cachedDNSToSwitchMapping2 = dNSToSwitchMapping instanceof CachedDNSToSwitchMapping ? (cachedDNSToSwitchMapping = (CachedDNSToSwitchMapping)dNSToSwitchMapping) : new CachedDNSToSwitchMapping(dNSToSwitchMapping);
        CachedDNSToSwitchMapping mapping = cachedDNSToSwitchMapping2;
        long refreshInterval = celebornConf.rackResolverRefreshInterval();
        this.rackResolveRefreshThreadPool_$eq(ThreadUtils$.MODULE$.newDaemonSingleThreadScheduledExecutor("master-rack-resolver-refresher"));
        DNSToSwitchMapping dNSToSwitchMapping2 = switchMapping;
        String string = dNSToSwitchMapping2 instanceof ScriptBasedMapping ? conf.get("net.topology.script.file.name") : (dNSToSwitchMapping2 instanceof TableMapping ? conf.get("net.topology.table.file.name") : null);
        String fileName = string;
        if (fileName == null) {
            scheduledFuture = this.rackResolveRefreshThreadPool().scheduleWithFixedDelay(new Runnable(this, mapping){
                private final CachedDNSToSwitchMapping mapping$1;

                public void run() {
                    this.mapping$1.reloadCachedMappings();
                }
                {
                    this.mapping$1 = mapping$1;
                }
            }, refreshInterval, refreshInterval, TimeUnit.MILLISECONDS);
        } else {
            ObjectRef scriptFile = ObjectRef.create((Object)new File(fileName));
            this.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime_$eq(((File)scriptFile.elem).lastModified());
            scheduledFuture = this.rackResolveRefreshThreadPool().scheduleWithFixedDelay(new Runnable(this, mapping, fileName, scriptFile){
                private final /* synthetic */ CelebornRackResolver $outer;
                private final CachedDNSToSwitchMapping mapping$1;
                public final String fileName$1;
                private final ObjectRef scriptFile$1;

                public void run() {
                    this.scriptFile$1.elem = new File(this.fileName$1);
                    if (((File)this.scriptFile$1.elem).canRead()) {
                        long currentLastModifiedTime = ((File)this.scriptFile$1.elem).lastModified();
                        if (currentLastModifiedTime != this.$outer.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime()) {
                            this.$outer.org$apache$celeborn$common$network$CelebornRackResolver$$rackResolveLastModifiedTime_$eq(currentLastModifiedTime);
                            this.mapping$1.reloadCachedMappings();
                        }
                    } else {
                        this.$outer.logWarning((Function0<String>)new Serializable(this){
                            public static final long serialVersionUID = 0L;
                            private final /* synthetic */ $anon$1 $outer;

                            public final String apply() {
                                return new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Script file ", " is not readable, reload cache directly"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{this.$outer.fileName$1}));
                            }
                            {
                                if ($outer == null) {
                                    throw null;
                                }
                                this.$outer = $outer;
                            }
                        });
                        this.mapping$1.reloadCachedMappings();
                    }
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.mapping$1 = mapping$1;
                    this.fileName$1 = fileName$1;
                    this.scriptFile$1 = scriptFile$1;
                }
            }, refreshInterval, refreshInterval, TimeUnit.MILLISECONDS);
        }
        this.dnsToSwitchMapping = mapping;
    }
}

