/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.util;

import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import scala.reflect.ScalaSignature;

@ScalaSignature(bytes="\u0006\u000153A!\u0001\u0002\u0001\u001b\t91*Z=M_\u000e\\'BA\u0002\u0005\u0003\u0011)H/\u001b7\u000b\u0005\u00151\u0011AB2p[6|gN\u0003\u0002\b\u0011\u0005A1-\u001a7fE>\u0014hN\u0003\u0002\n\u0015\u00051\u0011\r]1dQ\u0016T\u0011aC\u0001\u0004_J<7\u0001A\u000b\u0003\u001dq\u0019\"\u0001A\b\u0011\u0005A\u0019R\"A\t\u000b\u0003I\tQa]2bY\u0006L!\u0001F\t\u0003\r\u0005s\u0017PU3g\u0011\u00151\u0002\u0001\"\u0001\u0018\u0003\u0019a\u0014N\\5u}Q\t\u0001\u0004E\u0002\u001a\u0001ii\u0011A\u0001\t\u00037qa\u0001\u0001B\u0003\u001e\u0001\t\u0007aDA\u0001L#\ty\"\u0005\u0005\u0002\u0011A%\u0011\u0011%\u0005\u0002\b\u001d>$\b.\u001b8h!\t\u00012%\u0003\u0002%#\t\u0019\u0011I\\=\t\u000f\u0019\u0002!\u0019!C\u0005O\u00059An\\2l\u001b\u0006\u0004X#\u0001\u0015\u0011\t%z#dD\u0007\u0002U)\u00111\u0006L\u0001\u000bG>t7-\u001e:sK:$(BA\u0002.\u0015\u0005q\u0013\u0001\u00026bm\u0006L!\u0001\r\u0016\u0003#\r{gnY;se\u0016tG\u000fS1tQ6\u000b\u0007\u000f\u0003\u00043\u0001\u0001\u0006I\u0001K\u0001\tY>\u001c7.T1qA!)A\u0007\u0001C\u0005k\u0005Y\u0011mY9vSJ,Gj\\2l)\t1\u0014\b\u0005\u0002\u0011o%\u0011\u0001(\u0005\u0002\u0005+:LG\u000fC\u0003;g\u0001\u0007!$A\u0002lKfDQ\u0001\u0010\u0001\u0005\nu\n1B]3mK\u0006\u001cX\rT8dWR\u0011aG\u0010\u0005\u0006um\u0002\rA\u0007\u0005\u0006\u0001\u0002!\t!Q\u0001\to&$\b\u000eT8dWV\u0011!)\u0012\u000b\u0003\u00072#\"\u0001R$\u0011\u0005m)E!\u0002$@\u0005\u0004q\"!\u0001+\t\u000b!{\u0004\u0019A%\u0002\t\u0019,hn\u0019\t\u0004S)#\u0015BA&+\u0005!\u0019\u0015\r\u001c7bE2,\u0007\"\u0002\u001e@\u0001\u0004Q\u0002")
public class KeyLock<K> {
    private final ConcurrentHashMap<K, Object> lockMap = new ConcurrentHashMap();

    private ConcurrentHashMap<K, Object> lockMap() {
        return this.lockMap;
    }

    private void acquireLock(K key) {
        Object lock;
        while ((lock = this.lockMap().putIfAbsent(key, new Object())) != null) {
            Object object = lock;
            synchronized (object) {
                while (this.lockMap().get(key) == lock) {
                    lock.wait();
                }
            }
        }
        return;
    }

    private void releaseLock(K key) {
        Object lock;
        Object object = lock = this.lockMap().remove(key);
        synchronized (object) {
            lock.notifyAll();
            return;
        }
    }

    public <T> T withLock(K key, Callable<T> func) {
        if (key == null) {
            throw new NullPointerException("key must not be null");
        }
        this.acquireLock(key);
        try {
            return func.call();
        }
        finally {
            this.releaseLock(key);
        }
    }
}

