/*
 * Decompiled with CFR 0.152.
 */
package org.apache.celeborn.common.write;

import java.io.IOException;
import org.apache.celeborn.common.CelebornConf;
import org.apache.celeborn.common.write.PushState;
import org.apache.celeborn.common.write.SimplePushStrategy;
import org.apache.celeborn.common.write.SlowStartPushStrategy;

public abstract class PushStrategy {
    protected final CelebornConf conf;

    public static PushStrategy getStrategy(CelebornConf conf) {
        String strategyName;
        switch (strategyName = conf.clientPushLimitStrategy()) {
            case "SIMPLE": {
                return new SimplePushStrategy(conf);
            }
            case "SLOWSTART": {
                return new SlowStartPushStrategy(conf);
            }
        }
        throw new IllegalArgumentException("The strategy " + strategyName + " is not supported!");
    }

    public PushStrategy(CelebornConf conf) {
        this.conf = conf;
    }

    public abstract void onSuccess(String var1);

    public abstract void onCongestControl(String var1);

    public abstract void clear();

    public abstract void limitPushSpeed(PushState var1, String var2) throws IOException;

    public abstract int getCurrentMaxReqsInFlight(String var1);
}

