/*
 * Decompiled with CFR 0.152.
 */
package org.apache.datasketches.quantiles;

import org.apache.datasketches.quantilescommon.DoublesSortedViewIterator;
import org.apache.datasketches.quantilescommon.QuantileSearchCriteria;

public final class DoublesSketchSortedViewIterator
implements DoublesSortedViewIterator {
    private final double[] quantiles;
    private final long[] cumWeights;
    private final long totalN;
    private int index;

    DoublesSketchSortedViewIterator(double[] quantiles, long[] cumWeights) {
        this.quantiles = quantiles;
        this.cumWeights = cumWeights;
        this.totalN = cumWeights.length > 0 ? cumWeights[cumWeights.length - 1] : 0L;
        this.index = -1;
    }

    @Override
    public long getCumulativeWeight(QuantileSearchCriteria searchCrit) {
        if (searchCrit == QuantileSearchCriteria.INCLUSIVE) {
            return this.cumWeights[this.index];
        }
        return this.index == 0 ? 0L : this.cumWeights[this.index - 1];
    }

    @Override
    public long getN() {
        return this.totalN;
    }

    @Override
    public double getNormalizedRank(QuantileSearchCriteria searchCrit) {
        return (double)this.getCumulativeWeight(searchCrit) / (double)this.totalN;
    }

    @Override
    public double getQuantile() {
        return this.quantiles[this.index];
    }

    @Override
    public long getWeight() {
        if (this.index == 0) {
            return this.cumWeights[0];
        }
        return this.cumWeights[this.index] - this.cumWeights[this.index - 1];
    }

    @Override
    public boolean next() {
        ++this.index;
        return this.index < this.quantiles.length;
    }
}

