/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.sql.calcite.schema;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.base.Preconditions;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.DataContext;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.impl.AbstractTable;
import org.apache.druid.discovery.DiscoveryDruidNode;
import org.apache.druid.discovery.DruidNodeDiscoveryProvider;
import org.apache.druid.error.InternalServerError;
import org.apache.druid.java.util.common.RE;
import org.apache.druid.java.util.http.client.HttpClient;
import org.apache.druid.java.util.http.client.Request;
import org.apache.druid.java.util.http.client.response.HttpResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHandler;
import org.apache.druid.java.util.http.client.response.StringFullResponseHolder;
import org.apache.druid.segment.column.ColumnType;
import org.apache.druid.segment.column.RowSignature;
import org.apache.druid.server.DruidNode;
import org.apache.druid.server.security.AuthenticationResult;
import org.apache.druid.server.security.AuthorizerMapper;
import org.apache.druid.sql.calcite.schema.SystemSchema;
import org.apache.druid.sql.calcite.table.RowSignatures;
import org.jboss.netty.handler.codec.http.HttpMethod;

public class SystemServerPropertiesTable
extends AbstractTable
implements ScannableTable {
    public static final String TABLE_NAME = "server_properties";
    static final RowSignature ROW_SIGNATURE = RowSignature.builder().add("server", ColumnType.STRING).add("service_name", ColumnType.STRING).add("node_roles", ColumnType.STRING).add("property", ColumnType.STRING).add("value", ColumnType.STRING).build();
    private final DruidNodeDiscoveryProvider druidNodeDiscoveryProvider;
    private final AuthorizerMapper authorizerMapper;
    private final HttpClient httpClient;
    private final ObjectMapper jsonMapper;

    public SystemServerPropertiesTable(DruidNodeDiscoveryProvider druidNodeDiscoveryProvider, AuthorizerMapper authorizerMapper, HttpClient httpClient, ObjectMapper jsonMapper) {
        this.druidNodeDiscoveryProvider = druidNodeDiscoveryProvider;
        this.authorizerMapper = authorizerMapper;
        this.httpClient = httpClient;
        this.jsonMapper = jsonMapper;
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return RowSignatures.toRelDataType(ROW_SIGNATURE, typeFactory);
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.SYSTEM_TABLE;
    }

    public Enumerable<Object[]> scan(DataContext root) {
        AuthenticationResult authenticationResult = (AuthenticationResult)Preconditions.checkNotNull((Object)root.get("authenticationResult"), (Object)"authenticationResult in dataContext");
        SystemSchema.checkStateReadAccessForServers(authenticationResult, this.authorizerMapper);
        Iterator<DiscoveryDruidNode> druidServers = SystemSchema.getDruidServers(this.druidNodeDiscoveryProvider);
        HashMap serverToPropertiesMap = new HashMap();
        druidServers.forEachRemaining(discoveryDruidNode -> {
            DruidNode druidNode = discoveryDruidNode.getDruidNode();
            Map<String, String> propertiesMap = this.getProperties(druidNode);
            if (serverToPropertiesMap.containsKey(druidNode.getHostAndPortToUse())) {
                ServerProperties serverProperties = (ServerProperties)serverToPropertiesMap.get(druidNode.getHostAndPortToUse());
                serverProperties.addNodeRole(discoveryDruidNode.getNodeRole().getJsonName());
            } else {
                serverToPropertiesMap.put(druidNode.getHostAndPortToUse(), new ServerProperties(druidNode.getServiceName(), druidNode.getHostAndPortToUse(), new ArrayList<String>(Arrays.asList(discoveryDruidNode.getNodeRole().getJsonName())), propertiesMap));
            }
        });
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        for (ServerProperties serverProperties : serverToPropertiesMap.values()) {
            rows.addAll(serverProperties.toRows());
        }
        return Linq4j.asEnumerable(rows);
    }

    private Map<String, String> getProperties(DruidNode druidNode) {
        String url = druidNode.getUriToUse().resolve("/status/properties").toString();
        try {
            Request request = new Request(HttpMethod.GET, new URL(url));
            StringFullResponseHolder response = (StringFullResponseHolder)this.httpClient.go(request, (HttpResponseHandler)new StringFullResponseHandler(StandardCharsets.UTF_8)).get();
            if (response.getStatus().getCode() != 200) {
                throw new RE("Failed to get properties from node[%s]. Error code[%d], description[%s].", new Object[]{url, response.getStatus().getCode(), response.getStatus().getReasonPhrase()});
            }
            return (Map)this.jsonMapper.readValue(response.getContent(), (TypeReference)new TypeReference<Map<String, String>>(){});
        }
        catch (Exception e) {
            throw InternalServerError.exception((Throwable)e, (String)"HTTP request to[%s] failed", (Object[])new Object[]{url});
        }
    }

    private static class ServerProperties {
        final String serviceName;
        final String server;
        final List<String> nodeRoles;
        final Map<String, String> properties;

        public ServerProperties(String serviceName, String server, List<String> nodeRoles, Map<String, String> properties) {
            this.serviceName = serviceName;
            this.server = server;
            this.nodeRoles = nodeRoles;
            this.properties = properties;
        }

        public void addNodeRole(String nodeRole) {
            this.nodeRoles.add(nodeRole);
        }

        public List<Object[]> toRows() {
            String nodeRolesString = this.nodeRoles.toString();
            return this.properties.entrySet().stream().map(entry -> new Object[]{this.server, this.serviceName, nodeRolesString, entry.getKey(), entry.getValue()}).collect(Collectors.toList());
        }
    }
}

