/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.common.actions;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.core.type.TypeReference;
import com.google.common.base.Optional;
import java.util.Objects;
import org.apache.druid.error.InvalidInput;
import org.apache.druid.indexer.TaskLocation;
import org.apache.druid.indexing.common.actions.TaskAction;
import org.apache.druid.indexing.common.actions.TaskActionToolbox;
import org.apache.druid.indexing.common.task.Task;
import org.apache.druid.indexing.overlord.TaskRunner;

public class UpdateLocationAction
implements TaskAction<Void> {
    private final TaskLocation location;

    @JsonCreator
    public UpdateLocationAction(@JsonProperty(value="location") TaskLocation location) {
        InvalidInput.conditionalException((location != null ? 1 : 0) != 0, (String)"No task location specified", (Object[])new Object[0]);
        this.location = location;
    }

    @JsonProperty
    public TaskLocation getLocation() {
        return this.location;
    }

    @Override
    public TypeReference<Void> getReturnTypeReference() {
        return new TypeReference<Void>(){};
    }

    @Override
    public Void perform(Task task, TaskActionToolbox toolbox) {
        Optional<TaskRunner> taskRunner = toolbox.getTaskRunner();
        if (taskRunner.isPresent()) {
            ((TaskRunner)taskRunner.get()).updateLocation(task, this.location);
        }
        return null;
    }

    @Override
    public String toString() {
        return "UpdateLocationAction{taskLocation=" + String.valueOf(this.location) + "}";
    }

    public boolean equals(Object object) {
        if (this == object) {
            return true;
        }
        if (object == null || this.getClass() != object.getClass()) {
            return false;
        }
        UpdateLocationAction that = (UpdateLocationAction)object;
        return Objects.equals(this.location, that.location);
    }

    public int hashCode() {
        return Objects.hashCode(this.location);
    }
}

