/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import java.io.File;
import java.util.Objects;
import javax.annotation.Nullable;
import org.apache.druid.indexer.partitions.PartitionsSpec;
import org.apache.druid.indexing.seekablestream.SeekableStreamIndexTaskTuningConfig;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.DruidProcessingConfig;
import org.apache.druid.segment.IndexSpec;
import org.apache.druid.segment.incremental.AppendableIndexSpec;
import org.apache.druid.segment.indexing.TuningConfig;
import org.apache.druid.segment.realtime.appenderator.AppenderatorConfig;
import org.apache.druid.segment.writeout.SegmentWriteOutMediumFactory;
import org.apache.druid.utils.JvmUtils;
import org.apache.druid.utils.RuntimeInfo;
import org.joda.time.Period;

public class SeekableStreamAppenderatorConfig
implements AppenderatorConfig {
    private static final Logger log = new Logger(SeekableStreamAppenderatorConfig.class);
    public static final int APPENDERATOR_MERGE_ROUGH_HEAP_MEMORY_PER_COLUMN = 3000;
    public static final int APPENDERATOR_MERGE_ROUGH_DIRECT_MEMORY_PER_COLUMN = 98304;
    private final SeekableStreamIndexTaskTuningConfig tuningConfig;
    private final int maxColumnsToMerge;

    private SeekableStreamAppenderatorConfig(SeekableStreamIndexTaskTuningConfig tuningConfig, int maxColumnsToMerge) {
        this.tuningConfig = tuningConfig;
        this.maxColumnsToMerge = maxColumnsToMerge;
    }

    public static SeekableStreamAppenderatorConfig fromTuningConfig(SeekableStreamIndexTaskTuningConfig tuningConfig, @Nullable DruidProcessingConfig processingConfig) {
        if (processingConfig == null) {
            return new SeekableStreamAppenderatorConfig(tuningConfig, tuningConfig.getMaxColumnsToMerge());
        }
        int maxColumnsToMerge = tuningConfig.getMaxColumnsToMerge() == -1 ? SeekableStreamAppenderatorConfig.calculateDefaultMaxColumnsToMerge(JvmUtils.getRuntimeInfo(), processingConfig, tuningConfig) : tuningConfig.getMaxColumnsToMerge();
        return new SeekableStreamAppenderatorConfig(tuningConfig, maxColumnsToMerge);
    }

    public boolean isReportParseExceptions() {
        return this.tuningConfig.isReportParseExceptions();
    }

    public int getMaxPendingPersists() {
        return this.tuningConfig.getMaxPendingPersists();
    }

    public boolean isSkipBytesInMemoryOverheadCheck() {
        return this.tuningConfig.isSkipBytesInMemoryOverheadCheck();
    }

    public Period getIntermediatePersistPeriod() {
        return this.tuningConfig.getIntermediatePersistPeriod();
    }

    public File getBasePersistDirectory() {
        return this.tuningConfig.getBasePersistDirectory();
    }

    public AppenderatorConfig withBasePersistDirectory(File basePersistDirectory) {
        return new SeekableStreamAppenderatorConfig(this.tuningConfig.withBasePersistDirectory(basePersistDirectory), this.maxColumnsToMerge);
    }

    public SegmentWriteOutMediumFactory getSegmentWriteOutMediumFactory() {
        return this.tuningConfig.getSegmentWriteOutMediumFactory();
    }

    public AppendableIndexSpec getAppendableIndexSpec() {
        return this.tuningConfig.getAppendableIndexSpec();
    }

    public int getMaxRowsInMemory() {
        return this.tuningConfig.getMaxRowsInMemory();
    }

    public long getMaxBytesInMemory() {
        return this.tuningConfig.getMaxBytesInMemory();
    }

    public PartitionsSpec getPartitionsSpec() {
        return this.tuningConfig.getPartitionsSpec();
    }

    public IndexSpec getIndexSpec() {
        return this.tuningConfig.getIndexSpec();
    }

    public IndexSpec getIndexSpecForIntermediatePersists() {
        return this.tuningConfig.getIndexSpecForIntermediatePersists();
    }

    public int getNumPersistThreads() {
        return this.tuningConfig.getNumPersistThreads();
    }

    public Integer getMaxRowsPerSegment() {
        return this.tuningConfig.getMaxRowsPerSegment();
    }

    public Long getMaxTotalRows() {
        return this.tuningConfig.getMaxTotalRows();
    }

    public int getMaxColumnsToMerge() {
        return this.maxColumnsToMerge;
    }

    public boolean isReleaseLocksOnHandoff() {
        return this.tuningConfig.isReleaseLocksOnHandoff();
    }

    public boolean equals(Object o) {
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        SeekableStreamAppenderatorConfig that = (SeekableStreamAppenderatorConfig)o;
        return this.maxColumnsToMerge == that.maxColumnsToMerge && Objects.equals(this.tuningConfig, that.tuningConfig);
    }

    public int hashCode() {
        return Objects.hash(this.tuningConfig, this.maxColumnsToMerge);
    }

    static int calculateDefaultMaxColumnsToMerge(RuntimeInfo runtimeInfo, DruidProcessingConfig processingConfig, TuningConfig tuningConfig) {
        int maxColumnsToMergeBasedOnHeapMemory = SeekableStreamAppenderatorConfig.getMaxColumnsToMergeBasedOnHeapMemory(tuningConfig);
        int maxColumnsToMergeBasedOnDirectMemory = SeekableStreamAppenderatorConfig.getMaxColumnsToMergeBasedOnDirectMemory(runtimeInfo, processingConfig);
        return Math.min(maxColumnsToMergeBasedOnHeapMemory, maxColumnsToMergeBasedOnDirectMemory);
    }

    static int getMaxColumnsToMergeBasedOnHeapMemory(TuningConfig tuningConfig) {
        long heapMemoryForMerging = tuningConfig.getMaxBytesInMemory() >= 0L ? tuningConfig.getMaxBytesInMemoryOrDefault() : tuningConfig.getAppendableIndexSpec().getDefaultMaxBytesInMemory();
        return (int)Math.min(heapMemoryForMerging / 3000L, Integer.MAX_VALUE);
    }

    static int getMaxColumnsToMergeBasedOnDirectMemory(RuntimeInfo runtimeInfo, DruidProcessingConfig processingConfig) {
        long directMemorySizeBytes;
        long directMemoryForQueries = (long)processingConfig.intermediateComputeSizeBytes() * (long)(processingConfig.getNumThreads() + processingConfig.getNumMergeBuffers());
        try {
            directMemorySizeBytes = runtimeInfo.getDirectMemorySizeBytes();
        }
        catch (UnsupportedOperationException e) {
            directMemorySizeBytes = directMemoryForQueries + (long)processingConfig.intermediateComputeSizeBytes();
            log.noStackTrace().warn((Throwable)e, "Ignoring direct memory when sizing maxColumnsToMerge; cannot retrieve. Assuming direct memory is at least [%,d] bytes.", new Object[]{directMemorySizeBytes});
        }
        return (int)Math.min((directMemorySizeBytes - directMemoryForQueries) / 98304L, Integer.MAX_VALUE);
    }
}

