/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream;

import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.FluentIterable;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import javax.annotation.Nullable;
import org.apache.druid.data.input.InputFormat;
import org.apache.druid.data.input.InputRow;
import org.apache.druid.data.input.InputRowSchema;
import org.apache.druid.data.input.impl.ByteEntity;
import org.apache.druid.data.input.impl.InputRowParser;
import org.apache.druid.indexing.common.task.FilteringCloseableInputRowIterator;
import org.apache.druid.indexing.common.task.InputRowFilter;
import org.apache.druid.indexing.seekablestream.SettableByteEntityReader;
import org.apache.druid.java.util.common.CloseableIterators;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.parsers.CloseableIterator;
import org.apache.druid.java.util.common.parsers.ParseException;
import org.apache.druid.segment.incremental.InputRowFilterResult;
import org.apache.druid.segment.incremental.ParseExceptionHandler;
import org.apache.druid.segment.incremental.RowIngestionMeters;
import org.apache.druid.segment.transform.TransformSpec;

class StreamChunkParser<RecordType extends ByteEntity> {
    @Nullable
    private final InputRowParser<ByteBuffer> parser;
    @Nullable
    private final SettableByteEntityReader<RecordType> byteEntityReader;
    private final InputRowFilter rowFilter;
    private final RowIngestionMeters rowIngestionMeters;
    private final ParseExceptionHandler parseExceptionHandler;

    StreamChunkParser(@Nullable InputRowParser<ByteBuffer> parser, @Nullable InputFormat inputFormat, InputRowSchema inputRowSchema, TransformSpec transformSpec, File indexingTmpDir, InputRowFilter rowFilter, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler) {
        if (parser == null && inputFormat == null) {
            throw new IAE("Either parser or inputFormat should be set", new Object[0]);
        }
        this.parser = parser;
        this.byteEntityReader = inputFormat != null ? new SettableByteEntityReader(inputFormat, inputRowSchema, transformSpec, indexingTmpDir) : null;
        this.rowFilter = rowFilter;
        this.rowIngestionMeters = rowIngestionMeters;
        this.parseExceptionHandler = parseExceptionHandler;
    }

    @VisibleForTesting
    StreamChunkParser(@Nullable InputRowParser<ByteBuffer> parser, @Nullable SettableByteEntityReader<RecordType> byteEntityReader, InputRowFilter rowFilter, RowIngestionMeters rowIngestionMeters, ParseExceptionHandler parseExceptionHandler) {
        if (parser == null && byteEntityReader == null) {
            throw new IAE("Either parser or byteEntityReader should be set", new Object[0]);
        }
        this.parser = parser;
        this.byteEntityReader = byteEntityReader;
        this.rowFilter = rowFilter;
        this.rowIngestionMeters = rowIngestionMeters;
        this.parseExceptionHandler = parseExceptionHandler;
    }

    List<InputRow> parse(@Nullable List<RecordType> streamChunk, boolean isEndOfShard) throws IOException {
        if (streamChunk == null || streamChunk.isEmpty()) {
            if (!isEndOfShard) {
                this.rowIngestionMeters.incrementThrownAway(InputRowFilterResult.NULL_OR_EMPTY_RECORD);
            }
            return Collections.emptyList();
        }
        if (this.byteEntityReader != null) {
            return this.parseWithInputFormat(this.byteEntityReader, streamChunk);
        }
        return this.parseWithParser(this.parser, streamChunk);
    }

    private List<InputRow> parseWithParser(InputRowParser<ByteBuffer> parser, List<? extends ByteEntity> valueBytes) {
        FluentIterable iterable = FluentIterable.from(valueBytes).transform(entity -> entity.getBuffer().duplicate()).transform(this::incrementProcessedBytes).transformAndConcat(arg_0 -> parser.parseBatch(arg_0));
        FilteringCloseableInputRowIterator rowIterator = new FilteringCloseableInputRowIterator((CloseableIterator<InputRow>)CloseableIterators.withEmptyBaggage((Iterator)iterable.iterator()), this.rowFilter, this.rowIngestionMeters, this.parseExceptionHandler);
        return Lists.newArrayList((Iterator)((Object)rowIterator));
    }

    private ByteBuffer incrementProcessedBytes(ByteBuffer recordByteBuffer) {
        this.rowIngestionMeters.incrementProcessedBytes((long)recordByteBuffer.remaining());
        return recordByteBuffer;
    }

    private List<InputRow> parseWithInputFormat(SettableByteEntityReader byteEntityReader, List<? extends ByteEntity> valueBytess) throws IOException {
        ArrayList<InputRow> rows = new ArrayList<InputRow>();
        for (ByteEntity byteEntity : valueBytess) {
            this.rowIngestionMeters.incrementProcessedBytes((long)byteEntity.getBuffer().remaining());
            byteEntityReader.setEntity(byteEntity);
            try (FilteringCloseableInputRowIterator rowIterator = new FilteringCloseableInputRowIterator(byteEntityReader.read(), this.rowFilter, this.rowIngestionMeters, this.parseExceptionHandler);){
                rowIterator.forEachRemaining(rows::add);
            }
            catch (ParseException pe) {
                this.parseExceptionHandler.handle(pe);
            }
        }
        return rows;
    }
}

