/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.indexing.seekablestream.supervisor.autoscaler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.Callable;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.collections4.queue.CircularFifoQueue;
import org.apache.druid.indexing.overlord.supervisor.SupervisorSpec;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.AggregateFunction;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.LagStats;
import org.apache.druid.indexing.overlord.supervisor.autoscaler.SupervisorTaskAutoScaler;
import org.apache.druid.indexing.seekablestream.supervisor.SeekableStreamSupervisor;
import org.apache.druid.indexing.seekablestream.supervisor.autoscaler.LagBasedAutoScalerConfig;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.concurrent.Execs;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceEventBuilder;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;

public class LagBasedAutoScaler
implements SupervisorTaskAutoScaler {
    private static final EmittingLogger log = new EmittingLogger(LagBasedAutoScaler.class);
    private final String dataSource;
    private final CircularFifoQueue<Long> lagMetricsQueue;
    private final ScheduledExecutorService lagComputationExec;
    private final ScheduledExecutorService allocationExec;
    private final SupervisorSpec spec;
    private final SeekableStreamSupervisor supervisor;
    private final LagBasedAutoScalerConfig lagBasedAutoScalerConfig;
    private final ServiceEmitter emitter;
    private final ServiceMetricEvent.Builder metricBuilder;
    private static final ReentrantLock LOCK = new ReentrantLock(true);

    public LagBasedAutoScaler(SeekableStreamSupervisor supervisor, String dataSource, LagBasedAutoScalerConfig autoScalerConfig, SupervisorSpec spec, ServiceEmitter emitter) {
        this.lagBasedAutoScalerConfig = autoScalerConfig;
        String supervisorId = StringUtils.format((String)"Supervisor-%s", (Object[])new Object[]{dataSource});
        this.dataSource = dataSource;
        int slots = (int)(this.lagBasedAutoScalerConfig.getLagCollectionRangeMillis() / this.lagBasedAutoScalerConfig.getLagCollectionIntervalMillis()) + 1;
        this.lagMetricsQueue = new CircularFifoQueue(slots);
        this.allocationExec = Execs.scheduledSingleThreaded((String)(StringUtils.encodeForFormat((String)supervisorId) + "-Allocation-%d"));
        this.lagComputationExec = Execs.scheduledSingleThreaded((String)(StringUtils.encodeForFormat((String)supervisorId) + "-Computation-%d"));
        this.spec = spec;
        this.supervisor = supervisor;
        this.emitter = emitter;
        this.metricBuilder = ServiceMetricEvent.builder().setDimension("dataSource", (Object)dataSource).setDimension("stream", (Object)this.supervisor.getIoConfig().getStream());
    }

    public void start() {
        Callable<Integer> scaleAction = () -> {
            LOCK.lock();
            int desiredTaskCount = -1;
            try {
                desiredTaskCount = this.computeDesiredTaskCount(new ArrayList<Long>((Collection<Long>)this.lagMetricsQueue));
            }
            catch (Exception ex) {
                log.warn((Throwable)ex, "Exception while computing desired task count for [%s]", new Object[]{this.dataSource});
            }
            finally {
                LOCK.unlock();
            }
            return desiredTaskCount;
        };
        Runnable onSuccessfulScale = () -> {
            LOCK.lock();
            try {
                this.lagMetricsQueue.clear();
            }
            catch (Exception ex) {
                log.warn((Throwable)ex, "Exception while clearing lags for [%s]", new Object[]{this.dataSource});
            }
            finally {
                LOCK.unlock();
            }
        };
        this.lagComputationExec.scheduleAtFixedRate(this.computeAndCollectLag(), this.lagBasedAutoScalerConfig.getScaleActionStartDelayMillis(), this.lagBasedAutoScalerConfig.getLagCollectionIntervalMillis(), TimeUnit.MILLISECONDS);
        this.allocationExec.scheduleAtFixedRate(this.supervisor.buildDynamicAllocationTask(scaleAction, onSuccessfulScale, this.emitter), this.lagBasedAutoScalerConfig.getScaleActionStartDelayMillis() + this.lagBasedAutoScalerConfig.getLagCollectionRangeMillis(), this.lagBasedAutoScalerConfig.getScaleActionPeriodMillis(), TimeUnit.MILLISECONDS);
        log.info("LagBasedAutoScaler will collect lag every [%d] millis and will keep up to [%d] data points for the last [%d] millis for dataSource [%s]", new Object[]{this.lagBasedAutoScalerConfig.getLagCollectionIntervalMillis(), this.lagMetricsQueue.maxSize(), this.lagBasedAutoScalerConfig.getLagCollectionRangeMillis(), this.dataSource});
    }

    public void stop() {
        this.allocationExec.shutdownNow();
        this.lagComputationExec.shutdownNow();
    }

    public void reset() {
        if (this.lagMetricsQueue != null) {
            try {
                LOCK.lock();
                this.lagMetricsQueue.clear();
            }
            catch (Exception e) {
                log.warn((Throwable)e, "Error,when clear queue in rest action", new Object[0]);
            }
            finally {
                LOCK.unlock();
            }
        }
    }

    private Runnable computeAndCollectLag() {
        return () -> {
            LOCK.lock();
            try {
                if (!this.spec.isSuspended()) {
                    LagStats lagStats = this.supervisor.computeLagStats();
                    if (lagStats != null) {
                        AggregateFunction aggregate = this.lagBasedAutoScalerConfig.getLagAggregate() == null ? lagStats.getAggregateForScaling() : this.lagBasedAutoScalerConfig.getLagAggregate();
                        long lag = lagStats.getMetric(aggregate);
                        this.lagMetricsQueue.offer((Object)(lag > 0L ? lag : 0L));
                    } else {
                        this.lagMetricsQueue.offer((Object)0L);
                    }
                    log.debug("Current lags for dataSource[%s] are [%s].", new Object[]{this.dataSource, this.lagMetricsQueue});
                } else {
                    log.debug("Supervisor[%s] is suspended, skipping lag collection", new Object[]{this.dataSource});
                }
            }
            catch (Exception e) {
                log.error((Throwable)e, "Error while collecting lags", new Object[0]);
            }
            finally {
                LOCK.unlock();
            }
        };
    }

    private int computeDesiredTaskCount(List<Long> lags) {
        log.debug("Computing the desired task count for [%s], based on following lags : [%s]", new Object[]{this.dataSource, lags});
        int beyond = 0;
        int within = 0;
        int metricsCount = lags.size();
        for (Long lag : lags) {
            if (lag >= this.lagBasedAutoScalerConfig.getScaleOutThreshold()) {
                ++beyond;
            }
            if (lag > this.lagBasedAutoScalerConfig.getScaleInThreshold()) continue;
            ++within;
        }
        double beyondProportion = (double)beyond * 1.0 / (double)metricsCount;
        double withinProportion = (double)within * 1.0 / (double)metricsCount;
        log.debug("Calculated beyondProportion is [%s] and withinProportion is [%s] for dataSource [%s].", new Object[]{beyondProportion, withinProportion, this.dataSource});
        int currentActiveTaskCount = this.supervisor.getActiveTaskGroupsCount();
        int partitionCount = this.supervisor.getPartitionCount();
        if (partitionCount <= 0) {
            log.warn("Partition number for [%s] <= 0 ? how can it be?", new Object[]{this.dataSource});
            return -1;
        }
        if (beyondProportion >= this.lagBasedAutoScalerConfig.getTriggerScaleOutFractionThreshold()) {
            int taskCount = currentActiveTaskCount + this.lagBasedAutoScalerConfig.getScaleOutStep();
            int actualTaskCountMax = Math.min(this.lagBasedAutoScalerConfig.getTaskCountMax(), partitionCount);
            if (currentActiveTaskCount == actualTaskCountMax) {
                log.debug("CurrentActiveTaskCount reached task count Max limit, skipping scale out action for dataSource [%s].", new Object[]{this.dataSource});
                this.emitter.emit((ServiceEventBuilder)this.metricBuilder.setDimension("scalingSkipReason", (Object)"Already at max task count").setMetric("task/autoScaler/requiredCount", (Number)taskCount));
                return -1;
            }
            int desiredActiveTaskCount = Math.min(taskCount, actualTaskCountMax);
            return desiredActiveTaskCount;
        }
        if (withinProportion >= this.lagBasedAutoScalerConfig.getTriggerScaleInFractionThreshold()) {
            int taskCount = currentActiveTaskCount - this.lagBasedAutoScalerConfig.getScaleInStep();
            int actualTaskCountMin = Math.min(this.lagBasedAutoScalerConfig.getTaskCountMin(), partitionCount);
            if (currentActiveTaskCount == actualTaskCountMin) {
                log.debug("CurrentActiveTaskCount reached task count Min limit, skipping scale in action for dataSource[%s].", new Object[]{this.dataSource});
                this.emitter.emit((ServiceEventBuilder)this.metricBuilder.setDimension("scalingSkipReason", (Object)"Already at min task count").setMetric("task/autoScaler/requiredCount", (Number)taskCount));
                return -1;
            }
            int desiredActiveTaskCount = Math.max(taskCount, actualTaskCountMin);
            return desiredActiveTaskCount;
        }
        return -1;
    }

    public LagBasedAutoScalerConfig getAutoScalerConfig() {
        return this.lagBasedAutoScalerConfig;
    }
}

