/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.exec;

import com.google.inject.Injector;
import com.google.inject.Key;
import java.util.UUID;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.annotation.Nullable;
import org.apache.druid.java.util.common.ISE;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.msq.guice.MultiStageQuery;
import org.apache.druid.msq.indexing.error.CanceledFault;
import org.apache.druid.msq.indexing.error.DurableStorageConfigurationFault;
import org.apache.druid.msq.indexing.error.InsertTimeNullFault;
import org.apache.druid.msq.indexing.error.MSQErrorReport;
import org.apache.druid.msq.indexing.error.MSQException;
import org.apache.druid.msq.indexing.error.MSQFaultUtils;
import org.apache.druid.msq.indexing.error.QueryRuntimeFault;
import org.apache.druid.msq.indexing.error.TooManyAttemptsForJob;
import org.apache.druid.msq.indexing.error.TooManyAttemptsForWorker;
import org.apache.druid.msq.indexing.error.UnknownFault;
import org.apache.druid.msq.indexing.error.WorkerFailedFault;
import org.apache.druid.msq.indexing.error.WorkerRpcFailedFault;
import org.apache.druid.server.DruidNode;
import org.apache.druid.storage.NilStorageConnector;
import org.apache.druid.storage.StorageConnector;

public class MSQTasks {
    static final String GENERIC_QUERY_FAILED_MESSAGE = "Query failed";
    private static final String TASK_ID_PREFIX = "query-";
    private static final String WORKER_NUMBER = "workerNumber";
    private static final Pattern WORKER_PATTERN = Pattern.compile(".*-worker(?<workerNumber>[0-9]+)_[0-9]+");

    public static String controllerTaskId(@Nullable String queryId) {
        return TASK_ID_PREFIX + (queryId == null ? UUID.randomUUID().toString() : queryId);
    }

    public static String workerTaskId(String controllerTaskId, int workerNumber, int retryCount) {
        return StringUtils.format((String)"%s-worker%d_%d", (Object[])new Object[]{controllerTaskId, workerNumber, retryCount});
    }

    public static int workerFromTaskId(String taskId) {
        Matcher matcher = WORKER_PATTERN.matcher(taskId);
        if (matcher.matches()) {
            try {
                String worker = matcher.group(WORKER_NUMBER);
                return Integer.parseInt(worker);
            }
            catch (NumberFormatException e) {
                throw new ISE((Throwable)e, "Unable to parse worker out of task %s", new Object[]{taskId});
            }
        }
        throw new ISE("Desired pattern %s to extract worker from task id %s did not match ", new Object[]{WORKER_PATTERN.pattern(), taskId});
    }

    public static long primaryTimestampFromObjectForInsert(Object timestamp) {
        if (timestamp instanceof Long) {
            return (Long)timestamp;
        }
        if (timestamp == null) {
            throw new MSQException(InsertTimeNullFault.INSTANCE);
        }
        UnknownFault fault = UnknownFault.forMessage(StringUtils.format((String)"Incorrect type for column [%s]. Expected LONG but got type [%s]. Please ensure that the value is cast to LONG.", (Object[])new Object[]{"__time", timestamp.getClass().getSimpleName()}));
        throw new MSQException(fault);
    }

    @Nullable
    static String getHostFromSelfNode(@Nullable DruidNode selfNode) {
        return selfNode != null ? selfNode.getHostAndPortToUse() : null;
    }

    static StorageConnector makeStorageConnector(Injector injector) {
        try {
            StorageConnector storageConnector = (StorageConnector)injector.getInstance(Key.get(StorageConnector.class, MultiStageQuery.class));
            if (storageConnector instanceof NilStorageConnector) {
                throw new Exception("Storage connector not configured.");
            }
            return storageConnector;
        }
        catch (Exception e) {
            throw new MSQException(new DurableStorageConfigurationFault(e.toString()));
        }
    }

    static MSQErrorReport makeErrorReport(String controllerTaskId, String controllerHost, @Nullable MSQErrorReport controllerErrorReport, @Nullable MSQErrorReport workerErrorReport) {
        if (controllerErrorReport == null && workerErrorReport == null) {
            return MSQErrorReport.fromFault(controllerTaskId, controllerHost, null, UnknownFault.forMessage(GENERIC_QUERY_FAILED_MESSAGE));
        }
        if (controllerErrorReport == null) {
            return workerErrorReport;
        }
        if (workerErrorReport != null && (controllerErrorReport.getFault() instanceof WorkerFailedFault || controllerErrorReport.getFault() instanceof WorkerRpcFailedFault || controllerErrorReport.getFault() instanceof CanceledFault || controllerErrorReport.getFault() instanceof TooManyAttemptsForWorker || controllerErrorReport.getFault() instanceof TooManyAttemptsForJob)) {
            return workerErrorReport;
        }
        return controllerErrorReport;
    }

    static String errorReportToLogMessage(MSQErrorReport errorReport) {
        StringBuilder logMessage = new StringBuilder("Work failed");
        if (errorReport.getStageNumber() != null) {
            logMessage.append("; stage ").append(errorReport.getStageNumber());
        }
        logMessage.append("; task ").append(errorReport.getTaskId());
        if (errorReport.getHost() != null) {
            logMessage.append("; host ").append(errorReport.getHost());
        }
        logMessage.append(": ").append(MSQFaultUtils.generateMessageWithErrorCode(errorReport.getFault()));
        if (errorReport.getExceptionStackTrace() != null) {
            if (errorReport.getFault() instanceof UnknownFault || errorReport.getFault() instanceof QueryRuntimeFault) {
                logMessage.append('\n').append(errorReport.getExceptionStackTrace());
            } else {
                String stackTrace = errorReport.getExceptionStackTrace();
                int firstNewLine = stackTrace.indexOf(10);
                logMessage.append(" (").append(firstNewLine > 0 ? stackTrace.substring(0, firstNewLine) : stackTrace).append(")");
            }
        }
        return logMessage.toString();
    }
}

