/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.msq.indexing.error;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonTypeName;
import java.util.Objects;
import org.apache.druid.msq.indexing.error.BaseMSQFault;

@JsonTypeName(value="TooManyPartitions")
public class TooManyPartitionsFault
extends BaseMSQFault {
    static final String CODE = "TooManyPartitions";
    private final int maxPartitions;

    @JsonCreator
    public TooManyPartitionsFault(@JsonProperty(value="maxPartitions") int maxPartitions) {
        super(CODE, "Too many partitions (max = %d). Try increasing the limit using the %s query context parameter, breaking your query up into smaller queries, or using a larger target size.", maxPartitions, "maxPartitions");
        this.maxPartitions = maxPartitions;
    }

    @JsonProperty
    public int getMaxPartitions() {
        return this.maxPartitions;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        TooManyPartitionsFault that = (TooManyPartitionsFault)o;
        return this.maxPartitions == that.maxPartitions;
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.maxPartitions);
    }
}

