/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server;

import com.fasterxml.jackson.databind.ObjectMapper;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.Lists;
import com.google.common.util.concurrent.Futures;
import com.google.common.util.concurrent.ListenableFuture;
import com.google.inject.Inject;
import java.io.Closeable;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicLong;
import javax.annotation.Nullable;
import org.apache.druid.client.CachingQueryRunner;
import org.apache.druid.client.cache.Cache;
import org.apache.druid.client.cache.CacheConfig;
import org.apache.druid.client.cache.CachePopulator;
import org.apache.druid.error.DruidException;
import org.apache.druid.guice.annotations.Smile;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.java.util.common.guava.FunctionalIterable;
import org.apache.druid.java.util.common.guava.Sequence;
import org.apache.druid.java.util.common.guava.Sequences;
import org.apache.druid.java.util.common.io.Closer;
import org.apache.druid.java.util.emitter.EmittingLogger;
import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.query.BySegmentQueryRunner;
import org.apache.druid.query.CPUTimeMetricQueryRunner;
import org.apache.druid.query.DataSegmentAndDescriptor;
import org.apache.druid.query.DataSource;
import org.apache.druid.query.FinalizeResultsQueryRunner;
import org.apache.druid.query.LeafSegmentsBundle;
import org.apache.druid.query.MetricsEmittingQueryRunner;
import org.apache.druid.query.NoopQueryRunner;
import org.apache.druid.query.PerSegmentOptimizingQueryRunner;
import org.apache.druid.query.PerSegmentQueryOptimizationContext;
import org.apache.druid.query.Query;
import org.apache.druid.query.QueryDataSource;
import org.apache.druid.query.QueryMetrics;
import org.apache.druid.query.QueryPlus;
import org.apache.druid.query.QueryProcessingPool;
import org.apache.druid.query.QueryRunner;
import org.apache.druid.query.QueryRunnerFactory;
import org.apache.druid.query.QueryRunnerFactoryConglomerate;
import org.apache.druid.query.QuerySegmentWalker;
import org.apache.druid.query.QueryToolChest;
import org.apache.druid.query.QueryUnsupportedException;
import org.apache.druid.query.SegmentDescriptor;
import org.apache.druid.query.context.ResponseContext;
import org.apache.druid.query.metadata.metadata.SegmentMetadataQuery;
import org.apache.druid.query.planning.ExecutionVertex;
import org.apache.druid.query.policy.PolicyEnforcer;
import org.apache.druid.query.spec.SpecificSegmentQueryRunner;
import org.apache.druid.query.spec.SpecificSegmentSpec;
import org.apache.druid.segment.Segment;
import org.apache.druid.segment.SegmentMapFunction;
import org.apache.druid.segment.SegmentReference;
import org.apache.druid.segment.TimeBoundaryInspector;
import org.apache.druid.segment.loading.AcquireSegmentAction;
import org.apache.druid.segment.loading.AcquireSegmentResult;
import org.apache.druid.segment.loading.VirtualPlaceholderSegment;
import org.apache.druid.server.ResourceIdPopulatingQueryRunner;
import org.apache.druid.server.SegmentManager;
import org.apache.druid.server.SetAndVerifyContextQueryRunner;
import org.apache.druid.server.initialization.ServerConfig;
import org.apache.druid.timeline.DataSegment;
import org.apache.druid.timeline.SegmentId;
import org.apache.druid.timeline.VersionedIntervalTimeline;
import org.apache.druid.timeline.partition.PartitionChunk;
import org.apache.druid.utils.CloseableUtils;
import org.apache.druid.utils.JvmUtils;
import org.joda.time.Interval;

public class ServerManager
implements QuerySegmentWalker {
    private static final EmittingLogger log = new EmittingLogger(ServerManager.class);
    private final QueryRunnerFactoryConglomerate conglomerate;
    private final ServiceEmitter emitter;
    private final QueryProcessingPool queryProcessingPool;
    private final CachePopulator cachePopulator;
    private final Cache cache;
    private final ObjectMapper objectMapper;
    private final CacheConfig cacheConfig;
    protected final SegmentManager segmentManager;
    private final ServerConfig serverConfig;
    private final PolicyEnforcer policyEnforcer;

    @Inject
    public ServerManager(QueryRunnerFactoryConglomerate conglomerate, ServiceEmitter emitter, QueryProcessingPool queryProcessingPool, CachePopulator cachePopulator, @Smile ObjectMapper objectMapper, Cache cache, CacheConfig cacheConfig, SegmentManager segmentManager, ServerConfig serverConfig, PolicyEnforcer policyEnforcer) {
        this.conglomerate = conglomerate;
        this.emitter = emitter;
        this.queryProcessingPool = queryProcessingPool;
        this.cachePopulator = cachePopulator;
        this.cache = cache;
        this.objectMapper = objectMapper;
        this.cacheConfig = cacheConfig;
        this.segmentManager = segmentManager;
        this.serverConfig = serverConfig;
        this.policyEnforcer = policyEnforcer;
    }

    public <T> QueryRunner<T> getQueryRunnerForIntervals(Query<T> query, Iterable<Interval> intervals) {
        Optional<VersionedIntervalTimeline<String, DataSegment>> maybeTimeline = this.segmentManager.getTimeline(ExecutionVertex.of(query).getBaseTableDataSource());
        if (!maybeTimeline.isPresent()) {
            return new NoopQueryRunner();
        }
        VersionedIntervalTimeline<String, DataSegment> timeline = maybeTimeline.get();
        FunctionalIterable segmentDescriptors = FunctionalIterable.create(intervals).transformCat(arg_0 -> timeline.lookup(arg_0)).transformCat(holder -> {
            if (holder == null) {
                return null;
            }
            return FunctionalIterable.create((Iterable)holder.getObject()).transform(partitionChunk -> new SegmentDescriptor(holder.getInterval(), (String)holder.getVersion(), partitionChunk.getChunkNumber()));
        });
        return this.getQueryRunnerForSegments(query, (Iterable<SegmentDescriptor>)segmentDescriptors);
    }

    public <T> QueryRunner<T> getQueryRunnerForSegments(Query<T> query, Iterable<SegmentDescriptor> specs) {
        ExecutionVertex ev = ExecutionVertex.of(query);
        Optional<VersionedIntervalTimeline<String, DataSegment>> maybeTimeline = this.segmentManager.getTimeline(ev.getBaseTableDataSource());
        if (maybeTimeline.isEmpty()) {
            return (queryPlus, responseContext) -> {
                responseContext.addMissingSegments((List)Lists.newArrayList((Iterable)specs));
                return Sequences.empty();
            };
        }
        QueryRunnerFactory<T, Query<T>> factory = this.getQueryRunnerFactory(query);
        QueryToolChest<T, Query<T>> toolChest = ServerManager.getQueryToolChest(query, factory);
        VersionedIntervalTimeline<String, DataSegment> timeline = maybeTimeline.get();
        return new ResourceManagingQueryRunner<T>(timeline, factory, toolChest, ev, specs);
    }

    protected LeafSegmentsBundle getSegmentsBundle(VersionedIntervalTimeline<String, DataSegment> timeline, Iterable<SegmentDescriptor> segments, SegmentMapFunction segmentMapFunction) {
        ArrayList<DataSegmentAndDescriptor> segmentsToMap = new ArrayList<DataSegmentAndDescriptor>();
        for (SegmentDescriptor descriptor : segments) {
            PartitionChunk chunk = timeline.findChunk(descriptor.getInterval(), (Object)descriptor.getVersion(), descriptor.getPartitionNumber());
            if (chunk != null) {
                segmentsToMap.add(new DataSegmentAndDescriptor((DataSegment)chunk.getObject(), descriptor));
                continue;
            }
            segmentsToMap.add(DataSegmentAndDescriptor.missing((SegmentDescriptor)descriptor));
        }
        return this.segmentManager.getSegmentsBundle(segmentsToMap, segmentMapFunction);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected ArrayList<SegmentReference> getOrLoadBundleSegments(QueryPlus<?> queryPlus, LeafSegmentsBundle segmentsBundle, SegmentMapFunction segmentMapFunction) {
        ArrayList<SegmentReference> segmentReferences = new ArrayList<SegmentReference>(segmentsBundle.getCachedSegments().size() + segmentsBundle.getLoadableSegments().size());
        segmentReferences.addAll(segmentsBundle.getCachedSegments());
        if (queryPlus.getQuery() instanceof SegmentMetadataQuery) {
            for (DataSegmentAndDescriptor segment : segmentsBundle.getLoadableSegments()) {
                segmentReferences.add(new SegmentReference(segment.getDescriptor(), Optional.of(new VirtualPlaceholderSegment(segment.getDataSegment())), null));
            }
            return segmentReferences;
        } else {
            try {
                LoadSegmentsResult result = this.getOrLoadSegmentReferences(segmentsBundle.getLoadableSegments(), segmentMapFunction, queryPlus.getQuery().context().getTimeout());
                segmentReferences.addAll(result.getSegmentReferences());
                if (!this.segmentManager.canLoadSegmentsOnDemand()) return segmentReferences;
                result.reportMetrics(queryPlus.getQueryMetrics());
                return segmentReferences;
            }
            catch (Throwable t) {
                throw CloseableUtils.closeAndWrapInCatch((Throwable)t, () -> ((LeafSegmentsBundle)segmentsBundle).closeCachedReferences());
            }
        }
    }

    protected LoadSegmentsResult getOrLoadSegmentReferences(List<DataSegmentAndDescriptor> segmentsToMap, SegmentMapFunction segmentMapFunction, long timeout) {
        long startLoadTime = System.nanoTime();
        Closer safetyNet = Closer.create();
        ArrayList<AcquireSegmentAction> actions = new ArrayList<AcquireSegmentAction>();
        try {
            for (DataSegmentAndDescriptor segment : segmentsToMap) {
                if (segment.getDataSegment() == null) {
                    actions.add((AcquireSegmentAction)safetyNet.register((Closeable)AcquireSegmentAction.missingSegment()));
                    continue;
                }
                actions.add((AcquireSegmentAction)safetyNet.register((Closeable)this.segmentManager.acquireSegment(segment.getDataSegment())));
            }
        }
        catch (Throwable t) {
            throw CloseableUtils.closeInCatch((Throwable)(t instanceof DruidException ? (DruidException)t : DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build(t, t.getMessage(), new Object[0])), (Closeable)safetyNet);
        }
        long timeoutAt = System.currentTimeMillis() + timeout;
        Throwable failure = null;
        ArrayList<ListenableFuture> futures = new ArrayList<ListenableFuture>(actions.size());
        for (AcquireSegmentAction acquireSegmentAction : actions) {
            if (failure == null) {
                try {
                    futures.add(acquireSegmentAction.getSegmentFuture());
                }
                catch (Throwable t) {
                    failure = t;
                }
                continue;
            }
            futures.add(Futures.immediateFuture((Object)AcquireSegmentResult.empty()));
        }
        if (failure != null) {
            throw CloseableUtils.closeInCatch((Throwable)(failure instanceof DruidException ? (DruidException)failure : DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build(failure, "Failed to acquire segment references to process query", new Object[0])), (Closeable)safetyNet);
        }
        ArrayList<SegmentReference> segmentReferences = new ArrayList<SegmentReference>(actions.size());
        long totalSegmentsLoadTime = 0L;
        long totalSegmentsLoadWaitTime = 0L;
        long maxSegmentLoadTime = 0L;
        long maxSegmentWaitTime = 0L;
        long bytesLoaded = 0L;
        boolean timedOut = false;
        boolean interrupted = false;
        for (int i = 0; i < actions.size(); ++i) {
            try {
                DataSegmentAndDescriptor segmentAndDescriptor = segmentsToMap.get(i);
                AcquireSegmentAction action = (AcquireSegmentAction)actions.get(i);
                ListenableFuture future = (ListenableFuture)futures.get(i);
                AcquireSegmentResult result = (AcquireSegmentResult)future.get(timeoutAt - System.currentTimeMillis(), TimeUnit.MILLISECONDS);
                if (result == null) {
                    segmentReferences.add(new SegmentReference(segmentAndDescriptor.getDescriptor(), Optional.empty(), (Closeable)action));
                    continue;
                }
                totalSegmentsLoadTime += result.getLoadTimeNanos();
                totalSegmentsLoadWaitTime += result.getWaitTimeNanos();
                maxSegmentLoadTime = Math.max(maxSegmentLoadTime, result.getLoadTimeNanos());
                maxSegmentWaitTime = Math.max(maxSegmentWaitTime, result.getWaitTimeNanos());
                bytesLoaded += result.getLoadSizeBytes();
                Optional segment = result.getReferenceProvider().acquireReference();
                try {
                    Optional<Segment> mappedSegment = ((Optional)segmentMapFunction.apply((Object)segment)).map(arg_0 -> ((Closer)safetyNet).register(arg_0));
                    segmentReferences.add(new SegmentReference(segmentAndDescriptor.getDescriptor(), mappedSegment, (Closeable)action));
                    continue;
                }
                catch (Throwable t) {
                    segment.ifPresent(arg_0 -> ((Closer)safetyNet).register(arg_0));
                    throw t;
                }
            }
            catch (Throwable t) {
                if (t instanceof InterruptedException) {
                    interrupted = true;
                }
                if (t instanceof TimeoutException) {
                    timedOut = true;
                }
                if (failure == null) {
                    failure = t;
                    continue;
                }
                if (failure.getSuppressed().length > 10) continue;
                failure.addSuppressed(t);
            }
        }
        if (failure != null) {
            DruidException toThrow;
            if (failure instanceof DruidException) {
                toThrow = (DruidException)failure;
            } else if (timedOut) {
                toThrow = DruidException.forPersona((DruidException.Persona)DruidException.Persona.USER).ofCategory(DruidException.Category.TIMEOUT).build(failure, "Failed to acquire segment references to process query", new Object[0]);
            } else if (interrupted) {
                Thread.currentThread().interrupt();
                toThrow = DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build(failure, "Interrupted waiting for segments", new Object[0]);
            } else {
                toThrow = DruidException.forPersona((DruidException.Persona)DruidException.Persona.OPERATOR).ofCategory(DruidException.Category.RUNTIME_FAILURE).build(failure, "Failed to acquire segment references to process query", new Object[0]);
            }
            throw CloseableUtils.closeInCatch((Throwable)toThrow, (Closeable)safetyNet);
        }
        long loadTime = System.nanoTime() - startLoadTime;
        long count = actions.size();
        return new LoadSegmentsResult(segmentReferences, loadTime, maxSegmentLoadTime, count == 0L ? 0L : totalSegmentsLoadTime / count, maxSegmentWaitTime, count == 0L ? 0L : totalSegmentsLoadWaitTime / count, bytesLoaded, count);
    }

    protected <T> FunctionalIterable<QueryRunner<T>> getQueryRunnersForSegments(Query<T> query, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, List<SegmentReference> segmentReferences, AtomicLong cpuTimeAccumulator, Optional<byte[]> cacheKeyPrefix) {
        return FunctionalIterable.create(segmentReferences).transform(ref -> ref.getSegmentReference().map(segment -> this.buildQueryRunnerForSegment(ref.getSegmentDescriptor(), (Segment)segment, factory, toolChest, cpuTimeAccumulator, cacheKeyPrefix)).orElseThrow(() -> DruidException.defensive((String)"Unexpected missing segment[%s]", (Object[])new Object[]{ref.getSegmentDescriptor()})));
    }

    protected <T> QueryRunner<T> buildQueryRunnerForSegment(SegmentDescriptor segmentDescriptor, Segment segment, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, AtomicLong cpuTimeAccumulator, Optional<byte[]> cacheKeyPrefix) {
        if (segment.isTombstone()) {
            return new NoopQueryRunner();
        }
        SegmentId segmentId = segment.getId();
        Interval segmentInterval = segment.getDataInterval();
        String segmentIdString = segmentId.toString();
        SpecificSegmentSpec segmentSpec = new SpecificSegmentSpec(segmentDescriptor);
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerInner = new MetricsEmittingQueryRunner(this.emitter, toolChest, factory.createRunner(segment), QueryMetrics::reportSegmentTime, queryMetrics -> queryMetrics.segment(segmentIdString));
        TimeBoundaryInspector timeBoundaryInspector = (TimeBoundaryInspector)segment.as(TimeBoundaryInspector.class);
        Interval cacheKeyInterval = timeBoundaryInspector != null ? timeBoundaryInspector.getMinMaxInterval() : segmentInterval;
        CachingQueryRunner cachingQueryRunner = new CachingQueryRunner(segmentIdString, cacheKeyPrefix, segmentDescriptor, cacheKeyInterval, this.objectMapper, this.cache, (QueryToolChest)toolChest, metricsEmittingQueryRunnerInner, this.cachePopulator, this.cacheConfig);
        BySegmentQueryRunner bySegmentQueryRunner = new BySegmentQueryRunner(segmentId, segmentInterval.getStart(), cachingQueryRunner);
        MetricsEmittingQueryRunner metricsEmittingQueryRunnerOuter = new MetricsEmittingQueryRunner(this.emitter, toolChest, (QueryRunner)bySegmentQueryRunner, QueryMetrics::reportSegmentAndCacheTime, queryMetrics -> queryMetrics.segment(segmentIdString)).withWaitMeasuredFromNow();
        SpecificSegmentQueryRunner specificSegmentQueryRunner = new SpecificSegmentQueryRunner((QueryRunner)metricsEmittingQueryRunnerOuter, segmentSpec);
        PerSegmentOptimizingQueryRunner perSegmentOptimizingQueryRunner = new PerSegmentOptimizingQueryRunner((QueryRunner)specificSegmentQueryRunner, new PerSegmentQueryOptimizationContext(segmentDescriptor));
        return new SetAndVerifyContextQueryRunner(this.serverConfig, CPUTimeMetricQueryRunner.safeBuild((QueryRunner)perSegmentOptimizingQueryRunner, toolChest, (ServiceEmitter)this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)false));
    }

    protected <T> QueryRunnerFactory<T, Query<T>> getQueryRunnerFactory(Query<T> query) {
        DataSource dataSourceFromQuery = query.getDataSource();
        QueryRunnerFactory factory = this.conglomerate.findFactory(query);
        if (factory == null) {
            QueryUnsupportedException e = new QueryUnsupportedException(StringUtils.format((String)"Unknown query type, [%s]", (Object[])new Object[]{query.getClass()}));
            log.makeAlert((Throwable)e, "Error while executing a query[%s]", new Object[]{query.getId()}).addData("dataSource", (Object)dataSourceFromQuery).emit();
            throw e;
        }
        return factory;
    }

    protected static <T> QueryToolChest<T, Query<T>> getQueryToolChest(Query<T> query, QueryRunnerFactory<T, Query<T>> factory) {
        DataSource dataSourceFromQuery = query.getDataSource();
        QueryToolChest toolChest = factory.getToolchest();
        if (dataSourceFromQuery instanceof QueryDataSource && !toolChest.canPerformSubquery(((QueryDataSource)dataSourceFromQuery).getQuery())) {
            throw new QueryUnsupportedException(StringUtils.format((String)"Cannot handle subquery: %s", (Object[])new Object[]{dataSourceFromQuery}));
        }
        return toolChest;
    }

    public class ResourceManagingQueryRunner<T>
    implements QueryRunner<T> {
        private final VersionedIntervalTimeline<String, DataSegment> timeline;
        private final QueryRunnerFactory<T, Query<T>> factory;
        private final QueryToolChest<T, Query<T>> toolChest;
        private final ExecutionVertex ev;
        private final Iterable<SegmentDescriptor> specs;

        public ResourceManagingQueryRunner(VersionedIntervalTimeline<String, DataSegment> timeline, QueryRunnerFactory<T, Query<T>> factory, QueryToolChest<T, Query<T>> toolChest, ExecutionVertex ev, Iterable<SegmentDescriptor> specs) {
            this.timeline = timeline;
            this.factory = factory;
            this.toolChest = toolChest;
            this.ev = ev;
            this.specs = specs;
        }

        public Sequence<T> run(QueryPlus<T> queryPlus, ResponseContext responseContext) {
            queryPlus = queryPlus.withQuery(ResourceIdPopulatingQueryRunner.populateResourceId(queryPlus.getQuery())).withQueryMetrics(this.toolChest);
            Query query = queryPlus.getQuery();
            AtomicLong cpuTimeAccumulator = new AtomicLong(0L);
            SegmentMapFunction segmentMapFn = (SegmentMapFunction)JvmUtils.safeAccumulateThreadCpuTime((AtomicLong)cpuTimeAccumulator, () -> this.ev.createSegmentMapFunction(ServerManager.this.policyEnforcer));
            Optional<byte[]> cacheKeyPrefix = Optional.ofNullable(query.getDataSource().getCacheKey());
            Closer closer = Closer.create();
            try {
                LeafSegmentsBundle segmentsBundle = this.getLeafSegmentsBundle(query, segmentMapFn);
                responseContext.addMissingSegments((List)segmentsBundle.getMissingSegments());
                ArrayList<SegmentReference> segmentReferences = ServerManager.this.getOrLoadBundleSegments(queryPlus, segmentsBundle, segmentMapFn);
                closer.registerAll(segmentReferences);
                FunctionalIterable<QueryRunner<T>> queryRunners = ServerManager.this.getQueryRunnersForSegments(query, this.factory, this.toolChest, segmentReferences, cpuTimeAccumulator, cacheKeyPrefix);
                QueryRunner queryRunner = CPUTimeMetricQueryRunner.safeBuild((QueryRunner)new FinalizeResultsQueryRunner(this.toolChest.mergeResults(this.factory.mergeRunners(ServerManager.this.queryProcessingPool, queryRunners), true), this.toolChest), this.toolChest, (ServiceEmitter)ServerManager.this.emitter, (AtomicLong)cpuTimeAccumulator, (boolean)true);
                return queryRunner.run(queryPlus, responseContext).withBaggage((Closeable)closer);
            }
            catch (Throwable t) {
                throw CloseableUtils.closeAndWrapInCatch((Throwable)t, (Closeable)closer);
            }
        }

        @VisibleForTesting
        protected LeafSegmentsBundle getLeafSegmentsBundle(Query<T> query, SegmentMapFunction segmentMapFunction) {
            return ServerManager.this.getSegmentsBundle(this.timeline, this.specs, segmentMapFunction);
        }
    }

    public static class LoadSegmentsResult {
        private final ArrayList<SegmentReference> segmentReferences;
        private final long wallTimeNanos;
        private final long maxTimeNanos;
        private final long avgTimeNanos;
        private final long maxWaitNanos;
        private final long avgWaitNanos;
        private final long totalBytes;
        private final long count;

        public LoadSegmentsResult(ArrayList<SegmentReference> segmentReferences, long wallTimeNanos, long maxTimeNanos, long avgTimeNanos, long maxWaitNanos, long avgWaitNanos, long totalBytes, long count) {
            this.segmentReferences = segmentReferences;
            this.wallTimeNanos = wallTimeNanos;
            this.maxTimeNanos = maxTimeNanos;
            this.avgTimeNanos = avgTimeNanos;
            this.maxWaitNanos = maxWaitNanos;
            this.avgWaitNanos = avgWaitNanos;
            this.totalBytes = totalBytes;
            this.count = count;
        }

        public List<SegmentReference> getSegmentReferences() {
            return this.segmentReferences;
        }

        public void reportMetrics(@Nullable QueryMetrics<?> queryMetrics) {
            if (queryMetrics != null) {
                queryMetrics.reportSegmentOnDemandLoadTime(this.wallTimeNanos);
                queryMetrics.reportSegmentOnDemandLoadTimeMax(this.maxTimeNanos);
                queryMetrics.reportSegmentOnDemandLoadTimeAvg(this.avgTimeNanos);
                queryMetrics.reportSegmentOnDemandLoadWaitTimeMax(this.maxWaitNanos);
                queryMetrics.reportSegmentOnDemandLoadWaitTimeAvg(this.avgWaitNanos);
                queryMetrics.reportSegmentOnDemandLoadBytes(this.totalBytes);
                queryMetrics.reportSegmentOnDemandLoadCount(this.count);
            }
        }
    }
}

