/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import java.util.Objects;
import org.apache.druid.java.util.common.StringUtils;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionTaskStatus;
import org.apache.druid.server.compaction.FixedIntervalOrderPolicy;
import org.apache.druid.server.compaction.MostFragmentedIntervalFirstPolicy;
import org.apache.druid.server.compaction.NewestSegmentFirstPolicy;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(name="newestSegmentFirst", value=NewestSegmentFirstPolicy.class), @JsonSubTypes.Type(name="fixedIntervalOrder", value=FixedIntervalOrderPolicy.class), @JsonSubTypes.Type(name="mostFragmentedFirst", value=MostFragmentedIntervalFirstPolicy.class)})
public interface CompactionCandidateSearchPolicy {
    public int compareCandidates(CompactionCandidate var1, CompactionCandidate var2);

    public Eligibility checkEligibilityForCompaction(CompactionCandidate var1, CompactionTaskStatus var2);

    public static class Eligibility {
        public static final Eligibility OK = new Eligibility(true, null);
        private final boolean eligible;
        private final String reason;

        private Eligibility(boolean eligible, String reason) {
            this.eligible = eligible;
            this.reason = reason;
        }

        public boolean isEligible() {
            return this.eligible;
        }

        public String getReason() {
            return this.reason;
        }

        public static Eligibility fail(String messageFormat, Object ... args) {
            return new Eligibility(false, StringUtils.format((String)messageFormat, (Object[])args));
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object == null || this.getClass() != object.getClass()) {
                return false;
            }
            Eligibility that = (Eligibility)object;
            return this.eligible == that.eligible && Objects.equals(this.reason, that.reason);
        }

        public int hashCode() {
            return Objects.hash(this.eligible, this.reason);
        }

        public String toString() {
            return "Eligibility{eligible=" + this.eligible + ", reason='" + this.reason + "'}";
        }
    }
}

