/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.compaction;

public class CompactionStatistics {
    private long totalBytes;
    private long numSegments;
    private long numIntervals;

    public static CompactionStatistics create(long bytes, long numSegments, long numIntervals) {
        CompactionStatistics stats = new CompactionStatistics();
        stats.totalBytes = bytes;
        stats.numIntervals = numIntervals;
        stats.numSegments = numSegments;
        return stats;
    }

    public long getTotalBytes() {
        return this.totalBytes;
    }

    public long getNumSegments() {
        return this.numSegments;
    }

    public long getNumIntervals() {
        return this.numIntervals;
    }

    public void increment(CompactionStatistics other) {
        this.totalBytes += other.getTotalBytes();
        this.numIntervals += other.getNumIntervals();
        this.numSegments += other.getNumSegments();
    }

    public void decrement(CompactionStatistics other) {
        this.totalBytes -= other.getTotalBytes();
        this.numIntervals -= other.getNumIntervals();
        this.numSegments -= other.getNumSegments();
    }

    public String toString() {
        return "CompactionStatistics{totalBytes=" + this.totalBytes + ", numSegments=" + this.numSegments + ", numIntervals=" + this.numIntervals + "}";
    }
}

