/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.server.coordinator.duty;

import com.fasterxml.jackson.annotation.JacksonInject;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.base.Preconditions;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import org.apache.druid.client.DataSourcesSnapshot;
import org.apache.druid.client.indexing.ClientCompactionIOConfig;
import org.apache.druid.client.indexing.ClientCompactionIntervalSpec;
import org.apache.druid.client.indexing.ClientCompactionRunnerInfo;
import org.apache.druid.client.indexing.ClientCompactionTaskDimensionsSpec;
import org.apache.druid.client.indexing.ClientCompactionTaskGranularitySpec;
import org.apache.druid.client.indexing.ClientCompactionTaskQuery;
import org.apache.druid.client.indexing.ClientCompactionTaskQueryTuningConfig;
import org.apache.druid.common.guava.FutureUtils;
import org.apache.druid.common.utils.IdUtils;
import org.apache.druid.data.input.impl.AggregateProjectionSpec;
import org.apache.druid.indexer.CompactionEngine;
import org.apache.druid.java.util.common.granularity.Granularity;
import org.apache.druid.java.util.common.granularity.GranularityType;
import org.apache.druid.java.util.common.logger.Logger;
import org.apache.druid.query.aggregation.AggregatorFactory;
import org.apache.druid.rpc.indexing.OverlordClient;
import org.apache.druid.segment.transform.CompactionTransformSpec;
import org.apache.druid.server.compaction.CompactionCandidate;
import org.apache.druid.server.compaction.CompactionCandidateSearchPolicy;
import org.apache.druid.server.compaction.CompactionSegmentIterator;
import org.apache.druid.server.compaction.CompactionSlotManager;
import org.apache.druid.server.compaction.CompactionSnapshotBuilder;
import org.apache.druid.server.compaction.CompactionStatus;
import org.apache.druid.server.compaction.CompactionStatusTracker;
import org.apache.druid.server.compaction.PriorityBasedCompactionSegmentIterator;
import org.apache.druid.server.coordinator.AutoCompactionSnapshot;
import org.apache.druid.server.coordinator.DataSourceCompactionConfig;
import org.apache.druid.server.coordinator.DruidCompactionConfig;
import org.apache.druid.server.coordinator.DruidCoordinatorRuntimeParams;
import org.apache.druid.server.coordinator.duty.CoordinatorCustomDuty;
import org.apache.druid.server.coordinator.stats.CoordinatorRunStats;
import org.apache.druid.server.coordinator.stats.Dimension;
import org.apache.druid.server.coordinator.stats.RowKey;
import org.apache.druid.server.coordinator.stats.Stats;
import org.apache.druid.timeline.DataSegment;
import org.joda.time.Interval;
import org.joda.time.Period;
import org.joda.time.ReadableInterval;

public class CompactSegments
implements CoordinatorCustomDuty {
    public static final String STORE_COMPACTION_STATE_KEY = "storeCompactionState";
    public static final String COMPACTION_INTERVAL_KEY = "compactionInterval";
    private static final String COMPACTION_REASON_KEY = "compactionReason";
    private static final Logger LOG = new Logger(CompactSegments.class);
    private static final String TASK_ID_PREFIX = "coordinator-issued";
    private final CompactionStatusTracker statusTracker;
    private final OverlordClient overlordClient;
    private final AtomicReference<Map<String, AutoCompactionSnapshot>> autoCompactionSnapshotPerDataSource = new AtomicReference();

    @JsonCreator
    public CompactSegments(@JacksonInject CompactionStatusTracker statusTracker, @JacksonInject OverlordClient overlordClient) {
        this.overlordClient = overlordClient;
        this.statusTracker = statusTracker;
        this.resetCompactionSnapshot();
    }

    @VisibleForTesting
    public OverlordClient getOverlordClient() {
        return this.overlordClient;
    }

    @Override
    public DruidCoordinatorRuntimeParams run(DruidCoordinatorRuntimeParams params) {
        if (this.isCompactionSupervisorEnabled()) {
            LOG.warn("Skipping CompactSegments duty since compaction supervisors are already running on Overlord.", new Object[0]);
        } else {
            this.run(params.getCompactionConfig(), params.getDataSourcesSnapshot(), CompactionEngine.NATIVE, params.getCoordinatorStats());
        }
        return params;
    }

    public void run(DruidCompactionConfig dynamicConfig, DataSourcesSnapshot dataSources, CompactionEngine defaultEngine, CoordinatorRunStats stats) {
        int maxCompactionTaskSlots = dynamicConfig.getMaxCompactionTaskSlots();
        if (maxCompactionTaskSlots <= 0) {
            this.resetCompactionSnapshot();
            return;
        }
        this.statusTracker.onSegmentTimelineUpdated(dataSources.getSnapshotTime());
        List<DataSourceCompactionConfig> compactionConfigList = dynamicConfig.getCompactionConfigs();
        if (compactionConfigList == null || compactionConfigList.isEmpty()) {
            this.resetCompactionSnapshot();
            this.statusTracker.resetActiveDatasources(Set.of());
            return;
        }
        Map<String, DataSourceCompactionConfig> compactionConfigs = compactionConfigList.stream().collect(Collectors.toMap(DataSourceCompactionConfig::getDataSource, Function.identity()));
        this.statusTracker.resetActiveDatasources(compactionConfigs.keySet());
        CompactionSlotManager slotManager = new CompactionSlotManager(this.overlordClient, this.statusTracker, dynamicConfig.clusterConfig());
        stats.add(Stats.Compaction.MAX_SLOTS, slotManager.getNumAvailableTaskSlots());
        for (ClientCompactionTaskQuery compactionTaskQuery : slotManager.fetchRunningCompactionTasks()) {
            String dataSource;
            DataSourceCompactionConfig dataSourceCompactionConfig;
            if (!slotManager.cancelTaskOnlyIfGranularityChanged(compactionTaskQuery, dataSourceCompactionConfig = (DataSourceCompactionConfig)compactionConfigs.get(dataSource = compactionTaskQuery.getDataSource()))) continue;
            stats.add(Stats.Compaction.CANCELLED_TASKS, RowKey.of(Dimension.DATASOURCE, dataSource), 1L);
        }
        stats.add(Stats.Compaction.AVAILABLE_SLOTS, slotManager.getNumAvailableTaskSlots());
        slotManager.skipLockedIntervals(compactionConfigList);
        CompactionCandidateSearchPolicy policy = dynamicConfig.getCompactionPolicy();
        PriorityBasedCompactionSegmentIterator iterator = new PriorityBasedCompactionSegmentIterator(policy, compactionConfigs, dataSources.getUsedSegmentsTimelinesPerDataSource(), slotManager.getDatasourceIntervalsToSkipCompaction());
        CompactionSnapshotBuilder compactionSnapshotBuilder = new CompactionSnapshotBuilder(stats);
        int numSubmittedCompactionTasks = this.submitCompactionTasks(compactionConfigs, compactionSnapshotBuilder, slotManager, iterator, policy, defaultEngine);
        stats.add(Stats.Compaction.SUBMITTED_TASKS, numSubmittedCompactionTasks);
        this.updateCompactionSnapshotStats(compactionSnapshotBuilder, iterator, compactionConfigs);
    }

    private void resetCompactionSnapshot() {
        this.autoCompactionSnapshotPerDataSource.set(Collections.emptyMap());
    }

    private boolean isCompactionSupervisorEnabled() {
        try {
            return (Boolean)FutureUtils.getUnchecked(this.overlordClient.isCompactionSupervisorEnabled(), (boolean)true);
        }
        catch (Exception e) {
            return false;
        }
    }

    private int submitCompactionTasks(Map<String, DataSourceCompactionConfig> compactionConfigs, CompactionSnapshotBuilder snapshotBuilder, CompactionSlotManager slotManager, CompactionSegmentIterator iterator, CompactionCandidateSearchPolicy policy, CompactionEngine defaultEngine) {
        if (slotManager.getNumAvailableTaskSlots() <= 0) {
            return 0;
        }
        int numSubmittedTasks = 0;
        int totalTaskSlotsAssigned = 0;
        while (iterator.hasNext() && totalTaskSlotsAssigned < slotManager.getNumAvailableTaskSlots()) {
            CompactionCandidate entry = (CompactionCandidate)iterator.next();
            String dataSourceName = entry.getDataSource();
            DataSourceCompactionConfig config = compactionConfigs.get(dataSourceName);
            CompactionStatus compactionStatus = this.statusTracker.computeCompactionStatus(entry, policy);
            CompactionCandidate candidatesWithStatus = entry.withCurrentStatus(compactionStatus);
            this.statusTracker.onCompactionStatusComputed(candidatesWithStatus, config);
            if (compactionStatus.isComplete()) {
                snapshotBuilder.addToComplete(candidatesWithStatus);
                continue;
            }
            if (compactionStatus.isSkipped()) {
                snapshotBuilder.addToSkipped(candidatesWithStatus);
                continue;
            }
            snapshotBuilder.addToComplete(entry);
            ClientCompactionTaskQuery taskPayload = CompactSegments.createCompactionTask(entry, config, defaultEngine);
            String taskId = taskPayload.getId();
            FutureUtils.getUnchecked(this.overlordClient.runTask(taskId, taskPayload), (boolean)true);
            this.statusTracker.onTaskSubmitted(taskId, entry);
            LOG.debug("Submitted a compaction task[%s] for [%d] segments in datasource[%s], umbrella interval[%s].", new Object[]{taskId, entry.numSegments(), dataSourceName, entry.getUmbrellaInterval()});
            LOG.debugSegments(entry.getSegments(), "Compacting segments");
            ++numSubmittedTasks;
            totalTaskSlotsAssigned += slotManager.computeSlotsRequiredForTask(taskPayload, config);
        }
        LOG.info("Submitted a total of [%d] compaction tasks.", new Object[]{numSubmittedTasks});
        return numSubmittedTasks;
    }

    public static ClientCompactionTaskQuery createCompactionTask(CompactionCandidate candidate, DataSourceCompactionConfig config, CompactionEngine defaultEngine) {
        List<DataSegment> segmentsToCompact = candidate.getSegments();
        Granularity segmentGranularityToUse = null;
        if (config.getGranularitySpec() == null || config.getGranularitySpec().getSegmentGranularity() == null) {
            Interval interval = segmentsToCompact.get(0).getInterval();
            if (segmentsToCompact.stream().allMatch(segment -> interval.overlaps((ReadableInterval)segment.getInterval()))) {
                try {
                    segmentGranularityToUse = GranularityType.fromPeriod((Period)interval.toPeriod()).getDefaultGranularity();
                }
                catch (IllegalArgumentException iae) {
                    LOG.warn("Cannot determine segmentGranularity from interval[%s].", new Object[]{interval});
                }
            } else {
                LOG.warn("Not setting 'segmentGranularity' for auto-compaction task as the segments to compact do not have the same interval.", new Object[0]);
            }
        } else {
            segmentGranularityToUse = config.getGranularitySpec().getSegmentGranularity();
        }
        ClientCompactionTaskGranularitySpec granularitySpec = new ClientCompactionTaskGranularitySpec(segmentGranularityToUse, config.getGranularitySpec() != null ? config.getGranularitySpec().getQueryGranularity() : null, config.getGranularitySpec() != null ? config.getGranularitySpec().isRollup() : null);
        ClientCompactionTaskDimensionsSpec dimensionsSpec = config.getDimensionsSpec() != null ? new ClientCompactionTaskDimensionsSpec(config.getDimensionsSpec().getDimensions()) : null;
        Boolean dropExisting = null;
        if (config.getIoConfig() != null) {
            dropExisting = config.getIoConfig().isDropExisting();
        }
        if ((dropExisting == null || !dropExisting.booleanValue()) && segmentsToCompact.stream().allMatch(DataSegment::isTombstone)) {
            dropExisting = true;
            LOG.info("Forcing dropExisting to true since all segments to compact are tombstones.", new Object[0]);
        }
        CompactionEngine compactionEngine = config.getEngine() == null ? defaultEngine : config.getEngine();
        Map<String, Object> autoCompactionContext = CompactSegments.newAutoCompactionContext(config.getTaskContext());
        if (candidate.getCurrentStatus() != null) {
            autoCompactionContext.put(COMPACTION_REASON_KEY, candidate.getCurrentStatus().getReason());
        }
        return CompactSegments.compactSegments(candidate, config.getTaskPriority(), ClientCompactionTaskQueryTuningConfig.from(config.getTuningConfig(), config.getMaxRowsPerSegment(), config.getMetricsSpec() != null), granularitySpec, dimensionsSpec, config.getMetricsSpec(), config.getTransformSpec(), config.getProjections(), dropExisting, autoCompactionContext, new ClientCompactionRunnerInfo(compactionEngine));
    }

    private static Map<String, Object> newAutoCompactionContext(@Nullable Map<String, Object> configuredContext) {
        HashMap<String, Object> newContext = configuredContext == null ? new HashMap<String, Object>() : new HashMap<String, Object>(configuredContext);
        newContext.put(STORE_COMPACTION_STATE_KEY, true);
        return newContext;
    }

    private void updateCompactionSnapshotStats(CompactionSnapshotBuilder snapshotBuilder, CompactionSegmentIterator iterator, Map<String, DataSourceCompactionConfig> datasourceToConfig) {
        while (iterator.hasNext()) {
            snapshotBuilder.addToPending((CompactionCandidate)iterator.next());
        }
        iterator.getCompactedSegments().forEach(snapshotBuilder::addToComplete);
        iterator.getSkippedSegments().forEach(entry -> {
            this.statusTracker.onCompactionStatusComputed((CompactionCandidate)entry, (DataSourceCompactionConfig)datasourceToConfig.get(entry.getDataSource()));
            snapshotBuilder.addToSkipped((CompactionCandidate)entry);
        });
        this.autoCompactionSnapshotPerDataSource.set(snapshotBuilder.build());
    }

    @Nullable
    public AutoCompactionSnapshot getAutoCompactionSnapshot(String dataSource) {
        return this.autoCompactionSnapshotPerDataSource.get().get(dataSource);
    }

    public Map<String, AutoCompactionSnapshot> getAutoCompactionSnapshot() {
        return this.autoCompactionSnapshotPerDataSource.get();
    }

    private static ClientCompactionTaskQuery compactSegments(CompactionCandidate entry, int compactionTaskPriority, ClientCompactionTaskQueryTuningConfig tuningConfig, ClientCompactionTaskGranularitySpec granularitySpec, @Nullable ClientCompactionTaskDimensionsSpec dimensionsSpec, @Nullable AggregatorFactory[] metricsSpec, @Nullable CompactionTransformSpec transformSpec, @Nullable List<AggregateProjectionSpec> projectionSpecs, @Nullable Boolean dropExisting, Map<String, Object> context, ClientCompactionRunnerInfo compactionRunner) {
        List<DataSegment> segments = entry.getSegments();
        Preconditions.checkArgument((!segments.isEmpty() ? 1 : 0) != 0, (Object)"Expect non-empty segments to compact");
        String dataSource = segments.get(0).getDataSource();
        Preconditions.checkArgument((boolean)segments.stream().allMatch(segment -> segment.getDataSource().equals(dataSource)), (Object)"Segments must have the same dataSource");
        context.put("priority", compactionTaskPriority);
        String taskId = IdUtils.newTaskId((String)TASK_ID_PREFIX, (String)"compact", (String)dataSource, null);
        return new ClientCompactionTaskQuery(taskId, dataSource, new ClientCompactionIOConfig(new ClientCompactionIntervalSpec(entry.getCompactionInterval(), null), dropExisting), tuningConfig, granularitySpec, dimensionsSpec, metricsSpec, transformSpec, projectionSpecs, context, compactionRunner);
    }
}

