/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.collections.bitmap;

import com.google.common.base.Preconditions;
import org.roaringbitmap.BatchIterator;
import org.roaringbitmap.PeekableIntIterator;

public final class BatchIteratorAdapter
implements BatchIterator {
    private final PeekableIntIterator iterator;

    public BatchIteratorAdapter(PeekableIntIterator iterator) {
        this.iterator = (PeekableIntIterator)Preconditions.checkNotNull((Object)iterator, (Object)"iterator");
    }

    public int nextBatch(int[] buffer) {
        int i;
        for (i = 0; i < buffer.length && this.iterator.hasNext(); ++i) {
            buffer[i] = this.iterator.next();
        }
        return i;
    }

    public boolean hasNext() {
        return this.iterator.hasNext();
    }

    public void advanceIfNeeded(int target) {
        this.iterator.advanceIfNeeded(target);
    }

    public BatchIterator clone() {
        return new BatchIteratorAdapter(this.iterator.clone());
    }
}

