/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.java.util.metrics;

import org.apache.druid.java.util.emitter.service.ServiceEmitter;
import org.apache.druid.java.util.emitter.service.ServiceMetricEvent;
import org.apache.druid.java.util.metrics.FeedDefiningMonitor;
import org.apache.druid.java.util.metrics.cgroups.CgroupDiscoverer;
import org.apache.druid.java.util.metrics.cgroups.CpuSet;
import org.apache.druid.java.util.metrics.cgroups.ProcSelfCgroupDiscoverer;

public class CgroupCpuSetMonitor
extends FeedDefiningMonitor {
    final CgroupDiscoverer cgroupDiscoverer;

    public CgroupCpuSetMonitor(CgroupDiscoverer cgroupDiscoverer, String feed) {
        super(feed);
        this.cgroupDiscoverer = cgroupDiscoverer;
    }

    public CgroupCpuSetMonitor(String feed) {
        this(ProcSelfCgroupDiscoverer.autoCgroupDiscoverer(), feed);
    }

    public CgroupCpuSetMonitor() {
        this("metrics");
    }

    @Override
    public boolean doMonitor(ServiceEmitter emitter) {
        CpuSet.CpuSetMetric cpusetSnapshot = this.cgroupDiscoverer.getCpuSetMetrics();
        ServiceMetricEvent.Builder builder = this.builder();
        builder.setDimension("cgroupversion", this.cgroupDiscoverer.getCgroupVersion().name());
        emitter.emit(builder.setMetric("cgroup/cpuset/cpu_count", cpusetSnapshot.getCpuSetCpus().length));
        emitter.emit(builder.setMetric("cgroup/cpuset/effective_cpu_count", cpusetSnapshot.getEffectiveCpuSetCpus().length));
        emitter.emit(builder.setMetric("cgroup/cpuset/mems_count", cpusetSnapshot.getCpuSetMems().length));
        emitter.emit(builder.setMetric("cgroup/cpuset/effective_mems_count", cpusetSnapshot.getEffectiveCpuSetMems().length));
        return true;
    }
}

