/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.query.groupby.epinephelinae;

import java.nio.ByteBuffer;
import org.apache.druid.java.util.common.IAE;
import org.apache.druid.java.util.common.StringUtils;

public class ByteBufferIntList {
    private final ByteBuffer buffer;
    private final int maxElements;
    private int numElements;

    public ByteBufferIntList(ByteBuffer buffer, int maxElements) {
        this.buffer = buffer;
        this.maxElements = maxElements;
        this.numElements = 0;
        if (buffer.capacity() < maxElements * 4) {
            throw new IAE("buffer for list is too small, was [%s] bytes, but need [%s] bytes.", buffer.capacity(), maxElements * 4);
        }
    }

    public void add(int val) {
        if (this.numElements == this.maxElements) {
            throw new IndexOutOfBoundsException(StringUtils.format("List is full with %d elements.", this.maxElements));
        }
        this.buffer.putInt(this.numElements * 4, val);
        ++this.numElements;
    }

    public void set(int index, int val) {
        this.buffer.putInt(index * 4, val);
    }

    public int get(int index) {
        return this.buffer.getInt(index * 4);
    }

    public void reset() {
        this.numElements = 0;
    }
}

