/*
 * Decompiled with CFR 0.152.
 */
package org.apache.druid.timeline.partition;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonValue;
import com.google.common.collect.ForwardingList;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.druid.data.input.StringTuple;
import org.apache.druid.java.util.common.IAE;

public class PartitionBoundaries
extends ForwardingList<StringTuple>
implements List<StringTuple> {
    private final List<StringTuple> delegate;

    public PartitionBoundaries(StringTuple ... partitions) {
        if (partitions.length == 0) {
            this.delegate = Collections.emptyList();
            return;
        }
        List partitionBoundaries = Arrays.stream(partitions).distinct().collect(Collectors.toCollection(ArrayList::new));
        partitionBoundaries.set(0, null);
        if (partitionBoundaries.size() == 1) {
            partitionBoundaries.add(null);
        } else {
            partitionBoundaries.set(partitionBoundaries.size() - 1, null);
        }
        this.delegate = Collections.unmodifiableList(partitionBoundaries);
    }

    @JsonCreator
    private PartitionBoundaries(Object[] partitions) {
        this.delegate = Arrays.stream(partitions).map(this::toStringTuple).collect(Collectors.toList());
    }

    @JsonValue
    public Object getSerializableObject() {
        boolean isSingleDim = true;
        for (StringTuple tuple : this.delegate) {
            if (tuple == null || tuple.size() == 1) continue;
            isSingleDim = false;
            break;
        }
        if (isSingleDim) {
            return this.delegate.stream().map(StringTuple::firstOrNull).collect(Collectors.toList());
        }
        return this.delegate;
    }

    private StringTuple toStringTuple(Object item) {
        if (item == null || item instanceof StringTuple) {
            return (StringTuple)item;
        }
        if (item instanceof String) {
            return StringTuple.create((String)item);
        }
        if (item instanceof String[]) {
            return StringTuple.create((String[])item);
        }
        if (item instanceof List) {
            return StringTuple.create(((List)item).toArray(new String[0]));
        }
        throw new IAE("Item must either be a String or StringTuple", new Object[0]);
    }

    protected List<StringTuple> delegate() {
        return this.delegate;
    }

    public int getNumBuckets() {
        return this.delegate.size() - 1;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PartitionBoundaries strings = (PartitionBoundaries)o;
        return Objects.equals(this.delegate, strings.delegate);
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.delegate);
    }
}

