/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.adhocquery.service;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.adhocquery.data.AdHocData;
import org.apache.fineract.adhocquery.exception.AdHocNotFoundException;
import org.apache.fineract.adhocquery.service.AdHocReadPlatformService;
import org.apache.fineract.adhocquery.service.AdHocReadPlatformServiceImpl;
import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.springframework.dao.EmptyResultDataAccessException;
import org.springframework.jdbc.core.JdbcTemplate;
import org.springframework.jdbc.core.RowMapper;

public class AdHocReadPlatformServiceImpl
implements AdHocReadPlatformService {
    private final JdbcTemplate jdbcTemplate;
    private final DatabaseSpecificSQLGenerator sqlGenerator;
    private final AdHocMapper adHocRowMapper;

    public List<AdHocData> retrieveAllAdHocQuery() {
        String sql = "select " + this.adHocRowMapper.schema() + " order by r.id";
        return this.jdbcTemplate.query(sql, (RowMapper)this.adHocRowMapper);
    }

    public List<AdHocData> retrieveAllActiveAdHocQuery() {
        String sql = "select " + this.adHocRowMapper.schema() + " where r." + this.sqlGenerator.escape("is_active") + " = true order by r.id";
        return this.jdbcTemplate.query(sql, (RowMapper)this.adHocRowMapper);
    }

    public AdHocData retrieveOne(Long id) {
        try {
            String sql = "select " + this.adHocRowMapper.schema() + " where r.id=?";
            return (AdHocData)this.jdbcTemplate.queryForObject(sql, (RowMapper)this.adHocRowMapper, new Object[]{id});
        }
        catch (EmptyResultDataAccessException e) {
            throw new AdHocNotFoundException(id, e);
        }
    }

    public AdHocData retrieveNewAdHocDetails() {
        return AdHocData.template();
    }

    @Generated
    public AdHocReadPlatformServiceImpl(JdbcTemplate jdbcTemplate, DatabaseSpecificSQLGenerator sqlGenerator, AdHocMapper adHocRowMapper) {
        this.jdbcTemplate = jdbcTemplate;
        this.sqlGenerator = sqlGenerator;
        this.adHocRowMapper = adHocRowMapper;
    }
}

