/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TreeMap;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.fineract.cob.COBBusinessStepService;
import org.apache.fineract.cob.data.BusinessStepNameAndOrder;
import org.apache.fineract.infrastructure.core.domain.AbstractPersistableCustom;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.ExitStatus;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterStep;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.lang.NonNull;

public abstract class AbstractLoanItemProcessor
implements ItemProcessor<Loan, Loan> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AbstractLoanItemProcessor.class);
    private final COBBusinessStepService cobBusinessStepService;
    private ExecutionContext executionContext;
    private LocalDate businessDate;

    public Loan process(@NonNull Loan item) throws Exception {
        Set businessSteps = (Set)this.executionContext.get("businessSteps");
        if (businessSteps == null) {
            throw new IllegalStateException("No business steps found in the execution context");
        }
        TreeMap businessStepMap = this.getBusinessStepMap(businessSteps);
        Loan alreadyProcessedLoan = (Loan)this.cobBusinessStepService.run(businessStepMap, (AbstractPersistableCustom)item);
        alreadyProcessedLoan.setLastClosedBusinessDate(this.businessDate);
        return alreadyProcessedLoan;
    }

    private TreeMap<Long, String> getBusinessStepMap(Set<BusinessStepNameAndOrder> businessSteps) {
        Map<Long, String> businessStepMap = businessSteps.stream().collect(Collectors.toMap(BusinessStepNameAndOrder::getStepOrder, BusinessStepNameAndOrder::getStepName));
        return new TreeMap<Long, String>(businessStepMap);
    }

    @AfterStep
    public ExitStatus afterStep(@NonNull StepExecution stepExecution) {
        return ExitStatus.COMPLETED;
    }

    protected void setBusinessDate(StepExecution stepExecution) {
        this.businessDate = LocalDate.parse(Objects.requireNonNull((String)stepExecution.getJobExecution().getExecutionContext().get("BusinessDate")), DateTimeFormatter.ISO_DATE);
    }

    @Generated
    public AbstractLoanItemProcessor(COBBusinessStepService cobBusinessStepService) {
        this.cobBusinessStepService = cobBusinessStepService;
    }

    @Generated
    protected void setExecutionContext(ExecutionContext executionContext) {
        this.executionContext = executionContext;
    }
}

