/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import com.google.gson.Gson;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.fineract.cob.COBBusinessStepService;
import org.apache.fineract.cob.common.CustomJobParameterResolver;
import org.apache.fineract.cob.exceptions.CustomJobParameterNotFoundException;
import org.apache.fineract.cob.loan.LoanCOBBusinessStep;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.domain.ActionContext;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.jobs.data.JobParameterDTO;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameter;
import org.apache.fineract.infrastructure.jobs.domain.CustomJobParameterRepository;
import org.apache.fineract.portfolio.loanaccount.exception.LoanNotFoundException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class InlineLoanCOBBuildExecutionContextTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(InlineLoanCOBBuildExecutionContextTasklet.class);
    private final COBBusinessStepService cobBusinessStepService;
    private final CustomJobParameterRepository customJobParameterRepository;
    private final CustomJobParameterResolver customJobParameterResolver;
    private final Gson gson = GoogleGsonSerializerHelper.createSimpleGson();

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        HashMap businessDates = ThreadLocalContextUtil.getBusinessDates();
        ThreadLocalContextUtil.setActionContext((ActionContext)ActionContext.COB);
        Set cobBusinessSteps = this.cobBusinessStepService.getCOBBusinessSteps(LoanCOBBusinessStep.class, "LOAN_CLOSE_OF_BUSINESS");
        contribution.getStepExecution().getExecutionContext().put("loanCobParameter", (Object)this.getLoanIdsFromJobParameters(chunkContext));
        contribution.getStepExecution().getExecutionContext().put("businessSteps", (Object)cobBusinessSteps);
        String businessDateString = this.getBusinessDateFromJobParameters(chunkContext);
        contribution.getStepExecution().getExecutionContext().put("BusinessDate", (Object)businessDateString);
        LocalDate businessDate = LocalDate.parse(businessDateString, DateTimeFormatter.ISO_DATE);
        businessDates.put(BusinessDateType.COB_DATE, businessDate);
        businessDates.put(BusinessDateType.BUSINESS_DATE, businessDate.plusDays(1L));
        ThreadLocalContextUtil.setBusinessDates((HashMap)businessDates);
        return RepeatStatus.FINISHED;
    }

    private String getBusinessDateFromJobParameters(ChunkContext chunkContext) {
        Long customJobParameterId = (Long)chunkContext.getStepContext().getJobParameters().get("BusinessDate");
        CustomJobParameter customJobParameter = (CustomJobParameter)this.customJobParameterRepository.findById(customJobParameterId).orElseThrow(() -> new LoanNotFoundException(customJobParameterId));
        String parameterJson = customJobParameter.getParameterJson();
        Set jobParameters = (Set)this.gson.fromJson(parameterJson, new /* Unavailable Anonymous Inner Class!! */.getType());
        JobParameterDTO businessDateParameter = jobParameters.stream().filter(jobParameterDTO -> jobParameterDTO.getParameterName().equals("BusinessDate")).findFirst().orElseThrow(() -> new CustomJobParameterNotFoundException("BusinessDate"));
        return businessDateParameter.getParameterValue();
    }

    private List<Long> getLoanIdsFromJobParameters(ChunkContext chunkContext) {
        Set jobParameters = (Set)this.customJobParameterResolver.getCustomJobParameterSet(chunkContext.getStepContext().getStepExecution()).orElseThrow(() -> new LoanNotFoundException("CUSTOM_JOB_PARAMETER_ID"));
        JobParameterDTO loanIdsParameter = jobParameters.stream().filter(jobParameterDTO -> jobParameterDTO.getParameterName().equals("LoanIds")).findFirst().orElseThrow(() -> new CustomJobParameterNotFoundException("LoanIds"));
        return (List)this.gson.fromJson(loanIdsParameter.getParameterValue(), new /* Unavailable Anonymous Inner Class!! */.getType());
    }

    @Generated
    public InlineLoanCOBBuildExecutionContextTasklet(COBBusinessStepService cobBusinessStepService, CustomJobParameterRepository customJobParameterRepository, CustomJobParameterResolver customJobParameterResolver) {
        this.cobBusinessStepService = cobBusinessStepService;
        this.customJobParameterRepository = customJobParameterRepository;
        this.customJobParameterResolver = customJobParameterResolver;
    }
}

