/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.loan;

import java.time.LocalDate;
import java.util.List;
import lombok.Generated;
import org.apache.fineract.cob.domain.LoanAccountLock;
import org.apache.fineract.cob.domain.LoanAccountLockRepository;
import org.apache.fineract.cob.domain.LockOwner;
import org.apache.fineract.cob.loan.LoanLockingService;
import org.apache.fineract.infrastructure.businessdate.domain.BusinessDateType;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.core.JdbcTemplate;

public class LoanLockingServiceImpl
implements LoanLockingService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(LoanLockingServiceImpl.class);
    private static final String NORMAL_LOAN_INSERT = "    INSERT INTO m_loan_account_locks (loan_id, version, lock_owner, lock_placed_on, lock_placed_on_cob_business_date)\n    SELECT loan.id, ?, ?, ?, ? FROM m_loan loan\n        WHERE loan.id NOT IN (SELECT loan_id FROM m_loan_account_locks)\n        AND loan.id BETWEEN ? AND ?\n        AND loan.loan_status_id IN (100,200,300,303,304)\n        AND (? = loan.last_closed_business_date OR loan.last_closed_business_date IS NULL)\n";
    private static final String CATCH_UP_LOAN_INSERT = "    INSERT INTO m_loan_account_locks (loan_id, version, lock_owner, lock_placed_on, lock_placed_on_cob_business_date)\n    SELECT loan.id, ?, ?, ?, ? FROM m_loan loan\n        WHERE loan.id NOT IN (SELECT loan_id FROM m_loan_account_locks)\n        AND loan.id BETWEEN ? AND ?\n        AND loan.loan_status_id IN (100,200,300,303,304)\n        AND (? = loan.last_closed_business_date)\n";
    private static final String BATCH_LOAN_LOCK_INSERT = "    INSERT INTO m_loan_account_locks (loan_id, version, lock_owner, lock_placed_on, lock_placed_on_cob_business_date) VALUES (?,?,?,?,?)\n";
    private final JdbcTemplate jdbcTemplate;
    private final FineractProperties fineractProperties;
    private final LoanAccountLockRepository loanAccountLockRepository;

    public void upgradeLock(List<Long> accountsToLock, LockOwner lockOwner) {
        this.jdbcTemplate.batchUpdate("    UPDATE m_loan_account_locks SET version= version + 1, lock_owner = ?, lock_placed_on = ? WHERE loan_id = ?\n", accountsToLock, this.getInClauseParameterSizeLimit(), (ps, id) -> {
            ps.setString(1, lockOwner.name());
            ps.setObject(2, DateUtils.getAuditOffsetDateTime());
            ps.setLong(3, (long)id);
        });
    }

    public List<LoanAccountLock> findAllByLoanIdIn(List<Long> loanIds) {
        return this.loanAccountLockRepository.findAllByLoanIdIn(loanIds);
    }

    public LoanAccountLock findByLoanIdAndLockOwner(Long loanId, LockOwner lockOwner) {
        return this.loanAccountLockRepository.findByLoanIdAndLockOwner(loanId, lockOwner).orElseGet(() -> {
            log.warn("There is no lock for loan account with id: {}", (Object)loanId);
            return null;
        });
    }

    public List<LoanAccountLock> findAllByLoanIdInAndLockOwner(List<Long> loanIds, LockOwner lockOwner) {
        return this.loanAccountLockRepository.findAllByLoanIdInAndLockOwner(loanIds, lockOwner);
    }

    public void applyLock(List<Long> loanIds, LockOwner lockOwner) {
        LocalDate cobBusinessDate = ThreadLocalContextUtil.getBusinessDateByType((BusinessDateType)BusinessDateType.COB_DATE);
        this.jdbcTemplate.batchUpdate(BATCH_LOAN_LOCK_INSERT, loanIds, loanIds.size(), (ps, loanId) -> {
            ps.setLong(1, (long)loanId);
            ps.setLong(2, 1L);
            ps.setString(3, lockOwner.name());
            ps.setObject(4, DateUtils.getAuditOffsetDateTime());
            ps.setObject(5, cobBusinessDate);
        });
    }

    public void deleteByLoanIdInAndLockOwner(List<Long> loanIds, LockOwner lockOwner) {
        this.loanAccountLockRepository.deleteByLoanIdInAndLockOwner(loanIds, lockOwner);
    }

    private int getInClauseParameterSizeLimit() {
        return this.fineractProperties.getQuery().getInClauseParameterSizeLimit();
    }

    @Generated
    public LoanLockingServiceImpl(JdbcTemplate jdbcTemplate, FineractProperties fineractProperties, LoanAccountLockRepository loanAccountLockRepository) {
        this.jdbcTemplate = jdbcTemplate;
        this.fineractProperties = fineractProperties;
        this.loanAccountLockRepository = loanAccountLockRepository;
    }
}

