/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.cob.service;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.api.JsonCommand;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.stereotype.Component;

@Component
public class InlineLoanCOBExecutionDataParser {
    private final FromJsonHelper jsonHelper;

    public List<Long> parseExecution(JsonCommand command) {
        JsonObject element = this.extractJsonObject(command);
        String[] loanArray = this.jsonHelper.extractArrayNamed("loanIds", (JsonElement)element);
        return Arrays.stream(loanArray).map(Long::parseLong).toList();
    }

    private JsonObject extractJsonObject(JsonCommand command) {
        String json = command.json();
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        JsonElement element = this.jsonHelper.parse(json);
        return element.getAsJsonObject();
    }

    @Generated
    public InlineLoanCOBExecutionDataParser(FromJsonHelper jsonHelper) {
        this.jsonHelper = jsonHelper;
    }
}

