/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.importhandler.client;

import com.google.common.base.Splitter;
import com.google.gson.GsonBuilder;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.apache.fineract.commands.domain.CommandWrapper;
import org.apache.fineract.commands.service.CommandWrapperBuilder;
import org.apache.fineract.commands.service.PortfolioCommandSourceWritePlatformService;
import org.apache.fineract.infrastructure.bulkimport.data.Count;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandler;
import org.apache.fineract.infrastructure.bulkimport.importhandler.ImportHandlerUtils;
import org.apache.fineract.infrastructure.bulkimport.importhandler.helper.DateSerializer;
import org.apache.fineract.infrastructure.core.domain.ExternalId;
import org.apache.fineract.infrastructure.core.serialization.GoogleGsonSerializerHelper;
import org.apache.fineract.infrastructure.core.service.ExternalIdFactory;
import org.apache.fineract.portfolio.address.data.AddressData;
import org.apache.fineract.portfolio.client.data.ClientData;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class ClientPersonImportHandler
implements ImportHandler {
    public static final String SEPARATOR = "-";
    private static final Logger LOG = LoggerFactory.getLogger(ClientPersonImportHandler.class);
    private final PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService;
    private final ExternalIdFactory externalIdFactory;

    public Count process(Workbook workbook, String locale, String dateFormat) {
        List clients = this.readExcelFile(workbook, locale, dateFormat);
        return this.importEntity(workbook, clients, dateFormat, locale);
    }

    public List<ClientData> readExcelFile(Workbook workbook, String locale, String dateFormat) {
        ArrayList<ClientData> clients = new ArrayList<ClientData>();
        Sheet clientSheet = workbook.getSheet("ClientPerson");
        Integer noOfEntries = ImportHandlerUtils.getNumberOfRows((Sheet)clientSheet, (int)0);
        for (int rowIndex = 1; rowIndex <= noOfEntries; ++rowIndex) {
            Row row = clientSheet.getRow(rowIndex);
            if (!ImportHandlerUtils.isNotImported((Row)row, (int)27)) continue;
            clients.add(this.readClient(workbook, row, locale, dateFormat));
        }
        return clients;
    }

    private ClientData readClient(Workbook workbook, Row row, String locale, String dateFormat) {
        List clientClassificationAr;
        List genderAr;
        List clientTypeAr;
        Long legalFormId = 1L;
        String firstName = ImportHandlerUtils.readAsString((int)0, (Row)row);
        String lastName = ImportHandlerUtils.readAsString((int)1, (Row)row);
        String middleName = ImportHandlerUtils.readAsString((int)2, (Row)row);
        String officeName = ImportHandlerUtils.readAsString((int)3, (Row)row);
        Long officeId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Offices"), (String)officeName);
        if (officeId == 0L) {
            officeId = null;
        }
        String staffName = ImportHandlerUtils.readAsString((int)4, (Row)row);
        Long staffId = null;
        if (staffName != null) {
            staffId = ImportHandlerUtils.getIdByName((Sheet)workbook.getSheet("Staff"), (String)staffName);
        }
        ExternalId externalId = this.externalIdFactory.create(ImportHandlerUtils.readAsString((int)5, (Row)row));
        LocalDate submittedOn = ImportHandlerUtils.readAsDate((int)7, (Row)row);
        LocalDate activationDate = ImportHandlerUtils.readAsDate((int)8, (Row)row);
        Boolean active = ImportHandlerUtils.readAsBoolean((int)6, (Row)row);
        if (!active.booleanValue()) {
            activationDate = submittedOn;
        }
        String mobileNo = null;
        if (ImportHandlerUtils.readAsLong((int)9, (Row)row) != null) {
            mobileNo = Objects.requireNonNull(ImportHandlerUtils.readAsLong((int)9, (Row)row)).toString();
        }
        LocalDate dob = ImportHandlerUtils.readAsDate((int)10, (Row)row);
        String clientType = ImportHandlerUtils.readAsString((int)11, (Row)row);
        Long clientTypeId = null;
        if (clientType != null && (clientTypeAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)clientType)).size() > 1 && clientTypeAr.get(1) != null) {
            clientTypeId = Long.parseLong((String)clientTypeAr.get(1));
        }
        String gender = ImportHandlerUtils.readAsString((int)12, (Row)row);
        Long genderId = null;
        if (gender != null && (genderAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)gender)).size() > 1 && genderAr.get(1) != null) {
            genderId = Long.parseLong((String)genderAr.get(1));
        }
        String clientClassification = ImportHandlerUtils.readAsString((int)13, (Row)row);
        Long clientClassificationId = null;
        if (clientClassification != null && (clientClassificationAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)clientClassification)).size() > 1 && clientClassificationAr.get(1) != null) {
            clientClassificationId = Long.parseLong((String)clientClassificationAr.get(1));
        }
        Boolean isStaff = ImportHandlerUtils.readAsBoolean((int)14, (Row)row);
        AddressData addressDataObj = null;
        ArrayList<AddressData> addressList = null;
        if (ImportHandlerUtils.readAsBoolean((int)15, (Row)row).booleanValue()) {
            List countryAr;
            List stateProvinceAr;
            List addressTypeAr;
            String addressType = ImportHandlerUtils.readAsString((int)16, (Row)row);
            Long addressTypeId = null;
            if (addressType != null && (addressTypeAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)addressType)).size() > 1 && addressTypeAr.get(1) != null) {
                addressTypeId = Long.parseLong((String)addressTypeAr.get(1));
            }
            String street = ImportHandlerUtils.readAsString((int)17, (Row)row);
            String addressLine1 = ImportHandlerUtils.readAsString((int)18, (Row)row);
            String addressLine2 = ImportHandlerUtils.readAsString((int)19, (Row)row);
            String addressLine3 = ImportHandlerUtils.readAsString((int)20, (Row)row);
            String city = ImportHandlerUtils.readAsString((int)21, (Row)row);
            String postalCode = ImportHandlerUtils.readAsString((int)24, (Row)row);
            Boolean isActiveAddress = ImportHandlerUtils.readAsBoolean((int)25, (Row)row);
            String stateProvince = ImportHandlerUtils.readAsString((int)22, (Row)row);
            Long stateProvinceId = null;
            if (stateProvince != null && (stateProvinceAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)stateProvince)).size() > 1 && stateProvinceAr.get(1) != null) {
                stateProvinceId = Long.parseLong((String)stateProvinceAr.get(1));
            }
            String country = ImportHandlerUtils.readAsString((int)23, (Row)row);
            Long countryId = null;
            if (country != null && (countryAr = Splitter.on((String)SEPARATOR).splitToList((CharSequence)country)).size() > 1 && countryAr.get(1) != null) {
                countryId = Long.parseLong((String)countryAr.get(1));
            }
            addressDataObj = new AddressData(addressTypeId, street, addressLine1, addressLine2, addressLine3, city, postalCode, isActiveAddress, stateProvinceId, countryId);
            addressList = new ArrayList<AddressData>(List.of(addressDataObj));
        }
        return ClientData.importClientPersonInstance((Long)legalFormId, (Integer)row.getRowNum(), (String)firstName, (String)lastName, (String)middleName, (LocalDate)submittedOn, (LocalDate)activationDate, (Boolean)active, (ExternalId)externalId, (Long)officeId, (Long)staffId, (String)mobileNo, (LocalDate)dob, (Long)clientTypeId, (Long)genderId, (Long)clientClassificationId, (Boolean)isStaff, addressList, (String)locale, (String)dateFormat);
    }

    public Count importEntity(Workbook workbook, List<ClientData> clients, String dateFormat, String locale) {
        Sheet clientSheet = workbook.getSheet("ClientPerson");
        int successCount = 0;
        int errorCount = 0;
        GsonBuilder gsonBuilder = GoogleGsonSerializerHelper.createGsonBuilder();
        gsonBuilder.registerTypeAdapter(LocalDate.class, (Object)new DateSerializer(dateFormat, locale));
        for (ClientData client : clients) {
            try {
                String payload = gsonBuilder.create().toJson((Object)client);
                CommandWrapper commandRequest = new CommandWrapperBuilder().createClient().withJson(payload).build();
                this.commandsSourceWritePlatformService.logCommandSource(commandRequest);
                ++successCount;
                Cell statusCell = clientSheet.getRow(client.getRowIndex().intValue()).createCell(27);
                statusCell.setCellValue("Imported");
                statusCell.setCellStyle(ImportHandlerUtils.getCellStyle((Workbook)workbook, (IndexedColors)IndexedColors.LIGHT_GREEN));
            }
            catch (RuntimeException ex) {
                ++errorCount;
                LOG.error("Problem occurred in importEntity function", (Throwable)ex);
                String errorMessage = ImportHandlerUtils.getErrorMessage((RuntimeException)ex);
                ImportHandlerUtils.writeErrorMessage((Sheet)clientSheet, (Integer)client.getRowIndex(), (String)errorMessage, (int)27);
            }
        }
        clientSheet.setColumnWidth(27, 4000);
        ImportHandlerUtils.writeString((int)27, (Row)clientSheet.getRow(0), (String)"Status");
        return Count.instance((Integer)successCount, (Integer)errorCount);
    }

    @Generated
    public ClientPersonImportHandler(PortfolioCommandSourceWritePlatformService commandsSourceWritePlatformService, ExternalIdFactory externalIdFactory) {
        this.commandsSourceWritePlatformService = commandsSourceWritePlatformService;
        this.externalIdFactory = externalIdFactory;
    }
}

