/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.organisation.office.data.OfficeData;
import org.apache.fineract.portfolio.group.data.GroupGeneralData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class GroupSheetPopulator
extends AbstractWorkbookPopulator {
    private List<GroupGeneralData> groups;
    private List<OfficeData> offices;
    private Map<String, ArrayList<String>> officeToGroups;
    private Map<Integer, Integer[]> officeNameToBeginEndIndexesOfGroups;
    private Map<String, Long> groupNameToGroupId;
    private static final int OFFICE_NAME_COL = 0;
    private static final int GROUP_NAME_COL = 1;
    private static final int GROUP_ID_COL = 2;

    public GroupSheetPopulator(List<GroupGeneralData> groups, List<OfficeData> offices) {
        this.groups = groups;
        this.offices = offices;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet groupSheet = workbook.createSheet("Groups");
        this.setLayout(groupSheet);
        this.setGroupNameToGroupIdMap();
        this.setOfficeToGroupsMap();
        this.populateGroupsByOfficeName(groupSheet);
        groupSheet.protectSheet("");
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        for (int colIndex = 0; colIndex <= 10; ++colIndex) {
            worksheet.setColumnWidth(colIndex, 6000);
        }
        this.writeString(0, rowHeader, "Office Names");
        this.writeString(1, rowHeader, "Group Names");
        this.writeString(2, rowHeader, "Group ID");
    }

    private void setOfficeToGroupsMap() {
        this.officeToGroups = new HashMap();
        for (GroupGeneralData group : this.groups) {
            this.add(group.getOfficeName().trim().replaceAll("[ )(]", "_"), group.getName().trim());
        }
    }

    private void add(String key, String value) {
        ArrayList<String> values = (ArrayList<String>)this.officeToGroups.get(key);
        if (values == null) {
            values = new ArrayList<String>();
        }
        values.add(value);
        this.officeToGroups.put(key, values);
    }

    private void populateGroupsByOfficeName(Sheet groupSheet) {
        int rowIndex = 1;
        int officeIndex = 0;
        int startIndex = 1;
        this.officeNameToBeginEndIndexesOfGroups = new HashMap();
        Row row = groupSheet.createRow(rowIndex);
        for (OfficeData office : this.offices) {
            startIndex = rowIndex + 1;
            this.writeString(0, row, office.getName());
            ArrayList groupsList = new ArrayList();
            if (this.officeToGroups.containsKey(office.getName().trim().replaceAll("[ )(]", "_"))) {
                groupsList = (ArrayList)this.officeToGroups.get(office.getName().trim().replaceAll("[ )(]", "_"));
            }
            if (!groupsList.isEmpty()) {
                for (String groupName : groupsList) {
                    this.writeString(1, row, groupName);
                    this.writeLong(2, row, ((Long)this.groupNameToGroupId.get(groupName)).longValue());
                    row = groupSheet.createRow(++rowIndex);
                }
                this.officeNameToBeginEndIndexesOfGroups.put(officeIndex++, new Integer[]{startIndex, rowIndex});
                continue;
            }
            this.officeNameToBeginEndIndexesOfGroups.put(officeIndex++, new Integer[]{startIndex, rowIndex + 1});
        }
    }

    public List<GroupGeneralData> getGroups() {
        return this.groups;
    }

    public Integer getGroupsSize() {
        return this.groups.size();
    }

    public Map<Integer, Integer[]> getOfficeNameToBeginEndIndexesOfGroups() {
        return this.officeNameToBeginEndIndexesOfGroups;
    }

    private void setGroupNameToGroupIdMap() {
        this.groupNameToGroupId = new HashMap();
        for (GroupGeneralData group : this.groups) {
            this.groupNameToGroupId.put(group.getName().trim(), group.getId());
        }
    }
}

