/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator;

import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.portfolio.charge.data.ChargeData;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductData;
import org.apache.fineract.portfolio.shareproducts.data.ShareProductMarketPriceData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;

public class SharedProductsSheetPopulator
extends AbstractWorkbookPopulator {
    private List<ShareProductData> sharedProductDataList;
    private List<ChargeData> chargesForSharedProducts;
    private Map<Long, Integer[]> productToBeginEndIndexesofCharges;
    private static final int PRODUCT_ID = 0;
    private static final int PRODUCT_NAME_COL = 1;
    private static final int CURRENCY_COL = 2;
    private static final int DECIMAL_PLACES_COL = 3;
    private static final int TODAYS_PRICE_COL = 4;
    private static final int CURRENCY_IN_MULTIPLES_COL = 5;
    private static final int CHARGES_ID_1_COL = 7;
    private static final int CHARGES_NAME_1_COL = 8;
    private static final int CHARGES_ID_2_COL = 9;
    private static final int CHARGES_NAME_2_COL = 10;
    private static final int CHARGES_ID_3_COL = 11;
    private static final int CHARGES_NAME_3_COL = 12;

    public SharedProductsSheetPopulator(List<ShareProductData> shareProductDataList, List<ChargeData> chargesForShares) {
        this.sharedProductDataList = shareProductDataList;
        this.chargesForSharedProducts = chargesForShares;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet sharedProductsSheet = workbook.createSheet("SharedProducts");
        this.setLayout(sharedProductsSheet);
        this.populateSheet(sharedProductsSheet);
        sharedProductsSheet.protectSheet("");
    }

    private void populateSheet(Sheet sharedProductsSheet) {
        int index = 0;
        int startIndexCharges = 1;
        int endIndexCharges = 0;
        this.productToBeginEndIndexesofCharges = new HashMap();
        for (ShareProductData productData : this.sharedProductDataList) {
            Row row = sharedProductsSheet.createRow(++index);
            this.writeLong(0, row, productData.getId().longValue());
            this.writeString(1, row, productData.getName().replaceAll("[ ]", "_"));
            this.writeString(2, row, productData.getCurrency().getName().replaceAll("[ ]", "_"));
            this.writeInt(3, row, productData.getCurrency().getDecimalPlaces());
            this.writeBigDecimal(4, row, this.deriveMarketPrice(productData));
            this.writeInt(5, row, productData.getCurrency().getInMultiplesOf().intValue());
            if (this.chargesForSharedProducts == null) continue;
            int chargeRowIndex = 0;
            for (ChargeData chargeData : this.chargesForSharedProducts) {
                if (!chargeData.getCurrency().getName().equals(productData.getCurrency().getName())) continue;
                this.writeString(8 + chargeRowIndex, row, chargeData.getName());
                this.writeLong(7 + chargeRowIndex, row, chargeData.getId().longValue());
                chargeRowIndex += 2;
                ++endIndexCharges;
            }
            this.productToBeginEndIndexesofCharges.put(productData.getId(), new Integer[]{startIndexCharges, endIndexCharges});
            startIndexCharges = endIndexCharges + 1;
        }
    }

    private BigDecimal deriveMarketPrice(ShareProductData shareProductData) {
        BigDecimal marketValue = shareProductData.getUnitPrice();
        Collection marketDataSet = shareProductData.getMarketPrice();
        if (marketDataSet != null && !marketDataSet.isEmpty()) {
            LocalDate currentDate = DateUtils.getBusinessLocalDate();
            for (ShareProductMarketPriceData data : marketDataSet) {
                if (!DateUtils.isBefore((LocalDate)data.getFromDate(), (LocalDate)currentDate)) continue;
                marketValue = data.getShareValue();
            }
        }
        return marketValue;
    }

    private void setLayout(Sheet workSheet) {
        Row rowHeader = workSheet.createRow(0);
        rowHeader.setHeight((short)500);
        workSheet.setColumnWidth(0, 4000);
        this.writeString(0, rowHeader, "Product Id");
        workSheet.setColumnWidth(1, 6000);
        this.writeString(1, rowHeader, "Product Name");
        workSheet.setColumnWidth(2, 6000);
        this.writeString(2, rowHeader, "Currency");
        workSheet.setColumnWidth(3, 4000);
        this.writeString(3, rowHeader, "Decimal Places");
        workSheet.setColumnWidth(4, 4000);
        this.writeString(4, rowHeader, "Today's Price");
        workSheet.setColumnWidth(5, 4000);
        this.writeString(5, rowHeader, "Currency in multiples of");
        workSheet.setColumnWidth(8, 4000);
        this.writeString(8, rowHeader, "Charges Name 1");
        workSheet.setColumnWidth(7, 4000);
        this.writeString(7, rowHeader, "Charges Id 1");
        workSheet.setColumnWidth(10, 4000);
        this.writeString(10, rowHeader, "Charges Name 2");
        workSheet.setColumnWidth(9, 4000);
        this.writeString(9, rowHeader, "Charges Id 2");
        workSheet.setColumnWidth(12, 4000);
        this.writeString(12, rowHeader, "Charges Name 3");
        workSheet.setColumnWidth(11, 4000);
        this.writeString(11, rowHeader, "Charges Id 3");
    }

    public List<ShareProductData> getSharedProductDataList() {
        return this.sharedProductDataList;
    }

    public Map<Long, Integer[]> getProductToBeginEndIndexesofCharges() {
        return this.productToBeginEndIndexesofCharges;
    }
}

