/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.bulkimport.populator.savings;

import java.util.List;
import org.apache.fineract.infrastructure.bulkimport.constants.TemplatePopulateImportConstants;
import org.apache.fineract.infrastructure.bulkimport.populator.AbstractWorkbookPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.ClientSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.GroupSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.OfficeSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.PersonnelSheetPopulator;
import org.apache.fineract.infrastructure.bulkimport.populator.SavingsProductSheetPopulator;
import org.apache.fineract.portfolio.savings.data.SavingsProductData;
import org.apache.poi.hssf.usermodel.HSSFDataValidationHelper;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.DataValidation;
import org.apache.poi.ss.usermodel.DataValidationConstraint;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddressList;

public class SavingsWorkbookPopulator
extends AbstractWorkbookPopulator {
    private final OfficeSheetPopulator officeSheetPopulator;
    private final ClientSheetPopulator clientSheetPopulator;
    private final GroupSheetPopulator groupSheetPopulator;
    private final PersonnelSheetPopulator personnelSheetPopulator;
    private final SavingsProductSheetPopulator productSheetPopulator;

    public SavingsWorkbookPopulator(OfficeSheetPopulator officeSheetPopulator, ClientSheetPopulator clientSheetPopulator, GroupSheetPopulator groupSheetPopulator, PersonnelSheetPopulator personnelSheetPopulator, SavingsProductSheetPopulator savingsProductSheetPopulator) {
        this.officeSheetPopulator = officeSheetPopulator;
        this.clientSheetPopulator = clientSheetPopulator;
        this.groupSheetPopulator = groupSheetPopulator;
        this.personnelSheetPopulator = personnelSheetPopulator;
        this.productSheetPopulator = savingsProductSheetPopulator;
    }

    public void populate(Workbook workbook, String dateFormat) {
        Sheet savingsSheet = workbook.createSheet("SavingsAccounts");
        this.officeSheetPopulator.populate(workbook, dateFormat);
        this.clientSheetPopulator.populate(workbook, dateFormat);
        this.groupSheetPopulator.populate(workbook, dateFormat);
        this.personnelSheetPopulator.populate(workbook, dateFormat);
        this.productSheetPopulator.populate(workbook, dateFormat);
        this.setRules(savingsSheet, dateFormat);
        this.setDefaults(savingsSheet, dateFormat);
        this.setClientAndGroupDateLookupTable(savingsSheet, this.clientSheetPopulator.getClients(), this.groupSheetPopulator.getGroups(), 31, 32, TemplatePopulateImportConstants.CONTAINS_CLIENT_EXTERNAL_ID == false, dateFormat);
        this.setLayout(savingsSheet);
    }

    private void setLayout(Sheet worksheet) {
        Row rowHeader = worksheet.createRow(0);
        rowHeader.setHeight((short)500);
        worksheet.setColumnWidth(0, 4000);
        worksheet.setColumnWidth(1, 4000);
        worksheet.setColumnWidth(2, 4000);
        worksheet.setColumnWidth(3, 4000);
        worksheet.setColumnWidth(4, 4000);
        worksheet.setColumnWidth(5, 4000);
        worksheet.setColumnWidth(6, 4000);
        worksheet.setColumnWidth(7, 4000);
        worksheet.setColumnWidth(8, 4000);
        worksheet.setColumnWidth(9, 4000);
        worksheet.setColumnWidth(10, 4000);
        worksheet.setColumnWidth(11, 4000);
        worksheet.setColumnWidth(12, 4000);
        worksheet.setColumnWidth(13, 4000);
        worksheet.setColumnWidth(14, 4000);
        worksheet.setColumnWidth(15, 4000);
        worksheet.setColumnWidth(16, 4000);
        worksheet.setColumnWidth(17, 4000);
        worksheet.setColumnWidth(18, 4000);
        worksheet.setColumnWidth(19, 4000);
        worksheet.setColumnWidth(31, 6000);
        worksheet.setColumnWidth(32, 6000);
        worksheet.setColumnWidth(22, 6000);
        worksheet.setColumnWidth(20, 6000);
        worksheet.setColumnWidth(21, 6000);
        worksheet.setColumnWidth(34, 6000);
        worksheet.setColumnWidth(35, 6000);
        worksheet.setColumnWidth(36, 6000);
        worksheet.setColumnWidth(37, 6000);
        worksheet.setColumnWidth(38, 6000);
        worksheet.setColumnWidth(39, 6000);
        this.writeString(0, rowHeader, "Office Name*");
        this.writeString(1, rowHeader, "Individual/Group*");
        this.writeString(2, rowHeader, "Client Name*");
        this.writeString(3, rowHeader, "Product*");
        this.writeString(4, rowHeader, "Field Officer*");
        this.writeString(5, rowHeader, "Submitted On*");
        this.writeString(6, rowHeader, "Approved On*");
        this.writeString(7, rowHeader, "Activation Date*");
        this.writeString(8, rowHeader, "Currency");
        this.writeString(9, rowHeader, "Decimal Places");
        this.writeString(10, rowHeader, "In Multiples Of");
        this.writeString(11, rowHeader, "Interest Rate %*");
        this.writeString(12, rowHeader, "Interest Compounding Period*");
        this.writeString(13, rowHeader, "Interest Posting Period*");
        this.writeString(14, rowHeader, "Interest Calculated*");
        this.writeString(15, rowHeader, "# Days in Year*");
        this.writeString(16, rowHeader, "Min Opening Balance");
        this.writeString(17, rowHeader, "Locked In For");
        this.writeString(18, rowHeader, "Locked periodod frecuency*");
        this.writeString(19, rowHeader, "Apply Withdrawal Fee For Transfers");
        this.writeString(31, rowHeader, "Client Name");
        this.writeString(32, rowHeader, "Client Activation Date");
        this.writeString(22, rowHeader, "External Id");
        this.writeString(20, rowHeader, "Is Overdraft Allowed ");
        this.writeString(21, rowHeader, "  Maximum Overdraft Amount Limit ");
        this.writeString(34, rowHeader, "Charge Id");
        this.writeString(35, rowHeader, "Charged Amount");
        this.writeString(36, rowHeader, "Charged On Date");
        this.writeString(37, rowHeader, "Charge Id");
        this.writeString(38, rowHeader, "Charged Amount");
        this.writeString(39, rowHeader, "Charged On Date");
    }

    private void setDefaults(Sheet worksheet, String dateFormat) {
        Workbook workbook = worksheet.getWorkbook();
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat(dateFormat);
        dateCellStyle.setDataFormat(df);
        Integer rowNo = 1;
        while (rowNo < 1000) {
            Row row = worksheet.createRow(rowNo.intValue());
            this.setFormatStyle(worksheet, row);
            this.writeFormula(8, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Currency_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Currency_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(9, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Decimal_Places_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Decimal_Places_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(10, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"In_Multiples_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"In_Multiples_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(11, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Interest_Rate_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Interest_Rate_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(12, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Interest_Compouding_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Interest_Compouding_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(13, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Interest_Posting_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Interest_Posting_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(14, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Interest_Calculation_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Interest_Calculation_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(15, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Days_In_Year_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Days_In_Year_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(16, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Min_Balance_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Min_Balance_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(17, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Lockin_Period_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Lockin_Period_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(18, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Lockin_Frequency_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Lockin_Frequency_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(19, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Withdrawal_Fee_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Withdrawal_Fee_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(20, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Overdraft_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Overdraft_\",$D" + (rowNo + 1) + ")))");
            this.writeFormula(21, row, "IF(ISERROR(INDIRECT(CONCATENATE(\"Overdraft_Limit_\",$D" + (rowNo + 1) + "))),\"\",INDIRECT(CONCATENATE(\"Overdraft_Limit_\",$D" + (rowNo + 1) + ")))");
            Integer n = rowNo;
            rowNo = rowNo + 1;
        }
    }

    private void setFormatStyle(Sheet worksheet, Row row) {
        Workbook workbook = worksheet.getWorkbook();
        CellStyle dateCellStyle = workbook.createCellStyle();
        short df = workbook.createDataFormat().getFormat("dd/MM/yyyy");
        dateCellStyle.setDataFormat(df);
        Cell submittedOnCell = row.getCell(5);
        if (submittedOnCell == null) {
            submittedOnCell = row.createCell(5);
        }
        submittedOnCell.setCellStyle(dateCellStyle);
    }

    private void setRules(Sheet worksheet, String dateFormat) {
        CellRangeAddressList officeNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 0, 0);
        CellRangeAddressList savingsTypeRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 1, 1);
        CellRangeAddressList clientNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 2, 2);
        CellRangeAddressList productNameRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 3, 3);
        CellRangeAddressList fieldOfficerRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 4, 4);
        CellRangeAddressList submittedDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 5, 5);
        CellRangeAddressList approvedDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 6, 6);
        CellRangeAddressList activationDateRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 7, 7);
        CellRangeAddressList interestCompudingPeriodRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 12, 12);
        CellRangeAddressList interestPostingPeriodRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 13, 13);
        CellRangeAddressList interestCalculationRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 14, 14);
        CellRangeAddressList interestCalculationDaysInYearRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 15, 15);
        CellRangeAddressList lockinPeriodFrequencyRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 18, 18);
        CellRangeAddressList applyWithdrawalFeeForTransfersRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 19, 19);
        CellRangeAddressList allowOverdraftRange = new CellRangeAddressList(1, SpreadsheetVersion.EXCEL97.getLastRowIndex(), 20, 20);
        HSSFDataValidationHelper validationHelper = new HSSFDataValidationHelper((HSSFSheet)worksheet);
        this.setNames(worksheet);
        DataValidationConstraint officeNameConstraint = validationHelper.createFormulaListConstraint("Office");
        DataValidationConstraint savingsTypeConstraint = validationHelper.createExplicitListConstraint(new String[]{"Individual", "Group"});
        DataValidationConstraint clientNameConstraint = validationHelper.createFormulaListConstraint("IF($B1=\"Individual\",INDIRECT(CONCATENATE(\"Client_\",$A1)),INDIRECT(CONCATENATE(\"Group_\",$A1)))");
        DataValidationConstraint productNameConstraint = validationHelper.createFormulaListConstraint("Products");
        DataValidationConstraint fieldOfficerNameConstraint = validationHelper.createFormulaListConstraint("INDIRECT(CONCATENATE(\"Staff_\",$A1))");
        DataValidationConstraint submittedDateConstraint = validationHelper.createDateConstraint(0, "=DATEVALUE(VLOOKUP($C1,$AF$2:$AG$" + (this.clientSheetPopulator.getClientsSize() + this.groupSheetPopulator.getGroupsSize() + 1) + ",2,FALSE))", "=TODAY()", dateFormat);
        DataValidationConstraint approvalDateConstraint = validationHelper.createDateConstraint(0, "=$F1", "=TODAY()", dateFormat);
        DataValidationConstraint activationDateConstraint = validationHelper.createDateConstraint(0, "=$G1", "=TODAY()", dateFormat);
        DataValidationConstraint interestCompudingPeriodConstraint = validationHelper.createExplicitListConstraint(new String[]{"Daily", "Monthly", "Quarterly", "Semi-Annual", "Annually"});
        DataValidationConstraint interestPostingPeriodConstraint = validationHelper.createExplicitListConstraint(new String[]{"Monthly", "Quarterly", "BiAnnual", "Annually"});
        DataValidationConstraint interestCalculationConstraint = validationHelper.createExplicitListConstraint(new String[]{"Daily Balance", "Average Daily Balance"});
        DataValidationConstraint interestCalculationDaysInYearConstraint = validationHelper.createExplicitListConstraint(new String[]{"360 Days", "365 Days"});
        DataValidationConstraint lockinPeriodFrequencyConstraint = validationHelper.createExplicitListConstraint(new String[]{"Days", "Weeks", "Months", "Years"});
        DataValidationConstraint applyWithdrawalFeeForTransferConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidationConstraint allowOverdraftConstraint = validationHelper.createExplicitListConstraint(new String[]{"True", "False"});
        DataValidation officeValidation = validationHelper.createValidation(officeNameConstraint, officeNameRange);
        DataValidation savingsTypeValidation = validationHelper.createValidation(savingsTypeConstraint, savingsTypeRange);
        DataValidation clientValidation = validationHelper.createValidation(clientNameConstraint, clientNameRange);
        DataValidation productNameValidation = validationHelper.createValidation(productNameConstraint, productNameRange);
        DataValidation fieldOfficerValidation = validationHelper.createValidation(fieldOfficerNameConstraint, fieldOfficerRange);
        DataValidation interestCompudingPeriodValidation = validationHelper.createValidation(interestCompudingPeriodConstraint, interestCompudingPeriodRange);
        DataValidation interestPostingPeriodValidation = validationHelper.createValidation(interestPostingPeriodConstraint, interestPostingPeriodRange);
        DataValidation interestCalculationValidation = validationHelper.createValidation(interestCalculationConstraint, interestCalculationRange);
        DataValidation interestCalculationDaysInYearValidation = validationHelper.createValidation(interestCalculationDaysInYearConstraint, interestCalculationDaysInYearRange);
        DataValidation lockinPeriodFrequencyValidation = validationHelper.createValidation(lockinPeriodFrequencyConstraint, lockinPeriodFrequencyRange);
        DataValidation applyWithdrawalFeeForTransferValidation = validationHelper.createValidation(applyWithdrawalFeeForTransferConstraint, applyWithdrawalFeeForTransfersRange);
        DataValidation submittedDateValidation = validationHelper.createValidation(submittedDateConstraint, submittedDateRange);
        DataValidation approvalDateValidation = validationHelper.createValidation(approvalDateConstraint, approvedDateRange);
        DataValidation activationDateValidation = validationHelper.createValidation(activationDateConstraint, activationDateRange);
        DataValidation allowOverdraftValidation = validationHelper.createValidation(allowOverdraftConstraint, allowOverdraftRange);
        worksheet.addValidationData(officeValidation);
        worksheet.addValidationData(savingsTypeValidation);
        worksheet.addValidationData(clientValidation);
        worksheet.addValidationData(productNameValidation);
        worksheet.addValidationData(fieldOfficerValidation);
        worksheet.addValidationData(submittedDateValidation);
        worksheet.addValidationData(approvalDateValidation);
        worksheet.addValidationData(activationDateValidation);
        worksheet.addValidationData(interestCompudingPeriodValidation);
        worksheet.addValidationData(interestPostingPeriodValidation);
        worksheet.addValidationData(interestCalculationValidation);
        worksheet.addValidationData(interestCalculationDaysInYearValidation);
        worksheet.addValidationData(lockinPeriodFrequencyValidation);
        worksheet.addValidationData(applyWithdrawalFeeForTransferValidation);
        worksheet.addValidationData(allowOverdraftValidation);
    }

    private void setNames(Sheet worksheet) {
        Workbook savingsWorkbook = worksheet.getWorkbook();
        List officeNames = this.officeSheetPopulator.getOfficeNames();
        List products = this.productSheetPopulator.getProducts();
        Name officeGroup = savingsWorkbook.createName();
        officeGroup.setNameName("Office");
        officeGroup.setRefersToFormula("Offices!$B$2:$B$" + (officeNames.size() + 1));
        Integer i = 0;
        while (i < officeNames.size()) {
            Object officeNameToBeginEndIndexesOfClients = (Integer[])this.clientSheetPopulator.getOfficeNameToBeginEndIndexesOfClients().get(i);
            Integer[] officeNameToBeginEndIndexesOfStaff = (Integer[])this.personnelSheetPopulator.getOfficeNameToBeginEndIndexesOfStaff().get(i);
            Integer[] officeNameToBeginEndIndexesOfGroups = (Integer[])this.groupSheetPopulator.getOfficeNameToBeginEndIndexesOfGroups().get(i);
            Name clientName = savingsWorkbook.createName();
            Name fieldOfficerName = savingsWorkbook.createName();
            Name groupName = savingsWorkbook.createName();
            if (officeNameToBeginEndIndexesOfStaff != null) {
                this.setSanitized(fieldOfficerName, "Staff_" + (String)officeNames.get(i));
                fieldOfficerName.setRefersToFormula("Staff!$B$" + officeNameToBeginEndIndexesOfStaff[0] + ":$B$" + officeNameToBeginEndIndexesOfStaff[1]);
            }
            if (officeNameToBeginEndIndexesOfClients != null) {
                this.setSanitized(clientName, "Client_" + (String)officeNames.get(i));
                clientName.setRefersToFormula("Clients!$B$" + officeNameToBeginEndIndexesOfClients[0] + ":$B$" + officeNameToBeginEndIndexesOfClients[1]);
            }
            if (officeNameToBeginEndIndexesOfGroups != null) {
                this.setSanitized(groupName, "Group_" + (String)officeNames.get(i));
                groupName.setRefersToFormula("Groups!$B$" + officeNameToBeginEndIndexesOfGroups[0] + ":$B$" + officeNameToBeginEndIndexesOfGroups[1]);
            }
            officeNameToBeginEndIndexesOfClients = i;
            i = i + 1;
        }
        Name productGroup = savingsWorkbook.createName();
        productGroup.setNameName("Products");
        productGroup.setRefersToFormula("Products!$B$2:$B$" + (this.productSheetPopulator.getProductsSize() + 1));
        Integer i2 = 0;
        while (i2 < products.size()) {
            Name interestRateName = savingsWorkbook.createName();
            Name interestCompoundingPeriodName = savingsWorkbook.createName();
            Name interestPostingPeriodName = savingsWorkbook.createName();
            Name interestCalculationName = savingsWorkbook.createName();
            Name daysInYearName = savingsWorkbook.createName();
            Name minOpeningBalanceName = savingsWorkbook.createName();
            Name lockinPeriodName = savingsWorkbook.createName();
            Name lockinPeriodFrequencyName = savingsWorkbook.createName();
            Name currencyName = savingsWorkbook.createName();
            Name decimalPlacesName = savingsWorkbook.createName();
            Name inMultiplesOfName = savingsWorkbook.createName();
            Name withdrawalFeeName = savingsWorkbook.createName();
            Name allowOverdraftName = savingsWorkbook.createName();
            Name overdraftLimitName = savingsWorkbook.createName();
            SavingsProductData product = (SavingsProductData)products.get(i2);
            String productName = product.getName();
            if (product.getNominalAnnualInterestRate() != null) {
                this.setSanitized(interestRateName, "Interest_Rate_" + productName);
                interestRateName.setRefersToFormula("Products!$C$" + (i2 + 2));
            }
            this.setSanitized(interestCompoundingPeriodName, "Interest_Compouding_" + productName);
            this.setSanitized(interestPostingPeriodName, "Interest_Posting_" + productName);
            this.setSanitized(interestCalculationName, "Interest_Calculation_" + productName);
            this.setSanitized(daysInYearName, "Days_In_Year_" + productName);
            this.setSanitized(currencyName, "Currency_" + productName);
            this.setSanitized(decimalPlacesName, "Decimal_Places_" + productName);
            this.setSanitized(withdrawalFeeName, "Withdrawal_Fee_" + productName);
            this.setSanitized(allowOverdraftName, "Overdraft_" + productName);
            interestCompoundingPeriodName.setRefersToFormula("Products!$D$" + (i2 + 2));
            interestPostingPeriodName.setRefersToFormula("Products!$E$" + (i2 + 2));
            interestCalculationName.setRefersToFormula("Products!$F$" + (i2 + 2));
            daysInYearName.setRefersToFormula("Products!$G$" + (i2 + 2));
            currencyName.setRefersToFormula("Products!$K$" + (i2 + 2));
            decimalPlacesName.setRefersToFormula("Products!$L$" + (i2 + 2));
            withdrawalFeeName.setRefersToFormula("Products!$N$" + (i2 + 2));
            allowOverdraftName.setRefersToFormula("Products!$O$" + (i2 + 2));
            if (product.getOverdraftLimit() != null) {
                this.setSanitized(overdraftLimitName, "Overdraft_Limit_" + productName);
                overdraftLimitName.setRefersToFormula("Products!$P$" + (i2 + 2));
            }
            if (product.getMinRequiredOpeningBalance() != null) {
                this.setSanitized(minOpeningBalanceName, "Min_Balance_" + productName);
                minOpeningBalanceName.setRefersToFormula("Products!$H$" + (i2 + 2));
            }
            if (product.getLockinPeriodFrequency() != null) {
                this.setSanitized(lockinPeriodName, "Lockin_Period_" + productName);
                lockinPeriodName.setRefersToFormula("Products!$I$" + (i2 + 2));
            }
            if (product.getLockinPeriodFrequencyType() != null) {
                this.setSanitized(lockinPeriodFrequencyName, "Lockin_Frequency_" + productName);
                lockinPeriodFrequencyName.setRefersToFormula("Products!$J$" + (i2 + 2));
            }
            if (product.getCurrency().getInMultiplesOf() != null) {
                this.setSanitized(inMultiplesOfName, "In_Multiples_" + productName);
                inMultiplesOfName.setRefersToFormula("Products!$M$" + (i2 + 2));
            }
            Integer n = i2;
            i2 = i2 + 1;
        }
    }
}

