/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.jobs.executereportmailingjobs;

import jakarta.ws.rs.core.MultivaluedMap;
import jakarta.ws.rs.core.Response;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.dataqueries.domain.Report;
import org.apache.fineract.infrastructure.dataqueries.service.ReadReportingService;
import org.apache.fineract.infrastructure.report.provider.ReportingProcessServiceProvider;
import org.apache.fineract.infrastructure.report.service.ReportingProcessService;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobEmailAttachmentFileFormat;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobEmailData;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobPreviousRunStatus;
import org.apache.fineract.infrastructure.reportmailingjob.data.ReportMailingJobStretchyReportParamDateOption;
import org.apache.fineract.infrastructure.reportmailingjob.domain.ReportMailingJob;
import org.apache.fineract.infrastructure.reportmailingjob.domain.ReportMailingJobRepository;
import org.apache.fineract.infrastructure.reportmailingjob.domain.ReportMailingJobRunHistory;
import org.apache.fineract.infrastructure.reportmailingjob.domain.ReportMailingJobRunHistoryRepository;
import org.apache.fineract.infrastructure.reportmailingjob.service.ReportMailingJobEmailService;
import org.apache.fineract.infrastructure.reportmailingjob.util.ReportMailingJobDateUtil;
import org.apache.fineract.infrastructure.reportmailingjob.validation.ReportMailingJobValidator;
import org.apache.fineract.portfolio.calendar.service.CalendarUtils;
import org.glassfish.jersey.internal.util.collection.MultivaluedStringMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepContribution;
import org.springframework.batch.core.scope.context.ChunkContext;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.batch.repeat.RepeatStatus;

public class ExecuteReportMailingJobsTasklet
implements Tasklet {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ExecuteReportMailingJobsTasklet.class);
    private final ReportMailingJobRepository reportMailingJobRepository;
    private final ReportMailingJobValidator reportMailingJobValidator;
    private final ReadReportingService readReportingService;
    private final ReportingProcessServiceProvider reportingProcessServiceProvider;
    private final ReportMailingJobEmailService reportMailingJobEmailService;
    private final ReportMailingJobRunHistoryRepository reportMailingJobRunHistoryRepository;
    private final FineractProperties fineractProperties;
    private static final String DATETIME_FORMAT = "yyyy-MM-dd HH:mm:ss";

    public RepeatStatus execute(StepContribution contribution, ChunkContext chunkContext) throws Exception {
        Collection reportMailingJobCollection = this.reportMailingJobRepository.findByIsActiveTrueAndIsDeletedFalse();
        for (ReportMailingJob reportMailingJob : reportMailingJobCollection) {
            ReportMailingJobEmailAttachmentFileFormat emailAttachmentFileFormat;
            LocalDateTime localDateTimeOftenant = DateUtils.getLocalDateTimeOfTenant();
            LocalDateTime nextRunDateTime = reportMailingJob.getNextRunDateTime();
            if (nextRunDateTime == null || !DateUtils.isBefore((LocalDateTime)nextRunDateTime, (LocalDateTime)localDateTimeOftenant) || (emailAttachmentFileFormat = ReportMailingJobEmailAttachmentFileFormat.newInstance((String)reportMailingJob.getEmailAttachmentFileFormat())) == null || !emailAttachmentFileFormat.isValid()) continue;
            Report stretchyReport = reportMailingJob.getStretchyReport();
            String reportName = stretchyReport != null ? stretchyReport.getReportName() : null;
            StringBuilder errorLog = new StringBuilder();
            HashMap validateStretchyReportParamMap = this.reportMailingJobValidator.validateStretchyReportParamMap(reportMailingJob.getStretchyReportParamMap());
            MultivaluedStringMap reportParams = new MultivaluedStringMap();
            if (validateStretchyReportParamMap != null) {
                for (Map.Entry validateStretchyReportParamMapEntry : validateStretchyReportParamMap.entrySet()) {
                    ReportMailingJobStretchyReportParamDateOption reportMailingJobStretchyReportParamDateOption;
                    String key = (String)validateStretchyReportParamMapEntry.getKey();
                    String value = (String)validateStretchyReportParamMapEntry.getValue();
                    if (StringUtils.containsIgnoreCase((CharSequence)key, (CharSequence)"date") && (reportMailingJobStretchyReportParamDateOption = ReportMailingJobStretchyReportParamDateOption.newInstance((String)value)).isValid()) {
                        value = ReportMailingJobDateUtil.getDateAsString((ReportMailingJobStretchyReportParamDateOption)reportMailingJobStretchyReportParamDateOption);
                    }
                    reportParams.add((Object)key, (Object)value);
                }
            }
            this.generateReportOutputStream(reportMailingJob, emailAttachmentFileFormat, (MultivaluedMap)reportParams, reportName, errorLog);
            this.updateReportMailingJobAfterJobExecution(reportMailingJob, errorLog, localDateTimeOftenant);
        }
        return RepeatStatus.FINISHED;
    }

    private void generateReportOutputStream(ReportMailingJob reportMailingJob, ReportMailingJobEmailAttachmentFileFormat emailAttachmentFileFormat, MultivaluedMap<String, String> reportParams, String reportName, StringBuilder errorLog) {
        try {
            boolean isSelfServiceUserReport = false;
            String reportType = this.readReportingService.getReportType(reportName, false, false);
            ReportingProcessService reportingProcessService = this.reportingProcessServiceProvider.findReportingProcessService(reportType);
            if (reportingProcessService != null) {
                Object responseObject;
                Response processReport = reportingProcessService.processRequest(reportName, reportParams);
                Object object = responseObject = processReport != null ? processReport.getEntity() : null;
                if (responseObject != null && responseObject.getClass().equals(ByteArrayOutputStream.class)) {
                    ByteArrayOutputStream byteArrayOutputStream = (ByteArrayOutputStream)responseObject;
                    String fileLocation = this.fineractProperties.getContent().getFilesystem().getRootFolder() + File.separator;
                    String fileNameWithoutExtension = fileLocation + File.separator + reportName;
                    if (!new File(fileLocation).isDirectory()) {
                        new File(fileLocation).mkdirs();
                    }
                    if (byteArrayOutputStream.size() == 0) {
                        errorLog.append("Report processing failed, empty output stream created");
                    } else if (errorLog != null && errorLog.length() == 0 && byteArrayOutputStream.size() > 0) {
                        String fileName = fileNameWithoutExtension + "." + emailAttachmentFileFormat.getValue();
                        this.sendReportFileToEmailRecipients(reportMailingJob, fileName, byteArrayOutputStream, errorLog);
                    }
                } else {
                    errorLog.append("Response object entity is not equal to ByteArrayOutputStream ---------- ");
                }
            } else {
                errorLog.append("There is no ReportingProcessService registered in the ReportingProcessServiceProvider for this report type: ").append(reportType);
            }
        }
        catch (Exception e) {
            errorLog.append("The ReportMailingJobWritePlatformServiceImpl.generateReportOutputStream method threw an Exception: ").append(e).append(" ---------- ");
        }
    }

    private void updateReportMailingJobAfterJobExecution(ReportMailingJob reportMailingJob, StringBuilder errorLog, LocalDateTime jobStartDateTime) {
        String recurrence = reportMailingJob.getRecurrence();
        LocalDateTime nextRunDateTime = reportMailingJob.getNextRunDateTime();
        ReportMailingJobPreviousRunStatus reportMailingJobPreviousRunStatus = ReportMailingJobPreviousRunStatus.SUCCESS;
        reportMailingJob.setPreviousRunErrorLog(null);
        if (errorLog != null && errorLog.length() > 0) {
            reportMailingJobPreviousRunStatus = ReportMailingJobPreviousRunStatus.ERROR;
            reportMailingJob.setPreviousRunErrorLog(errorLog.toString());
        }
        reportMailingJob.increaseNumberOfRunsByOne();
        reportMailingJob.setPreviousRunStatus(reportMailingJobPreviousRunStatus.getValue());
        reportMailingJob.setPreviousRunDateTime(reportMailingJob.getNextRunDateTime());
        if (StringUtils.isEmpty((CharSequence)recurrence)) {
            reportMailingJob.setActive(false);
            reportMailingJob.setNextRunDateTime(null);
        } else if (nextRunDateTime != null) {
            LocalDateTime nextRecurringDateTime = this.createNextRecurringDateTime(recurrence, nextRunDateTime);
            reportMailingJob.setNextRunDateTime(nextRecurringDateTime);
        }
        this.reportMailingJobRepository.save((Object)reportMailingJob);
        this.createReportMailingJobRunHistroryAfterJobExecution(reportMailingJob, errorLog, jobStartDateTime, reportMailingJobPreviousRunStatus.getValue());
    }

    private void sendReportFileToEmailRecipients(ReportMailingJob reportMailingJob, String fileName, ByteArrayOutputStream byteArrayOutputStream, StringBuilder errorLog) {
        Set emailRecipients = this.reportMailingJobValidator.validateEmailRecipients(reportMailingJob.getEmailRecipients());
        try {
            File file = new File(fileName);
            FileOutputStream outputStream = new FileOutputStream(file);
            byteArrayOutputStream.writeTo(outputStream);
            for (String emailRecipient : emailRecipients) {
                ReportMailingJobEmailData reportMailingJobEmailData = new ReportMailingJobEmailData().setTo(emailRecipient).setText(reportMailingJob.getEmailMessage()).setSubject(reportMailingJob.getEmailSubject()).setAttachment(file);
                this.reportMailingJobEmailService.sendEmailWithAttachment(reportMailingJobEmailData);
            }
            outputStream.close();
        }
        catch (IOException e) {
            errorLog.append("The ReportMailingJobWritePlatformServiceImpl.sendReportFileToEmailRecipients method threw an IOException exception: ").append(e).append(" ---------- ");
        }
    }

    private LocalDateTime createNextRecurringDateTime(String recurrencePattern, LocalDateTime startDateTime) {
        LocalDateTime nextRecurringDateTime = null;
        if (StringUtils.isNotBlank((CharSequence)recurrencePattern) && startDateTime != null) {
            LocalDate nextDayLocalDate = startDateTime.plus(Duration.ofDays(1L)).toLocalDate();
            LocalDate nextRecurringLocalDate = CalendarUtils.getNextRecurringDate((String)recurrencePattern, (LocalDate)startDateTime.toLocalDate(), (LocalDate)nextDayLocalDate);
            String nextDateTimeString = String.valueOf(nextRecurringLocalDate) + " " + startDateTime.getHour() + ":" + startDateTime.getMinute() + ":" + startDateTime.getSecond();
            DateTimeFormatter dateTimeFormatter = DateTimeFormatter.ofPattern(DATETIME_FORMAT);
            nextRecurringDateTime = LocalDateTime.parse(nextDateTimeString, dateTimeFormatter);
        }
        return nextRecurringDateTime;
    }

    private void createReportMailingJobRunHistroryAfterJobExecution(ReportMailingJob reportMailingJob, StringBuilder errorLog, LocalDateTime jobStartDateTime, String jobRunStatus) {
        LocalDateTime jobEndDateTime = DateUtils.getLocalDateTimeOfTenant();
        String errorLogToString = errorLog != null ? errorLog.toString() : null;
        ReportMailingJobRunHistory reportMailingJobRunHistory = ReportMailingJobRunHistory.newInstance((ReportMailingJob)reportMailingJob, (LocalDateTime)jobStartDateTime, (LocalDateTime)jobEndDateTime, (String)jobRunStatus, null, (String)errorLogToString);
        this.reportMailingJobRunHistoryRepository.save((Object)reportMailingJobRunHistory);
    }

    @Generated
    public ExecuteReportMailingJobsTasklet(ReportMailingJobRepository reportMailingJobRepository, ReportMailingJobValidator reportMailingJobValidator, ReadReportingService readReportingService, ReportingProcessServiceProvider reportingProcessServiceProvider, ReportMailingJobEmailService reportMailingJobEmailService, ReportMailingJobRunHistoryRepository reportMailingJobRunHistoryRepository, FineractProperties fineractProperties) {
        this.reportMailingJobRepository = reportMailingJobRepository;
        this.reportMailingJobValidator = reportMailingJobValidator;
        this.readReportingService = readReportingService;
        this.reportingProcessServiceProvider = reportingProcessServiceProvider;
        this.reportMailingJobEmailService = reportMailingJobEmailService;
        this.reportMailingJobRunHistoryRepository = reportMailingJobRunHistoryRepository;
        this.fineractProperties = fineractProperties;
    }
}

