/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.campaigns.sms.service;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.ObjectMapper;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.InvalidParameterException;
import java.time.OffsetDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import lombok.Generated;
import org.apache.fineract.infrastructure.campaigns.sms.constants.SmsCampaignTriggerType;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaign;
import org.apache.fineract.infrastructure.campaigns.sms.domain.SmsCampaignRepository;
import org.apache.fineract.infrastructure.campaigns.sms.exception.SmsRuntimeException;
import org.apache.fineract.infrastructure.campaigns.sms.serialization.SmsCampaignValidator;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignDomainService;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignDomainServiceImpl;
import org.apache.fineract.infrastructure.campaigns.sms.service.SmsCampaignWritePlatformService;
import org.apache.fineract.infrastructure.core.service.DateUtils;
import org.apache.fineract.infrastructure.event.business.BusinessEventListener;
import org.apache.fineract.infrastructure.event.business.domain.client.ClientActivateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.client.ClientRejectBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanApprovedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.LoanRejectedBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.loan.transaction.LoanTransactionMakeRepaymentPostBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsActivateBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.SavingsRejectBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.transaction.SavingsDepositBusinessEvent;
import org.apache.fineract.infrastructure.event.business.domain.savings.transaction.SavingsWithdrawalBusinessEvent;
import org.apache.fineract.infrastructure.event.business.service.BusinessEventNotifierService;
import org.apache.fineract.infrastructure.sms.domain.SmsMessage;
import org.apache.fineract.infrastructure.sms.domain.SmsMessageRepository;
import org.apache.fineract.infrastructure.sms.scheduler.SmsMessageScheduledJobService;
import org.apache.fineract.organisation.office.domain.Office;
import org.apache.fineract.organisation.office.domain.OfficeRepository;
import org.apache.fineract.organisation.office.exception.OfficeNotFoundException;
import org.apache.fineract.portfolio.client.domain.Client;
import org.apache.fineract.portfolio.group.domain.Group;
import org.apache.fineract.portfolio.group.domain.GroupRepository;
import org.apache.fineract.portfolio.group.exception.GroupNotFoundException;
import org.apache.fineract.portfolio.loanaccount.domain.Loan;
import org.apache.fineract.portfolio.loanaccount.domain.LoanTransaction;
import org.apache.fineract.portfolio.loanaccount.exception.InvalidLoanTypeException;
import org.apache.fineract.portfolio.savings.domain.SavingsAccount;
import org.apache.fineract.portfolio.savings.domain.SavingsAccountTransaction;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class SmsCampaignDomainServiceImpl
implements SmsCampaignDomainService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(SmsCampaignDomainServiceImpl.class);
    private final SmsCampaignRepository smsCampaignRepository;
    private final SmsMessageRepository smsMessageRepository;
    private final OfficeRepository officeRepository;
    private final BusinessEventNotifierService businessEventNotifierService;
    private final SmsCampaignWritePlatformService smsCampaignWritePlatformCommandHandler;
    private final GroupRepository groupRepository;
    private final SmsMessageScheduledJobService smsMessageScheduledJobService;
    private final SmsCampaignValidator smsCampaignValidator;

    @PostConstruct
    public void addListeners() {
        this.businessEventNotifierService.addPostBusinessEventListener(LoanApprovedBusinessEvent.class, (BusinessEventListener)new SendSmsOnLoanApproved(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanRejectedBusinessEvent.class, (BusinessEventListener)new SendSmsOnLoanRejected(this));
        this.businessEventNotifierService.addPostBusinessEventListener(LoanTransactionMakeRepaymentPostBusinessEvent.class, (BusinessEventListener)new SendSmsOnLoanRepayment(this));
        this.businessEventNotifierService.addPostBusinessEventListener(ClientActivateBusinessEvent.class, (BusinessEventListener)new ClientActivatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(ClientRejectBusinessEvent.class, (BusinessEventListener)new ClientRejectedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(SavingsActivateBusinessEvent.class, (BusinessEventListener)new SavingsAccountActivatedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(SavingsRejectBusinessEvent.class, (BusinessEventListener)new SavingsAccountRejectedListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(SavingsDepositBusinessEvent.class, (BusinessEventListener)new DepositSavingsAccountTransactionListener(this));
        this.businessEventNotifierService.addPostBusinessEventListener(SavingsWithdrawalBusinessEvent.class, (BusinessEventListener)new NonDepositSavingsAccountTransactionListener(this));
    }

    private void notifyRejectedLoanOwner(Loan loan) {
        List smsCampaigns = this.retrieveSmsCampaigns("Loan Rejected");
        if (!smsCampaigns.isEmpty()) {
            for (SmsCampaign campaign : smsCampaigns) {
                if (!campaign.isActive()) continue;
                this.smsCampaignWritePlatformCommandHandler.insertDirectCampaignIntoSmsOutboundTable(loan, campaign);
            }
        }
    }

    private void notifyAcceptedLoanOwner(Loan loan) {
        List smsCampaigns = this.retrieveSmsCampaigns("Loan Approved");
        if (!smsCampaigns.isEmpty()) {
            for (SmsCampaign campaign : smsCampaigns) {
                this.smsCampaignWritePlatformCommandHandler.insertDirectCampaignIntoSmsOutboundTable(loan, campaign);
            }
        }
    }

    private void notifyClientActivated(Client client) {
        List smsCampaigns = this.retrieveSmsCampaigns("Client Activated");
        if (!smsCampaigns.isEmpty()) {
            for (SmsCampaign campaign : smsCampaigns) {
                this.smsCampaignWritePlatformCommandHandler.insertDirectCampaignIntoSmsOutboundTable(client, campaign);
            }
        }
    }

    private void notifyClientRejected(Client client) {
        List smsCampaigns = this.retrieveSmsCampaigns("Client Rejected");
        if (!smsCampaigns.isEmpty()) {
            for (SmsCampaign campaign : smsCampaigns) {
                this.smsCampaignWritePlatformCommandHandler.insertDirectCampaignIntoSmsOutboundTable(client, campaign);
            }
        }
    }

    private void notifySavingsAccountActivated(SavingsAccount savingsAccount) {
        List smsCampaigns = this.retrieveSmsCampaigns("Savings Activated");
        if (!smsCampaigns.isEmpty()) {
            for (SmsCampaign campaign : smsCampaigns) {
                this.smsCampaignWritePlatformCommandHandler.insertDirectCampaignIntoSmsOutboundTable(savingsAccount, campaign);
            }
        }
    }

    private void notifySavingsAccountRejected(SavingsAccount savingsAccount) {
        List smsCampaigns = this.retrieveSmsCampaigns("Savings Rejected");
        if (!smsCampaigns.isEmpty()) {
            for (SmsCampaign campaign : smsCampaigns) {
                this.smsCampaignWritePlatformCommandHandler.insertDirectCampaignIntoSmsOutboundTable(savingsAccount, campaign);
            }
        }
    }

    private void sendSmsForLoanRepayment(LoanTransaction loanTransaction) {
        List smsCampaigns = this.retrieveSmsCampaigns("Loan Repayment");
        if (!smsCampaigns.isEmpty()) {
            for (SmsCampaign smsCampaign : smsCampaigns) {
                try {
                    Loan loan = loanTransaction.getLoan();
                    HashSet<Client> groupClients = new HashSet<Client>();
                    if (loan.hasInvalidLoanType()) {
                        throw new InvalidLoanTypeException("Loan Type cannot be Invalid for the Triggered Sms Campaign", new Object[0]);
                    }
                    if (loan.isGroupLoan()) {
                        Group group = (Group)this.groupRepository.findById((Object)loan.getGroupId()).orElseThrow(() -> new GroupNotFoundException(loan.getGroupId()));
                        groupClients.addAll(group.getClientMembers());
                    } else {
                        groupClients.add(loan.client());
                    }
                    HashMap campaignParams = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    if (groupClients.isEmpty()) continue;
                    for (Client client : groupClients) {
                        HashMap smsParams = this.processRepaymentDataForSms(loanTransaction, client);
                        for (Map.Entry entry : campaignParams.entrySet()) {
                            String value = (String)entry.getValue();
                            String spvalue = null;
                            boolean spkeycheck = smsParams.containsKey(entry.getKey());
                            if (spkeycheck) {
                                spvalue = smsParams.get(entry.getKey()).toString();
                            }
                            if (!spkeycheck || value.equals("-1") || spvalue.equals(value)) continue;
                            if (((String)entry.getKey()).equals("officeId")) {
                                Long officeId = Long.valueOf(value);
                                Office campaignOffice = (Office)this.officeRepository.findById((Object)Long.valueOf(value)).orElseThrow(() -> new OfficeNotFoundException(officeId));
                                if (!campaignOffice.doesNotHaveAnOfficeInHierarchyWithId((Long)client.getOffice().getId())) continue;
                                throw new SmsRuntimeException("error.msg.no.office", "Office not found for the id");
                            }
                            throw new SmsRuntimeException("error.msg.no.id.attribute", "Office Id attribute is notfound");
                        }
                        String message = this.smsCampaignWritePlatformCommandHandler.compileSmsTemplate(smsCampaign.getMessage(), smsCampaign.getCampaignName(), (Map)smsParams);
                        Object mobileNo = smsParams.get("mobileNo");
                        if (!this.smsCampaignValidator.isValidNotificationOrSms(client, smsCampaign, mobileNo)) continue;
                        String mobileNumber = null;
                        if (mobileNo != null) {
                            mobileNumber = mobileNo.toString();
                        }
                        SmsMessage smsMessage = SmsMessage.pendingSms(null, null, (Client)client, null, (String)message, (String)mobileNumber, (SmsCampaign)smsCampaign, (boolean)smsCampaign.isNotification());
                        HashMap<SmsCampaign, List<SmsMessage>> smsDataMap = new HashMap<SmsCampaign, List<SmsMessage>>();
                        smsDataMap.put(smsCampaign, Collections.singletonList(smsMessage));
                        this.smsMessageScheduledJobService.sendTriggeredMessages(smsDataMap);
                    }
                }
                catch (IOException e) {
                    log.error("smsParams does not contain the key: ", (Throwable)e);
                }
                catch (RuntimeException e) {
                    log.debug("Client Office Id and SMS Campaign Office id doesn't match ", (Throwable)e);
                }
            }
        }
    }

    private void sendSmsForSavingsTransaction(SavingsAccountTransaction savingsTransaction, boolean isDeposit) {
        String campaignName = isDeposit ? "Savings Deposit" : "Savings Withdrawal";
        List smsCampaigns = this.retrieveSmsCampaigns(campaignName);
        if (!smsCampaigns.isEmpty()) {
            for (SmsCampaign smsCampaign : smsCampaigns) {
                try {
                    SavingsAccount savingsAccount = savingsTransaction.getSavingsAccount();
                    Client client = savingsAccount.getClient();
                    HashMap campaignParams = (HashMap)new ObjectMapper().readValue(smsCampaign.getParamValue(), (TypeReference)new /* Unavailable Anonymous Inner Class!! */);
                    HashMap smsParams = this.processSavingsTransactionDataForSms(savingsTransaction, client);
                    for (Map.Entry entry : campaignParams.entrySet()) {
                        String value = (String)entry.getValue();
                        String spvalue = null;
                        boolean spkeycheck = smsParams.containsKey(entry.getKey());
                        if (spkeycheck) {
                            spvalue = smsParams.get(entry.getKey()).toString();
                        }
                        if (!spkeycheck || value.equals("-1") || spvalue.equals(value)) continue;
                        if (((String)entry.getKey()).equals("officeId")) {
                            Long officeId = Long.valueOf(value);
                            Office campaignOffice = (Office)this.officeRepository.findById((Object)officeId).orElseThrow(() -> new OfficeNotFoundException(officeId));
                            if (!campaignOffice.doesNotHaveAnOfficeInHierarchyWithId((Long)client.getOffice().getId())) continue;
                            throw new SmsRuntimeException("error.msg.no.office", "Office not found for the id");
                        }
                        throw new SmsRuntimeException("error.msg.no.id.attribute", "Office Id attribute is notfound");
                    }
                    String message = this.smsCampaignWritePlatformCommandHandler.compileSmsTemplate(smsCampaign.getMessage(), smsCampaign.getCampaignName(), (Map)smsParams);
                    Object mobileNo = smsParams.get("mobileNo");
                    if (!this.smsCampaignValidator.isValidNotificationOrSms(client, smsCampaign, mobileNo)) continue;
                    String mobileNumber = null;
                    if (mobileNo != null) {
                        mobileNumber = mobileNo.toString();
                    }
                    SmsMessage smsMessage = SmsMessage.pendingSms(null, null, (Client)client, null, (String)message, (String)mobileNumber, (SmsCampaign)smsCampaign, (boolean)smsCampaign.isNotification());
                    this.smsMessageRepository.save((Object)smsMessage);
                    ArrayList<SmsMessage> messages = new ArrayList<SmsMessage>();
                    messages.add(smsMessage);
                    HashMap<SmsCampaign, ArrayList<SmsMessage>> smsDataMap = new HashMap<SmsCampaign, ArrayList<SmsMessage>>();
                    smsDataMap.put(smsCampaign, messages);
                    this.smsMessageScheduledJobService.sendTriggeredMessages(smsDataMap);
                }
                catch (IOException e) {
                    log.error("smsParams does not contain the key: ", (Throwable)e);
                }
                catch (RuntimeException e) {
                    log.debug("Client Office Id and SMS Campaign Office id doesn't match ", (Throwable)e);
                }
            }
        }
    }

    private List<SmsCampaign> retrieveSmsCampaigns(String paramValue) {
        return this.smsCampaignRepository.findActiveSmsCampaigns("%" + paramValue + "%", SmsCampaignTriggerType.TRIGGERED.getValue());
    }

    private HashMap<String, Object> processRepaymentDataForSms(LoanTransaction loanTransaction, Client groupClient) {
        Client client;
        HashMap<String, Object> smsParams = new HashMap<String, Object>();
        Loan loan = loanTransaction.getLoan();
        if (loan.isGroupLoan() && groupClient != null) {
            client = groupClient;
        } else if (loan.isIndividualLoan()) {
            client = loan.getClient();
        } else {
            throw new InvalidParameterException("");
        }
        DateTimeFormatter timeFormatter = DateTimeFormatter.ofPattern("HH:mm");
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MMM:d:yyyy");
        smsParams.put("id", loanTransaction.getLoan().getClientId());
        smsParams.put("firstname", client.getFirstname());
        smsParams.put("middlename", client.getMiddlename());
        smsParams.put("lastname", client.getLastname());
        smsParams.put("FullName", client.getDisplayName());
        smsParams.put("mobileNo", client.mobileNo());
        smsParams.put("LoanAmount", loan.getPrincipal());
        smsParams.put("LoanOutstanding", loanTransaction.getOutstandingLoanBalance());
        smsParams.put("loanId", loan.getId());
        smsParams.put("LoanAccountId", loan.getAccountNumber());
        smsParams.put("officeId", client.getOffice().getId());
        if (client.getStaff() != null) {
            smsParams.put("loanOfficerId", client.getStaff().getId());
        } else {
            smsParams.put("loanOfficerId", -1);
        }
        OffsetDateTime creationDate = loanTransaction.getCreatedDate().orElse(DateUtils.getAuditOffsetDateTime());
        smsParams.put("repaymentAmount", loanTransaction.getAmount(loan.getCurrency()));
        smsParams.put("RepaymentDate", creationDate.toLocalDate().format(dateFormatter));
        smsParams.put("RepaymentTime", creationDate.toLocalTime().format(timeFormatter));
        if (loanTransaction.getPaymentDetail() != null) {
            smsParams.put("receiptNumber", loanTransaction.getPaymentDetail().getReceiptNumber());
        } else {
            smsParams.put("receiptNumber", -1);
        }
        return smsParams;
    }

    private HashMap<String, Object> processSavingsTransactionDataForSms(SavingsAccountTransaction savingsAccountTransaction, Client client) {
        HashMap<String, Object> smsParams = new HashMap<String, Object>();
        SavingsAccount savingsAccount = savingsAccountTransaction.getSavingsAccount();
        DateTimeFormatter dateFormatter = DateTimeFormatter.ofPattern("MMM:d:yyyy");
        smsParams.put("clientId", client.getId());
        smsParams.put("firstname", client.getFirstname());
        smsParams.put("middlename", client.getMiddlename());
        smsParams.put("lastname", client.getLastname());
        smsParams.put("FullName", client.getDisplayName());
        smsParams.put("mobileNo", client.mobileNo());
        smsParams.put("savingsId", savingsAccount.getId());
        smsParams.put("savingsAccountNo", savingsAccount.getAccountNumber());
        smsParams.put("withdrawAmount", savingsAccountTransaction.getAmount(savingsAccount.getCurrency()));
        smsParams.put("depositAmount", savingsAccountTransaction.getAmount(savingsAccount.getCurrency()));
        smsParams.put("balance", savingsAccount.getWithdrawableBalance());
        smsParams.put("officeId", client.getOffice().getId());
        smsParams.put("transactionDate", savingsAccountTransaction.getTransactionDate().format(dateFormatter));
        smsParams.put("savingsTransactionId", savingsAccountTransaction.getId());
        if (client.getStaff() != null) {
            smsParams.put("loanOfficerId", client.getStaff().getId());
        } else {
            smsParams.put("loanOfficerId", -1);
        }
        if (savingsAccountTransaction.getPaymentDetail() != null) {
            smsParams.put("receiptNumber", savingsAccountTransaction.getPaymentDetail().getReceiptNumber());
        } else {
            smsParams.put("receiptNumber", -1);
        }
        return smsParams;
    }

    @Generated
    public SmsCampaignDomainServiceImpl(SmsCampaignRepository smsCampaignRepository, SmsMessageRepository smsMessageRepository, OfficeRepository officeRepository, BusinessEventNotifierService businessEventNotifierService, SmsCampaignWritePlatformService smsCampaignWritePlatformCommandHandler, GroupRepository groupRepository, SmsMessageScheduledJobService smsMessageScheduledJobService, SmsCampaignValidator smsCampaignValidator) {
        this.smsCampaignRepository = smsCampaignRepository;
        this.smsMessageRepository = smsMessageRepository;
        this.officeRepository = officeRepository;
        this.businessEventNotifierService = businessEventNotifierService;
        this.smsCampaignWritePlatformCommandHandler = smsCampaignWritePlatformCommandHandler;
        this.groupRepository = groupRepository;
        this.smsMessageScheduledJobService = smsMessageScheduledJobService;
        this.smsCampaignValidator = smsCampaignValidator;
    }
}

