/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.configuration.service;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.configuration.service.MoneyHelperInitializationService;
import org.apache.fineract.infrastructure.core.domain.FineractPlatformTenant;
import org.apache.fineract.infrastructure.core.service.tenant.TenantDetailsService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.context.annotation.DependsOn;
import org.springframework.stereotype.Service;

@Service
@DependsOn(value={"tenantDetailsService", "moneyHelperInitializationService", "tenantDatabaseUpgradeService"})
public class MoneyHelperStartupInitializationService
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(MoneyHelperStartupInitializationService.class);
    private final TenantDetailsService tenantDetailsService;
    private final MoneyHelperInitializationService moneyHelperInitializationService;

    public void afterPropertiesSet() throws Exception {
        log.info("Starting MoneyHelper initialization for all tenants...");
        List tenants = this.tenantDetailsService.findAllTenants();
        if (tenants.isEmpty()) {
            log.warn("No tenants found during MoneyHelper initialization");
            return;
        }
        for (FineractPlatformTenant tenant : tenants) {
            String tenantIdentifier = tenant.getTenantIdentifier();
            if (this.moneyHelperInitializationService.isTenantInitialized(tenantIdentifier)) {
                log.debug("MoneyHelper already initialized for tenant: {}", (Object)tenantIdentifier);
                continue;
            }
            this.moneyHelperInitializationService.initializeTenantRoundingMode(tenant);
        }
        log.info("MoneyHelper initialization completed");
    }

    @Generated
    public MoneyHelperStartupInitializationService(TenantDetailsService tenantDetailsService, MoneyHelperInitializationService moneyHelperInitializationService) {
        this.tenantDetailsService = tenantDetailsService;
        this.moneyHelperInitializationService = moneyHelperInitializationService;
    }
}

