/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.core.config;

import com.zaxxer.hikari.HikariConfig;
import com.zaxxer.hikari.HikariDataSource;
import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import jakarta.annotation.PostConstruct;
import java.util.Properties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.context.ApplicationContext;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.Environment;

@Configuration
@ConditionalOnExpression(value="#{ systemEnvironment['fineract_tenants_driver'] != null }")
@Deprecated
public class CompatibilityConfig {
    private static final Logger LOG = LoggerFactory.getLogger(CompatibilityConfig.class);
    @Autowired
    ApplicationContext context;

    @PostConstruct
    @SuppressFBWarnings(value={"SLF4J_SIGN_ONLY_FORMAT"})
    public void init() {
        Environment environment = this.context.getEnvironment();
        LOG.warn("===============================================================================================\n");
        LOG.warn("You are using a deprecated tenant DB configuration:\n");
        LOG.warn("- Env var 'fineract_tenants_driver':                                  {}", (Object)environment.getProperty("fineract_tenants_driver"));
        LOG.warn("- Env var 'fineract_tenants_url':                                     {}", (Object)environment.getProperty("fineract_tenants_url"));
        LOG.warn("- Env var 'fineract_tenants_uid':                                     {}", (Object)environment.getProperty("fineract_tenants_uid"));
        LOG.warn("- Env var 'fineract_tenants_pwd':                                     ****\n");
        LOG.warn("The preferred way to configure the tenant DB is now via these environment variables:\n");
        LOG.warn("- Env var 'FINERACT_HIKARI_DRIVER_SOURCE_CLASS_NAME':                 {}", (Object)environment.getProperty("FINERACT_HIKARI_DRIVER_SOURCE_CLASS_NAME"));
        LOG.warn("- Env var 'FINERACT_HIKARI_JDBC_URL':                                 {}", (Object)environment.getProperty("FINERACT_HIKARI_JDBC_URL"));
        LOG.warn("- Env var 'FINERACT_HIKARI_USERNAME':                                 {}", (Object)environment.getProperty("FINERACT_HIKARI_USERNAME"));
        LOG.warn("- Env var 'FINERACT_HIKARI_PASSWORD':                                 ****");
        LOG.warn("- Env var 'FINERACT_HIKARI_MINIMUM_IDLE':                             {}", (Object)environment.getProperty("FINERACT_HIKARI_MINIMUM_IDLE"));
        LOG.warn("- Env var 'FINERACT_HIKARI_MAXIMUM_POOL_SIZE':                        {}", (Object)environment.getProperty("FINERACT_HIKARI_MAXIMUM_POOL_SIZE"));
        LOG.warn("- Env var 'FINERACT_HIKARI_IDLE_TIMEOUT':                             {}", (Object)environment.getProperty("FINERACT_HIKARI_IDLE_TIMEOUT"));
        LOG.warn("- Env var 'FINERACT_HIKARI_CONNECTION_TIMEOUT':                       {}", (Object)environment.getProperty("FINERACT_HIKARI_CONNECTION_TIMEOUT"));
        LOG.warn("- Env var 'FINERACT_HIKARI_TEST_QUERY':                               {}", (Object)environment.getProperty("FINERACT_HIKARI_TEST_QUERY"));
        LOG.warn("- Env var 'FINERACT_HIKARI_AUTO_COMMIT':                              {}", (Object)environment.getProperty("FINERACT_HIKARI_AUTO_COMMIT"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_CACHE_PREP_STMTS':           {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_CACHE_PREP_STMTS"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_PREP_STMT_CACHE_SIZE':       {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_PREP_STMT_CACHE_SIZE"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_PREP_STMT_CACHE_SQL_LIMIT':  {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_PREP_STMT_CACHE_SQL_LIMIT"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_USE_SERVER_PREP_STMTS':      {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_USE_SERVER_PREP_STMTS"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_USE_LOCAL_SESSION_STATE':    {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_USE_LOCAL_SESSION_STATE"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_REWRITE_BATCHED_STATEMENTS': {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_REWRITE_BATCHED_STATEMENTS"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_CACHE_RESULT_SET_METADATA':  {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_CACHE_RESULT_SET_METADATA"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_CACHE_SERVER_CONFIGURATION': {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_CACHE_SERVER_CONFIGURATION"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_ELIDE_SET_AUTO_COMMITS':     {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_ELIDE_SET_AUTO_COMMITS"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_MAINTAIN_TIME_STATS':        {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_MAINTAIN_TIME_STATS"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_LOG_SLOW_QUERIES':           {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_LOG_SLOW_QUERIES"));
        LOG.warn("- Env var 'FINERACT_HIKARI_DS_PROPERTIES_DUMP_QUERIES_IN_EXCEPTION':  {}", (Object)environment.getProperty("FINERACT_HIKARI_DS_PROPERTIES_DUMP_QUERIES_IN_EXCEPTION"));
        LOG.warn("===============================================================================================\n");
    }

    @Bean(destroyMethod="close")
    public HikariDataSource hikariTenantDataSource(HikariConfig hc) {
        return new HikariDataSource(hc);
    }

    @Bean
    public HikariConfig hikariConfig() {
        Environment environment = this.context.getEnvironment();
        HikariConfig hc = new HikariConfig();
        hc.setDriverClassName(environment.getProperty("fineract_tenants_driver"));
        hc.setJdbcUrl(environment.getProperty("fineract_tenants_url"));
        hc.setUsername(environment.getProperty("fineract_tenants_uid"));
        hc.setPassword(environment.getProperty("fineract_tenants_pwd"));
        hc.setMinimumIdle(3);
        hc.setMaximumPoolSize(10);
        hc.setIdleTimeout(60000L);
        hc.setConnectionTestQuery("SELECT 1");
        hc.setDataSourceProperties(this.dataSourceProperties());
        return hc;
    }

    private Properties dataSourceProperties() {
        Properties props = new Properties();
        props.setProperty("cachePrepStmts", "true");
        props.setProperty("prepStmtCacheSize", "250");
        props.setProperty("prepStmtCacheSqlLimit", "2048");
        props.setProperty("useServerPrepStmts", "true");
        props.setProperty("useLocalSessionState", "true");
        props.setProperty("rewriteBatchedStatements", "true");
        props.setProperty("cacheResultSetMetadata", "true");
        props.setProperty("cacheServerConfiguration", "true");
        props.setProperty("elideSetAutoCommits", "true");
        props.setProperty("maintainTimeStats", "false");
        props.setProperty("logSlowQueries", "true");
        props.setProperty("dumpQueriesOnException", "true");
        return props;
    }
}

