/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.creditbureau.serialization;

import com.google.gson.JsonElement;
import java.lang.reflect.Type;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.fineract.infrastructure.core.data.ApiParameterError;
import org.apache.fineract.infrastructure.core.data.DataValidatorBuilder;
import org.apache.fineract.infrastructure.core.exception.InvalidJsonException;
import org.apache.fineract.infrastructure.core.exception.PlatformApiDataValidationException;
import org.apache.fineract.infrastructure.core.serialization.FromJsonHelper;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CreditBureauLoanProductCommandFromApiJsonDeserializer {
    public static final String LOAN_PRODUCT_ID = "loanProductId";
    public static final String IS_CREDITCHECK_MANDATORY = "isCreditcheckMandatory";
    public static final String SKIP_CREDITCHECK_IN_FAILURE = "skipCreditcheckInFailure";
    public static final String STALE_PERIOD = "stalePeriod";
    public static final String IS_ACTIVE = "isActive";
    public static final String LOCALE = "locale";
    public static final String CREDITBUREAU_LOAN_PRODUCT_MAPPING_ID = "creditbureauLoanProductMappingId";
    private static final Set<String> SUPPORTED_PARAMETERS = new HashSet<String>(Arrays.asList("loanProductId", "isCreditcheckMandatory", "skipCreditcheckInFailure", "stalePeriod", "isActive", "locale", "creditbureauLoanProductMappingId"));
    private final FromJsonHelper fromApiJsonHelper;

    @Autowired
    public CreditBureauLoanProductCommandFromApiJsonDeserializer(FromJsonHelper fromApiJsonHelper) {
        this.fromApiJsonHelper = fromApiJsonHelper;
    }

    public void validateForCreate(String json, Long cb_id) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("CREDITBUREAU_LOANPRODUCT_MAPPING");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        baseDataValidator.reset().value((Object)cb_id).notBlank().integerGreaterThanZero();
        long loanProductId = this.fromApiJsonHelper.extractLongNamed(LOAN_PRODUCT_ID, element);
        baseDataValidator.reset().parameter(LOAN_PRODUCT_ID).value((Object)loanProductId).notBlank().integerGreaterThanZero();
        if (this.fromApiJsonHelper.extractBooleanNamed(IS_CREDITCHECK_MANDATORY, element) != null) {
            boolean isCreditcheckMandatory = this.fromApiJsonHelper.extractBooleanNamed(IS_CREDITCHECK_MANDATORY, element);
            baseDataValidator.reset().parameter(IS_CREDITCHECK_MANDATORY).value((Object)isCreditcheckMandatory).notBlank().trueOrFalseRequired((Object)isCreditcheckMandatory);
        } else {
            baseDataValidator.reset().parameter(IS_CREDITCHECK_MANDATORY).value((Object)this.fromApiJsonHelper.extractBooleanNamed(IS_CREDITCHECK_MANDATORY, element)).notBlank().trueOrFalseRequired((Object)this.fromApiJsonHelper.extractBooleanNamed(IS_CREDITCHECK_MANDATORY, element));
        }
        if (this.fromApiJsonHelper.extractBooleanNamed(SKIP_CREDITCHECK_IN_FAILURE, element) != null) {
            boolean skipCreditcheckInFailure = this.fromApiJsonHelper.extractBooleanNamed(SKIP_CREDITCHECK_IN_FAILURE, element);
            baseDataValidator.reset().parameter(SKIP_CREDITCHECK_IN_FAILURE).value((Object)skipCreditcheckInFailure).notBlank().trueOrFalseRequired((Object)skipCreditcheckInFailure);
        } else {
            baseDataValidator.reset().parameter(SKIP_CREDITCHECK_IN_FAILURE).value((Object)this.fromApiJsonHelper.extractBooleanNamed(SKIP_CREDITCHECK_IN_FAILURE, element)).notBlank().trueOrFalseRequired((Object)this.fromApiJsonHelper.extractBooleanNamed(SKIP_CREDITCHECK_IN_FAILURE, element));
        }
        if (this.fromApiJsonHelper.extractLongNamed(STALE_PERIOD, element) != null) {
            long stalePeriod = this.fromApiJsonHelper.extractLongNamed(STALE_PERIOD, element);
            baseDataValidator.reset().parameter(STALE_PERIOD).value((Object)stalePeriod).notBlank().integerGreaterThanZero();
        } else {
            baseDataValidator.reset().parameter(STALE_PERIOD).value((Object)this.fromApiJsonHelper.extractLongNamed(STALE_PERIOD, element)).notBlank().integerGreaterThanZero();
        }
        if (this.fromApiJsonHelper.extractBooleanNamed(IS_ACTIVE, element) != null) {
            Boolean isActive = this.fromApiJsonHelper.extractBooleanNamed(IS_ACTIVE, element);
            if (isActive == null) {
                isActive = false;
            } else {
                baseDataValidator.reset().parameter(IS_ACTIVE).value((Object)isActive).notBlank().trueOrFalseRequired((Object)isActive);
            }
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    public void validateForUpdate(String json) {
        if (StringUtils.isBlank((CharSequence)json)) {
            throw new InvalidJsonException();
        }
        Type typeOfMap = new /* Unavailable Anonymous Inner Class!! */.getType();
        this.fromApiJsonHelper.checkForUnsupportedParameters(typeOfMap, json, (Collection)SUPPORTED_PARAMETERS);
        ArrayList dataValidationErrors = new ArrayList();
        DataValidatorBuilder baseDataValidator = new DataValidatorBuilder(dataValidationErrors).resource("CREDITBUREAU_LOANPRODUCT_MAPPING");
        JsonElement element = this.fromApiJsonHelper.parse(json);
        String creditbureauLoanProductMappingIdParameter = CREDITBUREAU_LOAN_PRODUCT_MAPPING_ID;
        if (this.fromApiJsonHelper.parameterExists(CREDITBUREAU_LOAN_PRODUCT_MAPPING_ID, element)) {
            Long creditbureauLoanProductMappingId = this.fromApiJsonHelper.extractLongNamed(CREDITBUREAU_LOAN_PRODUCT_MAPPING_ID, element);
            baseDataValidator.reset().parameter(CREDITBUREAU_LOAN_PRODUCT_MAPPING_ID).value((Object)creditbureauLoanProductMappingId).notNull().notBlank().longGreaterThanZero();
        }
        String is_activeParameter = IS_ACTIVE;
        if (this.fromApiJsonHelper.parameterExists(IS_ACTIVE, element)) {
            boolean isActive = this.fromApiJsonHelper.extractBooleanNamed(IS_ACTIVE, element);
            baseDataValidator.reset().parameter(IS_ACTIVE).value((Object)isActive).notNull().notBlank().trueOrFalseRequired((Object)isActive);
        }
        this.throwExceptionIfValidationWarningsExist(dataValidationErrors);
    }

    private void throwExceptionIfValidationWarningsExist(List<ApiParameterError> dataValidationErrors) {
        if (!dataValidationErrors.isEmpty()) {
            throw new PlatformApiDataValidationException("validation.msg.validation.errors.exist", "Validation errors exist.", dataValidationErrors);
        }
    }
}

