/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.event.external.config;

import jakarta.jms.ConnectionFactory;
import org.apache.activemq.ActiveMQConnectionFactory;
import org.apache.activemq.command.ActiveMQQueue;
import org.apache.activemq.command.ActiveMQTopic;
import org.apache.fineract.infrastructure.core.config.FineractProperties;
import org.apache.fineract.infrastructure.event.external.config.EnableExternalEventQueueCondition;
import org.apache.fineract.infrastructure.event.external.config.EnableExternalEventTopicCondition;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;
import org.springframework.jms.connection.CachingConnectionFactory;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;

@Configuration
@ConditionalOnProperty(value={"fineract.events.external.producer.jms.enabled"}, havingValue="true")
public class ExternalEventJMSConfiguration {
    @Autowired
    private FineractProperties fineractProperties;

    @Bean(name={"externalEventConnectionFactory"})
    public CachingConnectionFactory connectionFactory() {
        FineractProperties.FineractExternalEventsProducerJmsProperties jmsProps = this.fineractProperties.getEvents().getExternal().getProducer().getJms();
        ActiveMQConnectionFactory connectionFactory = new ActiveMQConnectionFactory();
        connectionFactory.setBrokerURL(jmsProps.getBrokerUrl());
        connectionFactory.setUseAsyncSend(jmsProps.isAsyncSendEnabled());
        connectionFactory.setTrustAllPackages(true);
        if (jmsProps.isBrokerPasswordProtected()) {
            connectionFactory.setUserName(jmsProps.getBrokerUsername());
            connectionFactory.setPassword(jmsProps.getBrokerPassword());
        }
        CachingConnectionFactory cachingConnectionFactory = new CachingConnectionFactory();
        cachingConnectionFactory.setSessionCacheSize(jmsProps.getProducerCount());
        cachingConnectionFactory.setReconnectOnException(true);
        cachingConnectionFactory.setTargetConnectionFactory((ConnectionFactory)connectionFactory);
        return cachingConnectionFactory;
    }

    @Conditional(value={EnableExternalEventTopicCondition.class})
    @Bean(name={"externalEventDestination"})
    public ActiveMQTopic activeMqTopic() {
        return new ActiveMQTopic(this.fineractProperties.getEvents().getExternal().getProducer().getJms().getEventTopicName());
    }

    @Conditional(value={EnableExternalEventQueueCondition.class})
    @Bean(name={"externalEventDestination"})
    public ActiveMQQueue activeMqQueue() {
        return new ActiveMQQueue(this.fineractProperties.getEvents().getExternal().getProducer().getJms().getEventQueueName());
    }

    @Bean(value={"externalEventJmsProducerExecutor"})
    public ThreadPoolTaskExecutor externalEventJmsProducerExecutor() {
        ThreadPoolTaskExecutor threadPoolTaskExecutor = new ThreadPoolTaskExecutor();
        threadPoolTaskExecutor.setCorePoolSize(this.fineractProperties.getEvents().getExternal().getProducer().getJms().getThreadPoolTaskExecutorCorePoolSize());
        threadPoolTaskExecutor.setMaxPoolSize(this.fineractProperties.getEvents().getExternal().getProducer().getJms().getThreadPoolTaskExecutorMaxPoolSize());
        threadPoolTaskExecutor.setThreadNamePrefix("externalEventJms");
        return threadPoolTaskExecutor;
    }
}

