/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.hooks.listener;

import java.util.List;
import lombok.Generated;
import org.apache.fineract.infrastructure.core.domain.FineractContext;
import org.apache.fineract.infrastructure.core.service.ThreadLocalContextUtil;
import org.apache.fineract.infrastructure.hooks.domain.Hook;
import org.apache.fineract.infrastructure.hooks.event.HookEvent;
import org.apache.fineract.infrastructure.hooks.event.HookEventSource;
import org.apache.fineract.infrastructure.hooks.listener.HookListener;
import org.apache.fineract.infrastructure.hooks.processor.HookProcessor;
import org.apache.fineract.infrastructure.hooks.processor.HookProcessorProvider;
import org.apache.fineract.infrastructure.hooks.service.HookReadPlatformService;
import org.apache.fineract.useradministration.domain.AppUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class FineractHookListener
implements HookListener {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FineractHookListener.class);
    private final HookProcessorProvider hookProcessorProvider;
    private final HookReadPlatformService hookReadPlatformService;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onApplicationEvent(HookEvent event) {
        try {
            ThreadLocalContextUtil.init((FineractContext)event.getContext());
            AppUser appUser = event.getAppUser();
            HookEventSource hookEventSource = (HookEventSource)event.getSource();
            FineractContext fineractContext = event.getContext();
            String entityName = hookEventSource.getEntityName();
            String actionName = hookEventSource.getActionName();
            String payload = event.getPayload();
            List hooks = this.hookReadPlatformService.retrieveHooksByEvent(hookEventSource.getEntityName(), hookEventSource.getActionName());
            for (Hook hook : hooks) {
                HookProcessor processor = this.hookProcessorProvider.getProcessor(hook);
                try {
                    processor.process(hook, payload, entityName, actionName, fineractContext);
                }
                catch (Throwable e) {
                    log.error("Hook {} failed in HookProcessor {} for tenantIdentifier/user {}/{}, entityName: {}, actionName: {}, payload {} ", new Object[]{hook.getId(), processor.getClass().getSimpleName(), fineractContext.getTenantContext().getTenantIdentifier(), appUser.getDisplayName(), entityName, actionName, payload, e});
                }
            }
        }
        finally {
            ThreadLocalContextUtil.reset();
        }
    }

    @Generated
    public FineractHookListener(HookProcessorProvider hookProcessorProvider, HookReadPlatformService hookReadPlatformService) {
        this.hookProcessorProvider = hookProcessorProvider;
        this.hookReadPlatformService = hookReadPlatformService;
    }
}

