/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fineract.infrastructure.jobs.service.updatenpa;

import org.apache.fineract.infrastructure.core.service.database.DatabaseSpecificSQLGenerator;
import org.apache.fineract.infrastructure.core.service.database.DatabaseTypeResolver;
import org.apache.fineract.infrastructure.core.service.database.RoutingDataSourceServiceFactory;
import org.apache.fineract.infrastructure.jobs.service.JobName;
import org.apache.fineract.infrastructure.jobs.service.updatenpa.UpdateNpaTasklet;
import org.apache.fineract.infrastructure.security.service.PlatformSecurityContext;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.builder.SimpleJobBuilder;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.repository.JobRepository;
import org.springframework.batch.core.step.builder.StepBuilder;
import org.springframework.batch.core.step.tasklet.Tasklet;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.transaction.PlatformTransactionManager;

@Configuration
public class UpdateNpaConfig {
    @Autowired
    private JobRepository jobRepository;
    @Autowired
    private PlatformTransactionManager transactionManager;
    @Autowired
    private RoutingDataSourceServiceFactory dataSourceServiceFactory;
    @Autowired
    private DatabaseTypeResolver databaseTypeResolver;
    @Autowired
    private DatabaseSpecificSQLGenerator sqlGenerator;
    @Autowired
    private PlatformSecurityContext platformSecurityContext;

    @Bean
    protected Step updateNpaStep() {
        return new StepBuilder(JobName.UPDATE_NPA.name(), this.jobRepository).tasklet((Tasklet)this.updateNpaTasklet(), this.transactionManager).build();
    }

    @Bean
    public Job updateNpaJob() {
        return ((SimpleJobBuilder)new JobBuilder(JobName.UPDATE_NPA.name(), this.jobRepository).start(this.updateNpaStep()).incrementer((JobParametersIncrementer)new RunIdIncrementer())).build();
    }

    @Bean
    public UpdateNpaTasklet updateNpaTasklet() {
        return new UpdateNpaTasklet(this.dataSourceServiceFactory, this.databaseTypeResolver, this.sqlGenerator, this.platformSecurityContext);
    }
}

